/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.I_CmsFormValidator;
import org.opencms.gwt.I_CmsValidationService;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsAvailabilityInfoBean;
import org.opencms.gwt.shared.CmsCategoryTreeEntry;
import org.opencms.gwt.shared.CmsContextMenuEntryBean;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.gwt.shared.CmsLockInfo;
import org.opencms.gwt.shared.CmsReturnLinkInfo;
import org.opencms.gwt.shared.CmsValidationQuery;
import org.opencms.gwt.shared.CmsValidationResult;
import org.opencms.gwt.shared.rpc.I_CmsCoreService;
import org.opencms.i18n.CmsEncoder;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceAction;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorer;
import org.opencms.workplace.explorer.CmsExplorerContextMenu;
import org.opencms.workplace.explorer.CmsExplorerContextMenuItem;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.A_CmsMenuItemRule;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;
import org.opencms.workplace.explorer.menu.CmsMenuRule;
import org.opencms.workplace.explorer.menu.I_CmsMenuItemRule;
import org.opencms.xml.containerpage.CmsADESessionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsCoreService
extends CmsGwtService
implements I_CmsCoreService {
    private static final String DEFAULT_LOGIN_URL = "/system/login/index.html";
    private static final String EDITOR_BACKLINK_URI = "/system/modules/org.opencms.gwt/editor-backlink.html";
    private static final String EDITOR_DELETE_URI = "/system/workplace/commons/delete.jsp";
    private static final String EDITOR_URI = "/system/workplace/editors/editor.jsp";
    private static final long serialVersionUID = 5915848952948986278L;
    private CmsADESessionCache m_sessionCache;

    public static I_CmsValidationService getValidationService(String name) throws CmsException {
        try {
            Class<?> cls = Class.forName(name, false, I_CmsValidationService.class.getClassLoader());
            if (!I_CmsValidationService.class.isAssignableFrom(cls)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_VALIDATOR_INCORRECT_TYPE_1", name));
            }
            return (I_CmsValidationService)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
    }

    public static <T> T instantiate(Class<T> anInterface, String className) throws CmsException {
        try {
            Class<?> cls = Class.forName(className, false, anInterface.getClassLoader());
            if (!anInterface.isAssignableFrom(cls)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_INSTANTIATION_INCORRECT_TYPE_2", className, anInterface.getName()));
            }
            Class<?> typedClass = cls;
            return (T)typedClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
    }

    public static CmsCoreService newInstance(HttpServletRequest request) {
        CmsCoreService srv = new CmsCoreService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        return srv;
    }

    @Override
    public CmsUUID createUUID() {
        return new CmsUUID();
    }

    @Override
    public List<CmsCategoryTreeEntry> getCategories(String fromPath, boolean includeSubCats, List<String> refPaths) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        ArrayList<String> repositories = new ArrayList<String>();
        if (refPaths != null && !refPaths.isEmpty()) {
            for (String refPath : refPaths) {
                repositories.addAll(catService.getCategoryRepositories(this.getCmsObject(), refPath));
            }
        } else {
            repositories.add("/system/categories/");
        }
        List<CmsCategoryTreeEntry> result = null;
        try {
            List<CmsCategory> categories = catService.readCategoriesForRepositories(cms, fromPath, includeSubCats, repositories);
            result = this.buildCategoryTree(categories);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsCategoryTreeEntry> getCategoriesForSitePath(String sitePath) throws CmsRpcException {
        CmsCategoryService catService = CmsCategoryService.getInstance();
        List<CmsCategoryTreeEntry> result = null;
        try {
            List<CmsCategory> categories = catService.readCategories(this.getCmsObject(), "", true, sitePath);
            result = this.buildCategoryTree(categories);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsContextMenuEntryBean> getContextMenuEntries(CmsUUID structureId, CmsCoreData.AdeContext context) throws CmsRpcException {
        List<CmsContextMenuEntryBean> result = null;
        CmsObject cms = this.getCmsObject();
        switch (context) {
            case containerpage: {
                cms.getRequestContext().setAttribute("__contextInfo", "containerpage");
                break;
            }
            case sitemap: {
                cms.getRequestContext().setAttribute("__contextInfo", "sitemap");
                break;
            }
        }
        try {
            CmsResourceUtil[] resUtil = new CmsResourceUtil[]{new CmsResourceUtil(cms, cms.readResource(structureId))};
            CmsExplorerTypeSettings settings = null;
            try {
                settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resUtil[0].getResourceTypeName());
            }
            catch (Throwable e) {
                this.error(e);
            }
            if (settings == null || !this.isEditable(cms, resUtil[0].getResource())) {
                return Collections.emptyList();
            }
            CmsExplorerContextMenu contextMenu = settings.getContextMenu();
            List<CmsContextMenuEntryBean> allEntries = this.transformToMenuEntries(contextMenu.getAllEntries(), resUtil);
            result = this.filterEntries(allEntries);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsReturnLinkInfo getLinkForReturnCode(String returnCode) throws CmsRpcException {
        try {
            return this.internalGetLinkForReturnCode(returnCode);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsResourceState getResourceState(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsResourceState result = null;
        try {
            try {
                CmsResource res = cms.readResource(structureId);
                result = res.getState();
            }
            catch (CmsVfsResourceNotFoundException e) {
                result = CmsResourceState.STATE_DELETED;
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public String getUniqueFileName(String parentFolder, String baseName) {
        return OpenCms.getResourceManager().getNameGenerator().getUniqueFileName(this.getCmsObject(), parentFolder, baseName);
    }

    @Override
    public String getWorkplaceLink(CmsUUID structureId) throws CmsRpcException {
        String result = null;
        try {
            String resourceRootFolder = CmsResource.getFolderPath(this.getCmsObject().readResource(structureId).getRootPath());
            result = CmsExplorer.getWorkplaceExplorerLink(this.getCmsObject(), resourceRootFolder);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    public CmsReturnLinkInfo internalGetLinkForReturnCode(String returnCode) throws CmsException {
        CmsObject cms = this.getCmsObject();
        if (CmsUUID.isValidUUID(returnCode)) {
            try {
                CmsResource pageRes = cms.readResource(new CmsUUID(returnCode));
                return new CmsReturnLinkInfo(CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), cms.getSitePath(pageRes)), CmsReturnLinkInfo.Status.ok);
            }
            catch (CmsVfsResourceNotFoundException e) {
                return new CmsReturnLinkInfo(null, CmsReturnLinkInfo.Status.notfound);
            }
        }
        int colonIndex = returnCode.indexOf(58);
        if (colonIndex >= 0) {
            String before = returnCode.substring(0, colonIndex);
            String after = returnCode.substring(colonIndex + 1);
            if (CmsUUID.isValidUUID(before) && CmsUUID.isValidUUID(after)) {
                try {
                    CmsUUID pageId = new CmsUUID(before);
                    CmsUUID detailId = new CmsUUID(after);
                    CmsResource pageRes = cms.readResource(pageId);
                    String pagePath = CmsResource.getFolderPath(cms.getSitePath(pageRes));
                    CmsResource detailRes = cms.readResource(detailId);
                    String detailName = cms.getDetailName(detailRes, cms.getRequestContext().getLocale(), OpenCms.getLocaleManager().getDefaultLocales());
                    String uri = CmsStringUtil.joinPaths(pagePath, detailName);
                    return new CmsReturnLinkInfo(CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), uri), CmsReturnLinkInfo.Status.ok);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    return new CmsReturnLinkInfo(null, CmsReturnLinkInfo.Status.notfound);
                }
            }
        }
        throw new IllegalArgumentException("return code has wrong format");
    }

    @Override
    public String lockTemp(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureLock(structureId);
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public CmsLockInfo lockTempAndCheckModification(CmsUUID structureId, long modification) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource resource = cms.readResource(structureId);
            if (resource.getDateLastModified() != modification) {
                CmsUser user = cms.readUser(resource.getUserLastModified());
                return CmsLockInfo.forChangedResource(user.getFullName());
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        try {
            return this.getLock(structureId);
        }
        catch (CmsException e) {
            return CmsLockInfo.forError(e.getLocalizedMessage());
        }
    }

    @Override
    public void ping() {
    }

    @Override
    public CmsCoreData prefetch() {
        CmsObject cms = this.getCmsObject();
        String navigationUri = cms.getRequestContext().getUri();
        boolean toolbarVisible = this.getSessionCache().isToolbarVisible();
        CmsUUID structureId = null;
        try {
            CmsResource requestedResource = cms.readResource(cms.getRequestContext().getUri());
            structureId = requestedResource.getStructureId();
        }
        catch (CmsException e) {
            throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
        }
        String loginUrl = DEFAULT_LOGIN_URL;
        try {
            loginUrl = cms.readPropertyObject(cms.getRequestContext().getUri(), "login-form", true).getValue(DEFAULT_LOGIN_URL);
        }
        catch (CmsException e) {
            this.log(e.getLocalizedMessage(), e);
        }
        Map<String, String> gwtBuildIds = this.getBuildIds();
        CmsCoreData data = new CmsCoreData(EDITOR_URI, EDITOR_BACKLINK_URI, EDITOR_DELETE_URI, loginUrl, OpenCms.getStaticExportManager().getVfsPrefix(), cms.getRequestContext().getSiteRoot(), cms.getRequestContext().getLocale().toString(), OpenCms.getWorkplaceManager().getWorkplaceLocale(cms).toString(), cms.getRequestContext().getUri(), navigationUri, structureId, new HashMap<String, String>(OpenCms.getResourceManager().getExtensionMapping()), System.currentTimeMillis(), toolbarVisible, gwtBuildIds);
        return data;
    }

    @Override
    public void setAvailabilityInfo(CmsUUID structureId, CmsAvailabilityInfoBean bean) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.setAvailabilityInfo(res, bean);
        }
        catch (CmsException e) {
            this.error(e);
        }
    }

    @Override
    public void setAvailabilityInfo(String uri, CmsAvailabilityInfoBean bean) throws CmsRpcException {
        try {
            String sitePath = this.getCmsObject().getRequestContext().removeSiteRoot(uri);
            CmsResource resource = this.getCmsObject().readResource(sitePath);
            this.setAvailabilityInfo(resource, bean);
        }
        catch (CmsException e) {
            this.error(e);
        }
    }

    @Override
    public void setToolbarVisible(boolean visible) throws CmsRpcException {
        try {
            this.ensureSession();
            this.getSessionCache().setToolbarVisible(visible);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public String unlock(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource resource = cms.readResource(structureId);
            this.tryUnlock(resource);
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public Map<String, CmsValidationResult> validate(Map<String, CmsValidationQuery> validationQueries) throws CmsRpcException {
        try {
            HashMap<String, CmsValidationResult> result = new HashMap<String, CmsValidationResult>();
            for (Map.Entry<String, CmsValidationQuery> queryEntry : validationQueries.entrySet()) {
                String fieldName = queryEntry.getKey();
                CmsValidationQuery query = queryEntry.getValue();
                result.put(fieldName, this.validate(query.getValidatorId(), query.getValue(), query.getConfig()));
            }
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public Map<String, CmsValidationResult> validate(String formValidatorClass, Map<String, CmsValidationQuery> validationQueries, Map<String, String> values, String config) throws CmsRpcException {
        try {
            I_CmsFormValidator formValidator = CmsCoreService.instantiate(I_CmsFormValidator.class, formValidatorClass);
            return formValidator.validate(this.getCmsObject(), validationQueries, values, config);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    protected Map<String, String> getBuildIds() {
        List<CmsModule> modules = OpenCms.getModuleManager().getAllInstalledModules();
        HashMap<String, String> result = new HashMap<String, String>();
        for (CmsModule module : modules) {
            String buildid = module.getParameter("gwt.buildid");
            if (buildid == null) continue;
            result.put(module.getName(), buildid);
        }
        return result;
    }

    protected CmsLockInfo getLock(CmsUUID structureId) throws CmsException {
        CmsResource res = this.getCmsObject().readResource(structureId);
        return this.getLock(this.getCmsObject().getSitePath(res));
    }

    protected CmsLockInfo getLock(String sitepath) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(sitepath);
        if (lock.isOwnedBy(user)) {
            return CmsLockInfo.forSuccess();
        }
        if (lock.getUserId().isNullUUID()) {
            cms.lockResourceTemporary(sitepath);
            return CmsLockInfo.forSuccess();
        }
        CmsUser owner = cms.readUser(lock.getUserId());
        return CmsLockInfo.forLockedResource(owner.getName());
    }

    private List<CmsCategoryTreeEntry> buildCategoryTree(List<CmsCategory> categories) throws Exception {
        ArrayList<CmsCategoryTreeEntry> result = new ArrayList<CmsCategoryTreeEntry>();
        for (CmsCategory category : categories) {
            CmsCategoryTreeEntry current = new CmsCategoryTreeEntry(category);
            String parentPath = CmsResource.getParentFolder(current.getPath());
            CmsCategoryTreeEntry parent = null;
            parent = this.findCategory(result, parentPath);
            if (parent != null) {
                parent.addChild(current);
                continue;
            }
            result.add(current);
        }
        return result;
    }

    private List<CmsContextMenuEntryBean> filterEntries(List<CmsContextMenuEntryBean> allEntries) {
        ArrayList<CmsContextMenuEntryBean> result = new ArrayList<CmsContextMenuEntryBean>();
        CmsContextMenuEntryBean lastBean = null;
        for (CmsContextMenuEntryBean entry : allEntries) {
            if (!entry.isVisible()) continue;
            if (entry.isSeparator()) {
                if (!result.isEmpty() && lastBean != null && !lastBean.isSeparator()) {
                    result.add(entry);
                }
            } else if (entry.getSubMenu() != null && !entry.getSubMenu().isEmpty()) {
                entry.setSubMenu(this.filterEntries(entry.getSubMenu()));
                result.add(entry);
            } else {
                result.add(entry);
            }
            lastBean = entry;
        }
        if (result.size() > 1 && ((CmsContextMenuEntryBean)result.get(result.size() - 1)).isSeparator()) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private CmsCategoryTreeEntry findCategory(List<CmsCategoryTreeEntry> tree, String path) {
        if (path == null) {
            return null;
        }
        List<CmsCategoryTreeEntry> children = tree;
        boolean found = true;
        block0: while (found) {
            if (children == null) {
                return null;
            }
            found = false;
            for (int i = children.size() - 1; i >= 0; --i) {
                CmsCategoryTreeEntry child = children.get(i);
                if (path.equals(child.getPath())) {
                    return child;
                }
                if (!path.startsWith(child.getPath())) continue;
                children = child.getChildren();
                found = true;
                continue block0;
            }
        }
        return null;
    }

    private CmsADESessionCache getSessionCache() {
        if (this.m_sessionCache == null) {
            this.m_sessionCache = (CmsADESessionCache)this.getRequest().getSession().getAttribute("__OCMS_ADE_CACHE__");
            if (this.m_sessionCache == null) {
                this.m_sessionCache = new CmsADESessionCache(this.getCmsObject());
                this.getRequest().getSession().setAttribute("__OCMS_ADE_CACHE__", (Object)this.m_sessionCache);
            }
        }
        return this.m_sessionCache;
    }

    private void getSubItemRules(CmsExplorerContextMenuItem item, List<I_CmsMenuItemRule> itemRules, CmsResourceUtil[] resourceUtil) {
        for (CmsExplorerContextMenuItem subItem : item.getSubItems()) {
            I_CmsMenuItemRule rule;
            if (subItem.isParentItem()) {
                this.getSubItemRules(subItem, itemRules, resourceUtil);
                continue;
            }
            if (!"entry".equals(subItem.getType())) continue;
            String subItemRuleName = subItem.getRule();
            CmsMenuRule subItemRule = OpenCms.getWorkplaceManager().getMenuRule(subItemRuleName);
            if (subItemRule == null || (rule = subItemRule.getMatchingRule(this.getCmsObject(), resourceUtil)) == null) continue;
            itemRules.add(rule);
        }
    }

    private boolean isEditable(CmsObject cms, CmsResource resource) {
        try {
            return cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            return false;
        }
    }

    private void modifyAvailability(CmsResource resource, long dateReleased, long dateExpired) throws CmsException {
        this.getCmsObject().setDateReleased(resource, dateReleased, false);
        this.getCmsObject().setDateExpired(resource, dateExpired, false);
    }

    private void modifyNotification(CmsResource resource, int notificationInterval, boolean notificationEnabled, boolean modifySiblings) throws CmsException {
        List<CmsResource> resources = new ArrayList<CmsResource>();
        if (modifySiblings) {
            resources = this.getCmsObject().readSiblings(resource, CmsResourceFilter.IGNORE_EXPIRATION);
        } else {
            resources.add(resource);
        }
        for (CmsResource curResource : resources) {
            String resourcePath = this.getCmsObject().getRequestContext().removeSiteRoot(curResource.getRootPath());
            this.writeProperty(resourcePath, "notification-interval", String.valueOf(notificationInterval));
            this.writeProperty(resourcePath, "enable-notification", String.valueOf(notificationEnabled));
        }
    }

    private void modifyPublishScheduled(CmsResource resource, long pubDate) throws CmsException {
        if (pubDate != 0L) {
            CmsObject cms = this.getCmsObject();
            CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
            Locale locale = this.getCmsObject().getRequestContext().getLocale();
            Date date = new Date(pubDate);
            CmsWorkplaceAction action = CmsWorkplaceAction.getInstance();
            CmsObject cmsAdmin = action.getCmsAdminObject();
            cmsAdmin.getRequestContext().setSiteRoot(cms.getRequestContext().getSiteRoot());
            String dateTime = CmsDateUtil.getDateTime(date, 3, locale);
            CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(locale);
            String projectName = messages.key("GUI_PUBLISH_SCHEDULED_PROJECT_NAME_2", new Object[]{resource.getName(), dateTime});
            projectName = projectName.replace("/", "&#47;");
            CmsProject tmpProject = cmsAdmin.createProject(projectName, "", CmsRole.WORKPLACE_USER.getGroupName(), CmsRole.PROJECT_MANAGER.getGroupName(), CmsProject.PROJECT_TYPE_TEMPORARY);
            tmpProject.setHidden(true);
            cmsAdmin.writeProject(tmpProject);
            cmsAdmin.getRequestContext().setCurrentProject(tmpProject);
            cms.getRequestContext().setCurrentProject(tmpProject);
            cmsAdmin.copyResourceToProject(resource);
            CmsScheduledJobInfo job = new CmsScheduledJobInfo();
            String jobName = projectName;
            job.setJobName(jobName);
            job.setClassName("org.opencms.scheduler.jobs.CmsPublishScheduledJob");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String cronExpr = "" + calendar.get(13) + " " + calendar.get(12) + " " + calendar.get(11) + " " + calendar.get(5) + " " + (calendar.get(2) + 1) + " " + "?" + " " + calendar.get(1);
            job.setCronExpression(cronExpr);
            job.setActive(true);
            CmsContextInfo contextInfo = new CmsContextInfo();
            contextInfo.setProjectName(projectName);
            contextInfo.setUserName(cmsAdmin.getRequestContext().getCurrentUser().getName());
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("mail-to-user", user.getName());
            params.put("jobname", jobName);
            params.put("linkcheck", "true");
            job.setParameters(params);
            job.setContextInfo(contextInfo);
            OpenCms.getScheduleManager().scheduleJob(cmsAdmin, job);
        }
    }

    private void setAvailabilityInfo(CmsResource resource, CmsAvailabilityInfoBean bean) throws CmsException {
        this.ensureLock(resource);
        this.modifyPublishScheduled(resource, bean.getDatePubScheduled());
        this.modifyAvailability(resource, bean.getDateReleased(), bean.getDateExpired());
        this.modifyNotification(resource, bean.getNotificationInterval(), bean.isNotificationEnabled(), bean.isModifySiblings());
        this.tryUnlock(resource);
    }

    private List<CmsContextMenuEntryBean> transformToMenuEntries(List<CmsExplorerContextMenuItem> items, CmsResourceUtil[] resUtil) {
        ArrayList<CmsContextMenuEntryBean> result = new ArrayList<CmsContextMenuEntryBean>();
        CmsWorkplaceManager wpManager = OpenCms.getWorkplaceManager();
        CmsWorkplaceMessages messages = wpManager.getMessages(wpManager.getWorkplaceLocale(this.getCmsObject()));
        for (CmsExplorerContextMenuItem item : items) {
            CmsContextMenuEntryBean bean = new CmsContextMenuEntryBean();
            if (!"sep".equals(item.getType())) {
                I_CmsMenuItemRule itemRule;
                CmsMenuRule rule;
                if (item.getKey() != null) {
                    bean.setLabel(messages.key(item.getKey()));
                }
                CmsMenuItemVisibilityMode mode = CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                String itemRuleName = item.getRule();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(itemRuleName) && (rule = wpManager.getMenuRule(itemRuleName)) != null && (itemRule = rule.getMatchingRule(this.getCmsObject(), resUtil)) != null) {
                    if (item.isParentItem()) {
                        ArrayList<I_CmsMenuItemRule> itemRules = new ArrayList<I_CmsMenuItemRule>(item.getSubItems().size());
                        this.getSubItemRules(item, itemRules, resUtil);
                        I_CmsMenuItemRule[] itemRulesArray = new I_CmsMenuItemRule[itemRules.size()];
                        mode = itemRule.getVisibility(this.getCmsObject(), resUtil, itemRules.toArray(itemRulesArray));
                    } else {
                        mode = itemRule instanceof A_CmsMenuItemRule ? ((A_CmsMenuItemRule)itemRule).getVisibility(this.getCmsObject(), resUtil, item) : itemRule.getVisibility(this.getCmsObject(), resUtil);
                    }
                }
                bean.setVisible(!mode.isInVisible());
                if (item.isParentItem()) {
                    bean.setActive(true);
                } else {
                    bean.setActive(mode.isActive());
                    if (CmsStringUtil.isNotEmpty(mode.getMessageKey())) {
                        bean.setReason(messages.key(CmsEncoder.escapeXml(mode.getMessageKey())));
                    }
                }
                String jspPath = item.getUri();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(jspPath)) {
                    jspPath = item.getUri().startsWith("/") ? OpenCms.getLinkManager().substituteLink(this.getCmsObject(), item.getUri()) : OpenCms.getLinkManager().substituteLink(this.getCmsObject(), "/system/workplace/" + item.getUri());
                }
                bean.setJspPath(jspPath);
                String params = item.getParams();
                if (params != null) {
                    params = CmsVfsService.prepareFileNameForEditor(this.getCmsObject(), resUtil[0].getResource(), params);
                    bean.setParams(CmsStringUtil.splitAsMap(params, "|", "="));
                }
                bean.setName(item.getName());
                String imagePath = item.getIcon();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(imagePath)) {
                    imagePath = item.getIcon().startsWith("/") ? OpenCms.getLinkManager().substituteLink(this.getCmsObject(), item.getIcon()) : OpenCms.getLinkManager().substituteLink(this.getCmsObject(), "/system/workplace/" + item.getIcon());
                }
                bean.setImagePath(imagePath);
            }
            if (item.isParentItem()) {
                bean.setSubMenu(this.transformToMenuEntries(item.getSubItems(), resUtil));
            }
            if ("sep".equals(item.getType())) {
                bean.setVisible(true);
                bean.setSeparator(true);
            }
            result.add(bean);
        }
        return result;
    }

    private CmsValidationResult validate(String validator, String value, String config) throws Exception {
        I_CmsValidationService validationService = CmsCoreService.getValidationService(validator);
        return validationService.validate(this.getCmsObject(), value, config);
    }

    private void writeProperty(String resourcePath, String propertyName, String propertyValue) throws CmsException {
        if (CmsStringUtil.isEmpty(propertyValue)) {
            propertyValue = "";
        }
        CmsProperty newProp = new CmsProperty();
        newProp.setName(propertyName);
        CmsProperty oldProp = this.getCmsObject().readPropertyObject(resourcePath, propertyName, false);
        if (oldProp.isNullProperty()) {
            if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                newProp.setStructureValue(propertyValue);
            } else {
                newProp.setResourceValue(propertyValue);
            }
        } else if (oldProp.getStructureValue() != null) {
            newProp.setStructureValue(propertyValue);
            newProp.setResourceValue(oldProp.getResourceValue());
        } else {
            newProp.setResourceValue(propertyValue);
        }
        newProp.setAutoCreatePropertyDefinition(true);
        String oldStructureValue = oldProp.getStructureValue();
        String newStructureValue = newProp.getStructureValue();
        if (CmsStringUtil.isEmpty(oldStructureValue)) {
            oldStructureValue = "";
        }
        if (CmsStringUtil.isEmpty(newStructureValue)) {
            newStructureValue = "";
        }
        String oldResourceValue = oldProp.getResourceValue();
        String newResourceValue = newProp.getResourceValue();
        if (CmsStringUtil.isEmpty(oldResourceValue)) {
            oldResourceValue = "";
        }
        if (CmsStringUtil.isEmpty(newResourceValue)) {
            newResourceValue = "";
        }
        if (!oldResourceValue.equals(newResourceValue) || !oldStructureValue.equals(newStructureValue)) {
            this.getCmsObject().writePropertyObject(resourcePath, newProp);
        }
    }
}

