/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.CmsDummySerializationPolicy;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsGwtServiceContext
implements I_CmsEventListener {
    private static final Log LOG = CmsLog.getLog(CmsGwtServiceContext.class);
    private String m_name;
    private String m_serializationPolicyPath;
    private SerializationPolicy m_serPolicyOffline;
    private SerializationPolicy m_serPolicyOnline;

    public CmsGwtServiceContext(String name) {
        this.m_name = name;
        OpenCms.addCmsEventListener(this, new int[]{15, 27, 11, 12, 25, 2, 5, 17, 16});
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        CmsResource resource = null;
        List<CmsResource> resources = null;
        switch (event.getType()) {
            case 11: 
            case 15: {
                Object change = event.getData().get("change");
                if (change != null && change.equals(new Integer(0))) {
                    return;
                }
                resource = (CmsResource)event.getData().get("resource");
                this.uncacheResource(resource);
                break;
            }
            case 27: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                this.uncacheResources(resources);
                break;
            }
            case 12: 
            case 22: 
            case 25: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                this.uncacheResources(resources);
                break;
            }
            case 2: 
            case 17: {
                this.m_serPolicyOnline = null;
                break;
            }
            case 5: {
                this.m_serPolicyOnline = null;
                this.m_serPolicyOffline = null;
                break;
            }
            case 16: {
                this.m_serPolicyOffline = null;
                break;
            }
        }
    }

    public String toString() {
        return super.toString() + "(" + this.m_name + ")";
    }

    protected SerializationPolicy getSerializationPolicy(CmsObject cms, String moduleBaseURL, String strongName) {
        if (this.m_serializationPolicyPath == null) {
            this.m_serializationPolicyPath = this.getSerializationPolicyPath(cms, moduleBaseURL, strongName);
        }
        return this.getSerializationPolicy(cms);
    }

    protected String getSerializationPolicyPath(CmsObject cms, String moduleBaseURL, String strongName) {
        String modulePath = null;
        try {
            modulePath = new URL(moduleBaseURL).getPath();
        }
        catch (MalformedURLException ex) {
            LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return null;
        }
        catch (NullPointerException ex) {
            LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return null;
        }
        String serializationPolicyUrl = SerializationPolicyLoader.getSerializationPolicyFileName((String)(modulePath + strongName));
        return OpenCms.getLinkManager().getRootPath(cms, serializationPolicyUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getSerializationPolicy(CmsObject cms) {
        ByteArrayInputStream is;
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        if (online && this.m_serPolicyOnline != null) {
            return this.m_serPolicyOnline;
        }
        if (!online && this.m_serPolicyOffline != null) {
            return this.m_serPolicyOffline;
        }
        SerializationPolicy serializationPolicy = null;
        try {
            is = new ByteArrayInputStream(cms.readFile(this.m_serializationPolicyPath).getContents());
        }
        catch (CmsException ex) {
            String message = "ERROR: The serialization policy file '" + this.m_serializationPolicyPath + "' was not found; did you forget to include it in this deployment?";
            LOG.warn((Object)message);
            LOG.warn((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return new CmsDummySerializationPolicy();
        }
        try {
            serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)is, null);
        }
        catch (ParseException e) {
            LOG.error((Object)("ERROR: Failed to parse the policy file '" + this.m_serializationPolicyPath + "'"), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("ERROR: Could not read the policy file '" + this.m_serializationPolicyPath + "'"), (Throwable)e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {}
        }
        if (online) {
            this.m_serPolicyOnline = serializationPolicy;
        } else {
            this.m_serPolicyOffline = serializationPolicy;
        }
        return serializationPolicy;
    }

    private void uncacheResource(CmsResource resource) {
        if (resource == null) {
            return;
        }
        if (this.m_serializationPolicyPath != null && resource.getRootPath().equals(this.m_serializationPolicyPath)) {
            this.m_serPolicyOffline = null;
        }
    }

    private void uncacheResources(List<CmsResource> resources) {
        if (resources == null) {
            return;
        }
        int n = resources.size();
        for (int i = 0; i < n; ++i) {
            this.uncacheResource(resources.get(i));
        }
    }
}

