/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.Map;
import org.opencms.file.types.CmsResourceTypeUnknownFile;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsIconCssRuleBuilder;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsIconRule;

public class CmsIconUtil
extends org.opencms.gwt.shared.CmsIconUtil {
    public static String buildResourceIconCss() {
        CssBuilder builder = new CssBuilder();
        return builder.buildResourceIconCss();
    }

    public static class CssBuilder {
        private StringBuffer m_buffer = new StringBuffer();

        public String buildResourceIconCss() {
            this.m_buffer.append(this.buildUnknownIconCss());
            for (I_CmsResourceType type : OpenCms.getResourceManager().getResourceTypes()) {
                this.addCssForType(type);
            }
            return this.m_buffer.toString();
        }

        public String buildUnknownIconCss() {
            String unknown = this.getIconUri(OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypeUnknownFile.getStaticTypeName()).getBigIconIfAvailable());
            String template = " div.%1$s {\n  background: transparent scroll 50%% 50%% no-repeat url(\"%2$s\");\n}\n\n";
            return String.format(template, "cms_type_icon", unknown);
        }

        private void addCssForIconRule(String typeName, CmsIconRule rule) {
            String extension = rule.getExtension();
            if (rule.getBigIcon() != null) {
                CmsIconCssRuleBuilder cssBig = new CmsIconCssRuleBuilder();
                cssBig.addSelectorForSubType(typeName, extension, false);
                cssBig.setImageUri(this.getIconUri(rule.getBigIcon()));
                cssBig.writeCss(this.m_buffer);
                CmsIconCssRuleBuilder cssSmall = new CmsIconCssRuleBuilder();
                cssSmall.addSelectorForSubType(typeName, extension, true);
                cssSmall.setImageUri(this.getIconUri(rule.getIcon()));
                cssSmall.writeCss(this.m_buffer);
            } else {
                CmsIconCssRuleBuilder css = new CmsIconCssRuleBuilder();
                css.addSelectorForSubType(typeName, extension, false);
                css.addSelectorForSubType(typeName, extension, true);
                css.setImageUri(this.getIconUri(rule.getIcon()));
                css.writeCss(this.m_buffer);
            }
        }

        private void addCssForType(I_CmsResourceType type) {
            CmsIconCssRuleBuilder cssSmall;
            CmsIconCssRuleBuilder css;
            String typeName = type.getTypeName();
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
            if (settings == null) {
                return;
            }
            if (settings.getBigIcon() != null) {
                css = new CmsIconCssRuleBuilder();
                css.setImageUri(this.getIconUri(settings.getBigIcon()));
                css.addSelectorForType(typeName, false);
                css.writeCss(this.m_buffer);
                cssSmall = new CmsIconCssRuleBuilder();
                cssSmall.setImageUri(this.getIconUri(settings.getIcon()));
                cssSmall.addSelectorForType(typeName, true);
                cssSmall.writeCss(this.m_buffer);
            } else if (settings.getOriginalIcon() != null) {
                css = new CmsIconCssRuleBuilder();
                css.setImageUri(this.getIconUri(settings.getIcon()));
                css.addSelectorForType(typeName, true);
                css.addSelectorForType(typeName, false);
                css.writeCss(this.m_buffer);
            } else {
                css = new CmsIconCssRuleBuilder();
                css.setImageUri(this.getIconUri("document_big.png"));
                css.addSelectorForType(typeName, false);
                css.writeCss(this.m_buffer);
                cssSmall = new CmsIconCssRuleBuilder();
                cssSmall.setImageUri(this.getIconUri("document.png"));
                cssSmall.addSelectorForType(typeName, true);
                cssSmall.writeCss(this.m_buffer);
            }
            Map<String, CmsIconRule> iconRules = settings.getIconRules();
            for (Map.Entry<String, CmsIconRule> entry : iconRules.entrySet()) {
                CmsIconRule rule = entry.getValue();
                this.addCssForIconRule(typeName, rule);
            }
        }

        private String getIconUri(String icon) {
            return CmsWorkplace.getResourceUri("filetypes/" + icon);
        }
    }
}

