/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FactoryUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsTemplateFinder;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsAvailabilityInfoBean;
import org.opencms.gwt.shared.CmsBrokenLinkBean;
import org.opencms.gwt.shared.CmsDeleteResourceBean;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.CmsLockReportInfo;
import org.opencms.gwt.shared.CmsPrepareEditResponse;
import org.opencms.gwt.shared.CmsPrincipalBean;
import org.opencms.gwt.shared.CmsVfsEntryBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.gwt.shared.property.CmsPropertiesBean;
import org.opencms.gwt.shared.property.CmsPropertyChangeSet;
import org.opencms.gwt.shared.property.CmsPropertyModification;
import org.opencms.gwt.shared.rpc.I_CmsVfsService;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsVfsService
extends CmsGwtService
implements I_CmsVfsService {
    private static final Log LOG = CmsLog.getLog(CmsVfsService.class);
    private static final long serialVersionUID = -383483666952834348L;

    public static String prepareFileNameForEditor(CmsObject cms, CmsResource res, String pathWithMacros) {
        String subsite = OpenCms.getADEManager().getSubSiteRoot(cms, res.getRootPath());
        CmsMacroResolver resolver = new CmsMacroResolver();
        if (subsite != null) {
            resolver.addMacro("subsite", cms.getRequestContext().removeSiteRoot(subsite));
        }
        String path = resolver.resolveMacros(pathWithMacros).replaceAll("/+", "/");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteResource(String sitePath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            String path = null;
            try {
                path = this.getCmsObject().getSitePath(res);
                this.getCmsObject().lockResource(path);
                this.getCmsObject().deleteResource(path, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            catch (Exception e) {
                this.error(e);
            }
            finally {
                try {
                    if (path != null) {
                        this.getCmsObject().unlockResource(path);
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
    }

    @Override
    public void forceUnlock(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource resource = this.getCmsObject().readResource(structureId);
            CmsLock currentLock = this.getCmsObject().getLock(resource);
            if (currentLock.getEditionLock().isUnlocked() && currentLock.getSystemLock().isUnlocked()) {
                this.getCmsObject().lockResourceTemporary(resource);
            } else {
                this.getCmsObject().changeLock(resource);
            }
            this.getCmsObject().unlockResource(resource);
        }
        catch (CmsException e) {
            this.error(e);
        }
    }

    @Override
    public CmsAvailabilityInfoBean getAvailabilityInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getAvailabilityInfo(res);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsAvailabilityInfoBean getAvailabilityInfo(String vfsPath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(vfsPath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getAvailabilityInfo(res);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsDeleteResourceBean getBrokenLinks(String sitePath) throws CmsRpcException {
        try {
            CmsResource entryResource = this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsDeleteResourceBean result = null;
            CmsListInfoBean info = null;
            List<CmsBrokenLinkBean> brokenLinks = null;
            CmsObject cms = this.getCmsObject();
            String resourceSitePath = cms.getSitePath(entryResource);
            try {
                this.ensureSession();
                ArrayList<CmsResource> descendants = new ArrayList<CmsResource>();
                HashSet<CmsUUID> deleteIds = new HashSet<CmsUUID>();
                descendants.add(entryResource);
                if (entryResource.isFolder()) {
                    descendants.addAll(cms.readResources(resourceSitePath, CmsResourceFilter.IGNORE_EXPIRATION));
                }
                for (CmsResource deleteRes : descendants) {
                    deleteIds.add(deleteRes.getStructureId());
                }
                MultiValueMap linkMap = MultiValueMap.decorate(new HashMap(), (Factory)FactoryUtils.instantiateFactory(HashSet.class));
                for (CmsResource resource : descendants) {
                    List<CmsResource> linkSources = this.getLinkSources(cms, resource, deleteIds);
                    for (CmsResource source : linkSources) {
                        linkMap.put((Object)resource, (Object)source);
                    }
                }
                brokenLinks = this.getBrokenLinkBeans(linkMap);
                info = this.getPageInfo(entryResource);
                result = new CmsDeleteResourceBean(resourceSitePath, info, brokenLinks);
            }
            catch (Throwable e) {
                this.error(e);
            }
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getChildren(String path) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
            resources.addAll(cms.getResourcesInFolder(path, CmsResourceFilter.DEFAULT));
            List<CmsVfsEntryBean> result = this.makeEntryBeans(resources, false);
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsLockReportInfo getLockReportInfo(CmsUUID structureId) throws CmsRpcException {
        CmsLockReportInfo result = null;
        try {
            CmsResource resource = this.getCmsObject().readResource(structureId);
            ArrayList<CmsListInfoBean> lockedInfos = new ArrayList<CmsListInfoBean>();
            List<CmsResource> lockedResources = this.getCmsObject().getBlockingLockedResources(resource);
            if (lockedResources != null) {
                for (CmsResource lockedResource : lockedResources) {
                    lockedInfos.add(this.getPageInfoWithLock(lockedResource));
                }
            }
            result = new CmsLockReportInfo(this.getPageInfoWithLock(resource), lockedInfos);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsListInfoBean getPageInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getPageInfo(res);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsListInfoBean getPageInfo(String vfsPath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(vfsPath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getPageInfo(res);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getRootEntries() throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            ArrayList<CmsResource> roots = new ArrayList<CmsResource>();
            roots.add(cms.readResource("/"));
            return this.makeEntryBeans(roots, true);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public String getSitePath(CmsUUID structureId) {
        try {
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getCmsObject().getSitePath(resource);
        }
        catch (CmsException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)e.getMessageContainer(), (Throwable)e);
            }
            return null;
        }
    }

    public void internalUpdateProperties(CmsObject cms, CmsResource ownRes, List<CmsPropertyModification> propertyModifications) throws CmsException {
        Map<String, CmsProperty> ownProps = this.getPropertiesByName(cms.readPropertyObjects(ownRes, false));
        boolean changeOwnTitle = this.shouldChangeTitle(ownProps);
        String hasNavTextChange = null;
        ArrayList<CmsProperty> ownPropertyChanges = new ArrayList<CmsProperty>();
        for (CmsPropertyModification propMod : propertyModifications) {
            CmsProperty propToModify = null;
            if (ownRes.getStructureId().equals(propMod.getId())) {
                if ("NavText".equals(propMod.getName())) {
                    hasNavTextChange = propMod.getValue();
                } else if ("Title".equals(propMod.getName())) {
                    changeOwnTitle = false;
                }
                propToModify = ownProps.get(propMod.getName());
                if (propToModify == null) {
                    propToModify = new CmsProperty(propMod.getName(), null, null);
                }
            } else {
                throw new IllegalStateException("Invalid structure id in property changes!");
            }
            ownPropertyChanges.add(propToModify);
            String newValue = propMod.getValue();
            if (newValue == null) {
                newValue = "";
            }
            if (propMod.isStructureValue()) {
                propToModify.setStructureValue(newValue);
                continue;
            }
            propToModify.setResourceValue(newValue);
        }
        if (hasNavTextChange != null && changeOwnTitle) {
            CmsProperty titleProp = ownProps.get("Title");
            if (titleProp == null) {
                titleProp = new CmsProperty("Title", null, null);
            }
            titleProp.setStructureValue(hasNavTextChange);
            ownPropertyChanges.add(titleProp);
        }
        if (!ownPropertyChanges.isEmpty()) {
            cms.writePropertyObjects(ownRes, ownPropertyChanges);
        }
    }

    @Override
    public CmsPropertiesBean loadPropertyData(CmsUUID id) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            return this.internalLoadPropertyData(cms, id);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsPrepareEditResponse prepareEdit(CmsUUID currentPageId, String pathWithMacros) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource currentPage = cms.readResource(currentPageId);
            String path = CmsVfsService.prepareFileNameForEditor(cms, currentPage, pathWithMacros);
            CmsResource resource = cms.readResource(path);
            this.ensureLock(resource);
            CmsPrepareEditResponse result = new CmsPrepareEditResponse();
            result.setRootPath(resource.getRootPath());
            result.setSitePath(cms.getSitePath(resource));
            result.setStructureId(resource.getStructureId());
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void saveProperties(CmsPropertyChangeSet changes) throws CmsRpcException {
        try {
            this.internalSaveProperties(changes);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public String substituteLinkForRootPath(String currentSiteRoot, String rootPath) throws CmsRpcException {
        String result = null;
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot(currentSiteRoot);
            result = OpenCms.getLinkManager().substituteLinkForRootPath(cms, rootPath);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    protected Map<String, CmsClientProperty> convertProperties(List<CmsProperty> properties) {
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        for (CmsProperty prop : properties) {
            CmsClientProperty clientProp = new CmsClientProperty(prop.getName(), prop.getStructureValue(), prop.getResourceValue());
            clientProp.setOrigin(prop.getOrigin());
            result.put(clientProp.getName(), clientProp);
        }
        return result;
    }

    protected CmsBrokenLinkBean createSitemapBrokenLinkBean(CmsResource resource) throws CmsException {
        String path;
        CmsObject cms = this.getCmsObject();
        CmsProperty titleProp = cms.readPropertyObject(resource, "Title", true);
        String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        String defaultTitle = "";
        String title = titleProp.getValue(defaultTitle);
        String subtitle = path = cms.getSitePath(resource);
        return new CmsBrokenLinkBean(title, subtitle, typeName);
    }

    protected void internalSaveProperties(CmsPropertyChangeSet changes) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource target = cms.readResource(changes.getTargetStructureId());
        this.ensureLock(cms.getSitePath(target));
        this.internalUpdateProperties(cms, target, changes.getChanges());
    }

    protected CmsVfsEntryBean makeEntryBean(CmsResource resource, boolean root) throws CmsException {
        List<CmsResource> children;
        CmsObject cms = this.getCmsObject();
        boolean isFolder = resource.isFolder();
        String name = root ? "/" : resource.getName();
        String path = cms.getSitePath(resource);
        boolean hasChildren = false;
        if (isFolder && !(children = cms.getResourcesInFolder(cms.getRequestContext().getSitePath(resource), CmsResourceFilter.DEFAULT)).isEmpty()) {
            hasChildren = true;
        }
        String resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        return new CmsVfsEntryBean(path, name, resourceType, isFolder, hasChildren);
    }

    protected List<CmsVfsEntryBean> makeEntryBeans(List<CmsResource> resources, boolean root) throws CmsException {
        ArrayList<CmsVfsEntryBean> result = new ArrayList<CmsVfsEntryBean>();
        for (CmsResource res : resources) {
            result.add(this.makeEntryBean(res, root));
        }
        return result;
    }

    private CmsAvailabilityInfoBean getAvailabilityInfo(CmsResource res) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            String notificationEnabled;
            CmsAvailabilityInfoBean result = new CmsAvailabilityInfoBean();
            result.setPageInfo(this.getPageInfo(res));
            String resourceSitePath = cms.getRequestContext().removeSiteRoot(res.getRootPath());
            result.setVfsPath(resourceSitePath);
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res.getTypeId());
            result.setResType(type.getTypeName());
            result.setDateReleased(res.getDateReleased());
            result.setDateExpired(res.getDateExpired());
            String notificationInterval = cms.readPropertyObject(res, "notification-interval", false).getValue();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationInterval)) {
                result.setNotificationInterval(Integer.valueOf(notificationInterval));
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationEnabled = cms.readPropertyObject(res, "enable-notification", false).getValue())) {
                result.setNotificationEnabled(Boolean.valueOf(notificationEnabled));
            }
            result.setHasSiblings(cms.readSiblings(resourceSitePath, CmsResourceFilter.ALL).size() > 1);
            result.setResponsibles(this.getResponsibles(res.getRootPath()));
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    private List<CmsBrokenLinkBean> getBrokenLinkBeans(MultiValueMap linkMap) throws CmsException {
        ArrayList<CmsBrokenLinkBean> result = new ArrayList<CmsBrokenLinkBean>();
        for (CmsResource entry : linkMap.keySet()) {
            CmsBrokenLinkBean parentBean = this.createSitemapBrokenLinkBean(entry);
            result.add(parentBean);
            Collection values = linkMap.getCollection((Object)entry);
            for (CmsResource resource : values) {
                CmsBrokenLinkBean childBean = this.createSitemapBrokenLinkBean(resource);
                parentBean.addChild(childBean);
            }
        }
        return result;
    }

    private List<CmsResource> getLinkSources(CmsObject cms, CmsResource resource, HashSet<CmsUUID> deleteIds) throws CmsException {
        List<CmsRelation> relations = cms.getRelationsForResource(resource, CmsRelationFilter.SOURCES);
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsRelation relation : relations) {
            if (deleteIds.contains(relation.getSourceId())) continue;
            result.add(relation.getSource(cms, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        return result;
    }

    private CmsListInfoBean getPageInfo(CmsResource res) throws CmsException, CmsLoaderException {
        CmsObject cms = this.getCmsObject();
        CmsListInfoBean result = new CmsListInfoBean();
        result.setResourceState(res.getState());
        String title = cms.readPropertyObject(res, "Title", false).getValue();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
            result.setTitle(title);
        } else {
            result.setTitle(res.getName());
        }
        result.setSubTitle(cms.getSitePath(res));
        String secure = cms.readPropertyObject(res, "secure", true).getValue();
        if (Boolean.parseBoolean(secure)) {
            result.setStateIcon(CmsListInfoBean.StateIcon.secure);
        } else {
            String export = cms.readPropertyObject(res, "export", true).getValue();
            if (Boolean.parseBoolean(export)) {
                result.setStateIcon(CmsListInfoBean.StateIcon.export);
            } else {
                result.setStateIcon(CmsListInfoBean.StateIcon.standard);
            }
        }
        String resTypeName = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
        String key = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resTypeName).getKey();
        Locale currentLocale = cms.getRequestContext().getLocale();
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(currentLocale);
        String resTypeNiceName = messages.key(key);
        result.addAdditionalInfo(messages.key("GUI_LABEL_TYPE_0"), resTypeNiceName);
        result.setResourceType(resTypeName);
        return result;
    }

    private CmsListInfoBean getPageInfoWithLock(CmsResource resource) throws CmsLoaderException, CmsException {
        CmsListInfoBean result = this.getPageInfo(resource);
        CmsResourceUtil resourceUtil = new CmsResourceUtil(this.getCmsObject(), resource);
        CmsLock lock = resourceUtil.getLock();
        CmsListInfoBean.LockIcon icon = CmsListInfoBean.LockIcon.NONE;
        String iconTitle = null;
        CmsLockType lockType = lock.getType();
        if (!lock.isOwnedBy(this.getCmsObject().getRequestContext().getCurrentUser())) {
            if (lockType == CmsLockType.EXCLUSIVE || lockType == CmsLockType.INHERITED || lockType == CmsLockType.TEMPORARY) {
                icon = CmsListInfoBean.LockIcon.CLOSED;
            } else if (lockType == CmsLockType.SHARED_EXCLUSIVE || lockType == CmsLockType.SHARED_INHERITED) {
                icon = CmsListInfoBean.LockIcon.SHARED_CLOSED;
            }
        } else if (lockType == CmsLockType.EXCLUSIVE || lockType == CmsLockType.INHERITED || lockType == CmsLockType.TEMPORARY) {
            icon = CmsListInfoBean.LockIcon.OPEN;
        } else if (lockType == CmsLockType.SHARED_EXCLUSIVE || lockType == CmsLockType.SHARED_INHERITED) {
            icon = CmsListInfoBean.LockIcon.SHARED_OPEN;
        }
        if (lock.getUserId() != null) {
            iconTitle = Messages.get().getBundle().key("GUI_LOCKED_BY_1", resourceUtil.getLockedByName());
        }
        result.setLockIcon(icon);
        result.setLockIconTitle(iconTitle);
        if (icon != CmsListInfoBean.LockIcon.NONE) {
            result.setTitle(result.getTitle() + " (" + iconTitle + ")");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CmsPrincipalBean, String> getResponsibles(String vfsPath) throws CmsRpcException {
        HashMap<CmsPrincipalBean, String> result = new HashMap<CmsPrincipalBean, String>();
        List<Object> parentResources = new ArrayList();
        CmsObject cms = this.getCmsObject();
        String resourceSitePath = cms.getRequestContext().removeSiteRoot(vfsPath);
        try {
            parentResources = cms.readPath(resourceSitePath, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsException e) {
            this.error(e);
        }
        for (CmsResource cmsResource : parentResources) {
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            String sitePath = cms.getRequestContext().removeSiteRoot(cmsResource.getRootPath());
            try {
                cms.getRequestContext().setSiteRoot("/");
                List<CmsAccessControlEntry> entries = cms.getAccessControlEntries(cmsResource.getRootPath(), false);
                for (CmsAccessControlEntry ace : entries) {
                    I_CmsPrincipal principal;
                    if (!ace.isResponsible() || (principal = cms.lookupPrincipal(ace.getPrincipal())) == null) continue;
                    CmsPrincipalBean prinBean = new CmsPrincipalBean(principal.getName(), principal.getDescription(), principal.isGroup());
                    if (!cmsResource.getRootPath().equals(vfsPath)) {
                        if (cmsResource.getRootPath().startsWith(storedSiteRoot)) {
                            result.put(prinBean, sitePath);
                            continue;
                        }
                        result.put(prinBean, cmsResource.getRootPath());
                        continue;
                    }
                    result.put(prinBean, null);
                }
            }
            catch (CmsException e) {
                this.error(e);
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsPropertiesBean internalLoadPropertyData(CmsObject cms, CmsUUID id) throws CmsException {
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        CmsPropertiesBean result = new CmsPropertiesBean();
        CmsResource resource = cms.readResource(id);
        result.setFolder(resource.isFolder());
        result.setContainerPage(CmsResourceTypeXmlContainerPage.isContainerPage(resource));
        String sitePath = cms.getSitePath(resource);
        Map<String, CmsXmlContentProperty> propertyConfig = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath()).getPropertyConfigurationAsMap();
        result.setPropertyDefinitions(new LinkedHashMap<String, CmsXmlContentProperty>(propertyConfig));
        try {
            cms.getRequestContext().setSiteRoot("");
            String parentPath = CmsResource.getParentFolder(resource.getRootPath());
            CmsResource parent = cms.readResource(parentPath);
            List<CmsProperty> parentProperties = cms.readPropertyObjects(parent, true);
            List<CmsProperty> ownProperties = cms.readPropertyObjects(resource, false);
            result.setOwnProperties(this.convertProperties(ownProperties));
            result.setInheritedProperties(this.convertProperties(parentProperties));
            result.setPageInfo(this.getPageInfo(resource));
            List<CmsPropertyDefinition> propDefs = cms.readAllPropertyDefinitions();
            ArrayList<String> propNames = new ArrayList<String>();
            for (CmsPropertyDefinition propDef : propDefs) {
                propNames.add(propDef.getName());
            }
            CmsTemplateFinder templateFinder = new CmsTemplateFinder(cms);
            result.setTemplates(templateFinder.getTemplates());
            result.setAllProperties(propNames);
            result.setStructureId(id);
            result.setSitePath(sitePath);
            CmsPropertiesBean cmsPropertiesBean = result;
            return cmsPropertiesBean;
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
    }

    private boolean shouldChangeTitle(Map<String, CmsProperty> properties) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || properties.get("NavText") != null && properties.get("Title").getValue().equals(properties.get("NavText").getValue());
    }
}

