/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;

public class CmsClientLock
implements IsSerializable {
    private boolean m_isOwnedByUser;
    private String m_lockOwner;
    private LockType m_lockType;

    public String getLockOwner() {
        return this.m_lockOwner;
    }

    public LockType getLockType() {
        return this.m_lockType;
    }

    public boolean isOwnedByUser() {
        return this.m_isOwnedByUser;
    }

    public void setLockOwner(String lockOwner) {
        this.m_lockOwner = lockOwner;
    }

    public void setLockType(LockType lockType) {
        this.m_lockType = lockType;
    }

    public void setOwnedByUser(boolean isOwnedByUser) {
        this.m_isOwnedByUser = isOwnedByUser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockType {
        EXCLUSIVE(4),
        INHERITED(3),
        PUBLISH(7),
        SHARED_EXCLUSIVE(2),
        SHARED_INHERITED(1),
        TEMPORARY(6),
        SYSTEM_UNLOCKED(8),
        UNLOCKED(0);

        private int m_mode;

        private LockType(int mode) {
            this.m_mode = mode;
        }

        public static LockType valueOf(int mode) {
            switch (mode) {
                case 1: {
                    return SHARED_INHERITED;
                }
                case 2: {
                    return SHARED_EXCLUSIVE;
                }
                case 3: {
                    return INHERITED;
                }
                case 4: {
                    return EXCLUSIVE;
                }
                case 6: {
                    return TEMPORARY;
                }
                case 7: {
                    return PUBLISH;
                }
                case 8: {
                    return SYSTEM_UNLOCKED;
                }
            }
            return UNLOCKED;
        }

        public boolean isUnlocked() {
            return this == UNLOCKED || this == SYSTEM_UNLOCKED;
        }

        public String toString() {
            switch (this.m_mode) {
                case 1: {
                    return "shared inherited";
                }
                case 2: {
                    return "shared exclusive";
                }
                case 3: {
                    return "inherited";
                }
                case 4: {
                    return "exclusive";
                }
                case 6: {
                    return "temporary exclusive";
                }
                case 7: {
                    return "publish";
                }
                case 8: {
                    return "system unlocked";
                }
            }
            return "unlocked";
        }

        public int getMode() {
            return this.m_mode;
        }
    }
}

