/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

public class CmsIconUtil {
    public static final String SMALL_SUFFIX = "_small";
    public static final String TYPE_ICON_CLASS = "cms_type_icon";

    protected CmsIconUtil() {
    }

    public static String getResourceIconClasses(String resourceTypeName, boolean small) {
        StringBuffer sb = new StringBuffer(TYPE_ICON_CLASS);
        sb.append(" ").append(CmsIconUtil.getResourceTypeIconClass(resourceTypeName, small));
        return sb.toString();
    }

    public static String getResourceIconClasses(String resourceTypeName, String fileName, boolean small) {
        StringBuffer sb = new StringBuffer(TYPE_ICON_CLASS);
        sb.append(" ").append(CmsIconUtil.getResourceTypeIconClass(resourceTypeName, small)).append(" ").append(CmsIconUtil.getFileTypeIconClass(resourceTypeName, fileName, small));
        return sb.toString();
    }

    public static String getResourceSubTypeIconClass(String resourceTypeName, String suffix, boolean small) {
        StringBuffer buffer = new StringBuffer(TYPE_ICON_CLASS).append("_").append(resourceTypeName.hashCode()).append("_").append(suffix);
        if (small) {
            buffer.append(SMALL_SUFFIX);
        }
        return buffer.toString();
    }

    public static String getResourceTypeIconClass(String resourceTypeName, boolean small) {
        StringBuffer sb = new StringBuffer(TYPE_ICON_CLASS);
        sb.append("_").append(resourceTypeName.hashCode());
        if (small) {
            sb.append(SMALL_SUFFIX);
        }
        return sb.toString();
    }

    protected static String getFileTypeIconClass(String resourceTypeName, String fileName, boolean small) {
        if (fileName != null && fileName.contains(".")) {
            int last = fileName.lastIndexOf(".");
            if (fileName.length() > last + 1) {
                String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                return CmsIconUtil.getResourceSubTypeIconClass(resourceTypeName, suffix, small);
            }
        }
        return "";
    }
}

