/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.opencms.i18n.CmsListResourceBundle;
import org.opencms.i18n.CmsPropertyResourceBundle;
import org.opencms.i18n.I_CmsResourceBundle;
import org.opencms.util.CmsFileUtil;

public final class CmsResourceBundleLoader {
    private static Map<BundleKey, ResourceBundle> m_bundleCache;
    private static Locale m_lastDefaultLocale;
    private static BundleKey m_lookupKey;
    private static Map<String, CmsListResourceBundle> m_permanentCache;
    private static final ResourceBundle NULL_ENTRY;

    private CmsResourceBundleLoader() {
    }

    public static synchronized void addBundleToCache(String baseName, Locale locale, CmsListResourceBundle bundle) {
        String key = baseName;
        if (locale != null) {
            key = key + "_" + locale;
        }
        m_permanentCache.put(key, bundle);
    }

    public static synchronized void flushBundleCache() {
        m_bundleCache.clear();
    }

    public static synchronized void flushBundleCache(String baseName) {
        if (baseName != null) {
            HashMap<BundleKey, ResourceBundle> bundleCacheNew = new HashMap<BundleKey, ResourceBundle>(m_bundleCache.size());
            for (Map.Entry<BundleKey, ResourceBundle> entry : m_bundleCache.entrySet()) {
                if (entry.getKey().isSameBase(baseName)) continue;
                bundleCacheNew.put(entry.getKey(), entry.getValue());
            }
            if (bundleCacheNew.size() < m_bundleCache.size()) {
                m_bundleCache = bundleCacheNew;
            }
            HashMap<String, CmsListResourceBundle> permanentCacheNew = new HashMap<String, CmsListResourceBundle>(m_permanentCache.size());
            for (Map.Entry<String, CmsListResourceBundle> entry : m_permanentCache.entrySet()) {
                String key = entry.getKey();
                if (key.startsWith(baseName) && (key.length() == baseName.length() || key.charAt(baseName.length()) == '_')) continue;
                permanentCacheNew.put(entry.getKey(), entry.getValue());
            }
            if (permanentCacheNew.size() < m_permanentCache.size()) {
                m_permanentCache = permanentCacheNew;
            }
        }
    }

    public static synchronized ResourceBundle getBundle(String baseName, Locale locale) {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != m_lastDefaultLocale) {
            m_bundleCache = new HashMap<BundleKey, ResourceBundle>();
            m_lastDefaultLocale = defaultLocale;
            if (m_permanentCache == null) {
                m_permanentCache = new HashMap<String, CmsListResourceBundle>();
            }
        }
        m_lookupKey.set(baseName, locale);
        ResourceBundle obj = m_bundleCache.get(m_lookupKey);
        if (obj instanceof ResourceBundle) {
            return obj;
        }
        if (obj != NULL_ENTRY) {
            boolean wantBase = locale.equals(defaultLocale);
            ResourceBundle bundle = CmsResourceBundleLoader.tryBundle(baseName, locale, wantBase);
            if (bundle == null && !locale.equals(defaultLocale)) {
                bundle = CmsResourceBundleLoader.tryBundle(baseName, defaultLocale, true);
            }
            BundleKey key = new BundleKey(baseName, locale);
            if (bundle == null) {
                m_bundleCache.put(key, NULL_ENTRY);
            } else {
                m_bundleCache.put(key, bundle);
                return bundle;
            }
        }
        return ResourceBundle.getBundle(baseName, locale);
    }

    private static I_CmsResourceBundle tryBundle(String localizedName) {
        ResourceBundle result;
        block8: {
            result = null;
            try {
                String resourceName = localizedName.replace('.', '/') + ".properties";
                URL url = CmsResourceBundleLoader.class.getClassLoader().getResource(resourceName);
                if (url != null) {
                    InputStream is = null;
                    String path = CmsFileUtil.normalizePath(url);
                    File file = new File(path);
                    try {
                        is = new FileInputStream(file);
                    }
                    catch (IOException ex) {
                        is = CmsResourceBundleLoader.class.getClassLoader().getResourceAsStream(resourceName);
                    }
                    catch (AccessControlException acex) {
                        is = CmsResourceBundleLoader.class.getClassLoader().getResourceAsStream(resourceName);
                    }
                    if (is != null) {
                        result = new CmsPropertyResourceBundle(is);
                    }
                    break block8;
                }
                CmsListResourceBundle listBundle = m_permanentCache.get(localizedName);
                if (listBundle != null) {
                    result = listBundle.getClone();
                }
            }
            catch (IOException ex) {
                MissingResourceException mre = new MissingResourceException("Failed to load bundle '" + localizedName + "'", localizedName, "");
                mre.initCause(ex);
                throw mre;
            }
        }
        return result;
    }

    private static ResourceBundle tryBundle(String baseName, Locale locale, boolean wantBase) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int baseLen = baseName.length();
        StringBuffer sb = new StringBuffer(baseLen + variant.length() + 7);
        sb.append(baseName);
        if (language.length() > 0) {
            sb.append('_');
            sb.append(language);
            if (country.length() > 0) {
                sb.append('_');
                sb.append(country);
                if (variant.length() > 0) {
                    sb.append('_');
                    sb.append(variant);
                }
            }
        }
        String bundleName = sb.toString();
        I_CmsResourceBundle first = null;
        I_CmsResourceBundle last = null;
        while (true) {
            int idx;
            I_CmsResourceBundle foundBundle;
            if ((foundBundle = CmsResourceBundleLoader.tryBundle(bundleName)) != null) {
                if (first == null) {
                    first = foundBundle;
                }
                if (last != null) {
                    last.setParent((ResourceBundle)((Object)foundBundle));
                }
                foundBundle.setLocale(locale);
                last = foundBundle;
            }
            if ((idx = bundleName.lastIndexOf(95)) <= baseLen && (idx != baseLen || first == null && !wantBase)) break;
            bundleName = bundleName.substring(0, idx);
        }
        return (ResourceBundle)((Object)first);
    }

    static {
        m_lookupKey = new BundleKey();
        NULL_ENTRY = new CmsListResourceBundle();
    }

    private static class BundleKey {
        private String m_baseName;
        private int m_hashcode;
        private Locale m_locale;

        BundleKey() {
        }

        BundleKey(String s, Locale l) {
            this.set(s, l);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BundleKey)) {
                return false;
            }
            BundleKey key = (BundleKey)o;
            return this.m_hashcode == key.m_hashcode && this.m_baseName.equals(key.m_baseName) && this.m_locale.equals(key.m_locale);
        }

        public int hashCode() {
            return this.m_hashcode;
        }

        public boolean isSameBase(String baseName) {
            return this.m_baseName.equals(baseName);
        }

        public String toString() {
            return this.m_baseName + "_" + this.m_locale;
        }

        void set(String s, Locale l) {
            this.m_baseName = s;
            this.m_locale = l;
            this.m_hashcode = this.m_baseName.hashCode() ^ this.m_locale.hashCode();
        }
    }
}

