/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.A_CmsImport;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.CmsXmlPageConverter;
import org.opencms.importexport.Messages;
import org.opencms.lock.CmsLockException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.page.CmsXmlPage;

public class CmsImportVersion2
extends A_CmsImport {
    public static final String VFS_PATH_BODIES = "/system/bodies/";
    private static final String COMPATIBILITY_WEBAPPNAMES = "compatibility.support.webAppNames";
    private static final int IMPORT_VERSION = 2;
    private static final Log LOG = CmsLog.getLog(CmsImportVersion2.class);
    protected List m_webAppNames;
    protected String m_webappUrl;
    private List m_folderStorage;
    private List m_pageStorage;

    public static String setDirectories(String content, String[] rules) {
        for (int i = 0; i < rules.length; ++i) {
            String actRule = rules[i];
            actRule = CmsStringUtil.substitute(actRule, "/default/vfs", "");
            StringTokenizer ruleT = new StringTokenizer(actRule, "#");
            ruleT.nextToken();
            String search = ruleT.nextToken();
            int pos = search.lastIndexOf("(.*)");
            if (pos >= 0) {
                search = search.substring(0, pos);
            }
            String replace = ruleT.nextToken();
            if (pos >= 0) {
                replace = replace.substring(0, replace.lastIndexOf("$1"));
            }
            if (content.indexOf(replace) != -1 || content.indexOf(search) == -1) continue;
            search = "([}>\"'\\[]\\s*)" + search;
            replace = "$1" + replace;
            content = CmsStringUtil.substitutePerl(content, search, replace, "g");
        }
        return content;
    }

    public int getVersion() {
        return 2;
    }

    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters params) throws CmsImportExportException, CmsXmlException {
        this.initialize();
        this.m_cms = cms;
        this.m_importPath = params.getDestinationPath();
        this.m_report = report;
        this.m_folderStorage = new ArrayList();
        this.m_pageStorage = new ArrayList();
        this.m_linkStorage = new HashMap();
        this.m_linkPropertyStorage = new HashMap();
        if (OpenCms.getRunLevel() >= 3) {
            OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_folderStorage", this.m_folderStorage);
            OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_pageStorage", this.m_pageStorage);
            OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_linkStorage", this.m_linkStorage);
            OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_linkPropertyStorage", this.m_linkPropertyStorage);
        }
        CmsImportHelper helper = new CmsImportHelper(params);
        try {
            helper.openFile();
            this.m_importResource = helper.getFolder();
            this.m_importZip = helper.getZipFile();
            this.m_docXml = CmsXmlUtils.unmarshalHelper(helper.getFileBytes("manifest.xml"), null);
            if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ACCOUNT_MANAGER)) {
                this.importGroups();
                this.importUsers();
            }
            this.importAllResources();
            this.convertPointerToSiblings();
        }
        catch (IOException e) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", "manifest.xml");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)e);
            }
            throw new CmsImportExportException(msg, (Throwable)e);
        }
        finally {
            helper.closeFile();
            this.cleanUp();
        }
    }

    public void importResources(CmsObject cms, String importPath, I_CmsReport report, File importResource, ZipFile importZip, Document docXml) throws CmsImportExportException {
        CmsImportParameters params = new CmsImportParameters(importResource != null ? importResource.getAbsolutePath() : importZip.getName(), importPath, true);
        try {
            this.importData(cms, report, params);
        }
        catch (CmsXmlException e) {
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    protected void cleanUp() {
        this.m_pageStorage = null;
        this.m_folderStorage = null;
        this.m_webAppNames = null;
        this.m_webappUrl = null;
        super.cleanUp();
    }

    protected byte[] convertContent(String source, String destination, byte[] content, String resType) {
        if (this.getVersion() < 3) {
            if ("page".equals(resType)) {
                this.m_pageStorage.add(destination);
            } else if ("folder".equals(resType) && destination.startsWith(VFS_PATH_BODIES.substring(1))) {
                this.m_folderStorage.add(destination);
            }
        }
        return content;
    }

    protected String getEncoding(String content) {
        String encoding = content;
        int index = encoding.toLowerCase().indexOf("encoding=\"");
        if (index != -1 && (index = (encoding = encoding.substring(index + 10)).indexOf("\"")) != -1) {
            encoding = encoding.substring(0, index);
            return encoding.toUpperCase();
        }
        return "";
    }

    protected void importUser(String name, String flags, String password, String firstname, String lastname, String email, long dateCreated, Map userInfo, List userGroups) throws CmsImportExportException {
        boolean convert = false;
        CmsParameterConfiguration config = OpenCms.getPasswordHandler().getConfiguration();
        if (config != null && config.containsKey("compatibility.convert.digestencoding")) {
            convert = config.getBoolean("compatibility.convert.digestencoding", false);
        }
        if (convert) {
            password = this.convertDigestEncoding(password);
        }
        super.importUser(name, flags, password, firstname, lastname, email, dateCreated, userInfo, userGroups);
    }

    protected void initialize() {
        this.m_convertToXmlPage = true;
        this.m_webAppNames = new ArrayList();
        super.initialize();
    }

    protected String setEncoding(String content, String encoding) {
        if (content.toLowerCase().indexOf("<?xml") == -1) {
            return content;
        }
        String xmlTag = content.substring(0, content.indexOf(">") + 1);
        if (xmlTag.toLowerCase().indexOf("encoding") == -1) {
            content = content.substring(content.indexOf(">") + 1);
            content = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + content;
        }
        return content;
    }

    private List getCompatibilityWebAppNames() {
        String key;
        ArrayList<String> webAppNamesOri = new ArrayList<String>();
        String configuredWebAppNames = (String)OpenCms.getRuntimeProperty(COMPATIBILITY_WEBAPPNAMES);
        if (configuredWebAppNames != null && configuredWebAppNames.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(configuredWebAppNames, ",;");
            while (tokenizer.hasMoreTokens()) {
                webAppNamesOri.add(tokenizer.nextToken());
            }
        }
        ArrayList<String> webAppNames = new ArrayList<String>();
        for (int i = 0; i < webAppNamesOri.size(); ++i) {
            String name = ((String)webAppNamesOri.get(i)).trim();
            if (!CmsStringUtil.isNotEmpty(name)) continue;
            webAppNames.add(name);
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)Messages.get().getBundle().key("INIT_IMPORTEXPORT_OLD_CONTEXT_PATH_2", Integer.toString(i + 1), name));
        }
        String string = key = webAppNames.size() > 0 ? "INIT_IMPORTEXPORT_OLD_CONTEXT_SUPPORT_ENABLED_0" : "INIT_IMPORTEXPORT_OLD_CONTEXT_SUPPORT_DISABLED_0";
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key(key));
        }
        if (!webAppNames.contains(OpenCms.getSystemInfo().getOpenCmsContext())) {
            webAppNames.add(OpenCms.getSystemInfo().getOpenCmsContext());
        }
        return webAppNames;
    }

    private void importAllResources() throws CmsImportExportException {
        List fileNodes = null;
        List acentryNodes = null;
        Element currentElement = null;
        Element currentEntry = null;
        String source = null;
        String destination = null;
        String resourceTypeName = null;
        String timestamp = null;
        String uuid = null;
        String uuidresource = null;
        long lastmodified = 0L;
        int resourceTypeId = CmsResourceTypePlain.getStaticTypeId();
        List properties = null;
        boolean old_overwriteCollidingResources = false;
        try {
            this.m_webAppNames = this.getCompatibilityWebAppNames();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_GETTING_WEBAPP_COMPATIBILITY_NAMES_0"), (Throwable)e);
            }
            this.m_report.println(e);
        }
        if (this.m_webAppNames == null) {
            this.m_webAppNames = Collections.EMPTY_LIST;
        }
        this.m_webappUrl = OpenCms.getImportExportManager().getOldWebAppUrl();
        if (this.m_webappUrl == null) {
            this.m_webappUrl = "http://localhost:8080/opencms/opencms";
        }
        if (this.m_webappUrl.endsWith("/")) {
            this.m_webappUrl = this.m_webappUrl.substring(0, this.m_webappUrl.lastIndexOf("/"));
        }
        List<String> deleteProperties = OpenCms.getImportExportManager().getIgnoredProperties();
        List immutableResources = OpenCms.getImportExportManager().getImmutableResources();
        if (immutableResources == null) {
            immutableResources = Collections.EMPTY_LIST;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_RESOURCES_SIZE_1", Integer.toString(immutableResources.size())));
        }
        old_overwriteCollidingResources = OpenCms.getImportExportManager().overwriteCollidingResources();
        OpenCms.getImportExportManager().setOverwriteCollidingResources(true);
        try {
            fileNodes = this.m_docXml.selectNodes("//file");
            int importSize = fileNodes.size();
            for (int i = 0; i < importSize; ++i) {
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(importSize)), 3);
                currentElement = (Element)fileNodes.get(i);
                source = this.getChildElementTextValue(currentElement, "source");
                destination = this.getChildElementTextValue(currentElement, "destination");
                resourceTypeName = this.getChildElementTextValue(currentElement, "type");
                if ("newpage".equals(resourceTypeName)) {
                    resourceTypeId = 9;
                } else if ("page".equals(resourceTypeName)) {
                    resourceTypeId = CmsResourceTypePlain.getStaticTypeId();
                } else if ("link".equals(resourceTypeName)) {
                    resourceTypeId = 1024;
                } else {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resourceTypeName);
                    resourceTypeId = type.getTypeId();
                }
                uuid = this.getChildElementTextValue(currentElement, "uuidstructure");
                uuidresource = this.getChildElementTextValue(currentElement, "uuidresource");
                timestamp = this.getChildElementTextValue(currentElement, "lastmodified");
                lastmodified = timestamp != null ? Long.parseLong(timestamp) : System.currentTimeMillis();
                if ("script".equals(resourceTypeName)) {
                    resourceTypeName = CmsResourceTypePlain.getStaticTypeName();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ORIGINAL_RESOURCE_NAME_1", destination));
                }
                String translatedName = this.m_cms.getRequestContext().addSiteRoot(this.m_importPath + destination);
                if ("folder".equals(resourceTypeName) && !CmsResource.isFolder(translatedName)) {
                    translatedName = translatedName + "/";
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_TRANSLATED_RESOURCE_NAME_1", translatedName));
                }
                boolean resourceNotImmutable = this.checkImmutable(translatedName, immutableResources);
                translatedName = this.m_cms.getRequestContext().removeSiteRoot(translatedName);
                if (resourceNotImmutable) {
                    this.m_report.print(Messages.get().container("RPT_IMPORTING_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    properties = this.readPropertiesFromManifest(currentElement, deleteProperties);
                    CmsResource res = this.importResource(source, destination, uuid, uuidresource, resourceTypeId, resourceTypeName, lastmodified, properties);
                    if (res != null) {
                        ArrayList<CmsAccessControlEntry> aceList = new ArrayList<CmsAccessControlEntry>();
                        acentryNodes = currentElement.selectNodes("*/accessentry");
                        for (int j = 0; j < acentryNodes.size(); ++j) {
                            currentEntry = (Element)acentryNodes.get(j);
                            String id = this.getChildElementTextValue(currentEntry, "id");
                            String acflags = this.getChildElementTextValue(currentEntry, "flags");
                            String allowed = this.getChildElementTextValue(currentEntry, "allowed");
                            String denied = this.getChildElementTextValue(currentEntry, "denied");
                            aceList.add(this.getImportAccessControlEntry(res, id, allowed, denied, acflags));
                        }
                        this.importAccessControlEntries(res, aceList);
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)Messages.get().getBundle().key("LOG_IMPORTING_4", new Object[]{String.valueOf(i + 1), String.valueOf(importSize), translatedName, destination}));
                        continue;
                    }
                    this.m_report.print(Messages.get().container("RPT_SKIPPING_0"), 4);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(i + 1), String.valueOf(importSize), translatedName));
                    continue;
                }
                this.m_report.print(Messages.get().container("RPT_SKIPPING_0"), 3);
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(i + 1), String.valueOf(importSize), translatedName));
            }
            if (this.getVersion() < 3 && this.m_convertToXmlPage) {
                this.mergePageFiles();
                this.removeFolders();
            }
        }
        catch (Exception e) {
            this.m_report.println(e);
            this.m_report.addError(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
        finally {
            OpenCms.getImportExportManager().setOverwriteCollidingResources(old_overwriteCollidingResources);
        }
    }

    private CmsResource importResource(String source, String destination, String uuid, String uuidresource, int resourceTypeId, String resourceTypeName, long lastmodified, List properties) {
        byte[] content = null;
        CmsResource res = null;
        String targetName = null;
        try {
            block16: {
                if (source != null) {
                    content = this.getFileBytes(source);
                }
                content = this.convertContent(source, destination, content, resourceTypeName);
                int size = 0;
                if (content != null) {
                    size = content.length;
                }
                CmsUUID curUser = this.m_cms.getRequestContext().getCurrentUser().getId();
                CmsUUID newUuidstructure = new CmsUUID();
                CmsUUID newUuidresource = new CmsUUID();
                if (uuid != null) {
                    newUuidstructure = new CmsUUID(uuid);
                }
                if (uuidresource != null) {
                    newUuidresource = new CmsUUID(uuidresource);
                }
                if ((targetName = destination).endsWith("/")) {
                    targetName = targetName.substring(0, targetName.length() - 1);
                }
                boolean isFolder = false;
                try {
                    isFolder = CmsFolder.isFolderType(resourceTypeId);
                }
                catch (Throwable t) {
                    isFolder = size == 0 && "folder".equalsIgnoreCase(resourceTypeName);
                }
                CmsResource resource = new CmsResource(newUuidstructure, newUuidresource, targetName, resourceTypeId, isFolder, 0, this.m_cms.getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, lastmodified, curUser, lastmodified, curUser, 0L, Long.MAX_VALUE, 1, size, System.currentTimeMillis(), 0);
                if (1024 == resourceTypeId) {
                    this.m_report.print(Messages.get().container("RPT_STORING_LINK_0"), 3);
                    this.m_linkStorage.put(this.m_importPath + destination, new String(content));
                    this.m_linkPropertyStorage.put(this.m_importPath + destination, properties);
                    res = resource;
                } else {
                    String resName = this.m_importPath + destination;
                    res = this.m_cms.importResource(resName, resource, content, properties);
                    try {
                        this.m_cms.unlockResource(resName);
                    }
                    catch (CmsLockException e) {
                        if (!LOG.isDebugEnabled()) break block16;
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_UNABLE_TO_UNLOCK_RESOURCE_1", resName), (Throwable)e);
                    }
                }
            }
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        }
        catch (CmsException exc) {
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCE_1", targetName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)exc);
            }
            this.m_report.println(exc);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return res;
    }

    private void mergePageFile(String resourcename) throws CmsXmlException, CmsImportExportException {
        try {
            String elementDefNodeName;
            Node bodyNode;
            String masterTemplateNodeName;
            CmsFile pagefile;
            Document contentXml;
            Node masterTemplateNode;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_START_MERGING_1", resourcename));
            }
            if ((masterTemplateNode = (contentXml = CmsXmlUtils.unmarshalHelper((pagefile = this.m_cms.readFile(resourcename, CmsResourceFilter.ALL)).getContents(), null)).selectSingleNode(masterTemplateNodeName = "//masterTemplate")) == null) {
                masterTemplateNode = contentXml.selectSingleNode(masterTemplateNodeName.toLowerCase());
            }
            if (masterTemplateNode == null) {
                masterTemplateNode = contentXml.selectSingleNode(masterTemplateNodeName.toUpperCase());
            }
            String mastertemplate = null;
            if (masterTemplateNode != null) {
                mastertemplate = masterTemplateNode.getText().trim();
            }
            if ((bodyNode = contentXml.selectSingleNode(elementDefNodeName = "//ELEMENTDEF")) == null) {
                bodyNode = contentXml.selectSingleNode(elementDefNodeName.toLowerCase());
            }
            if (bodyNode != null) {
                String bodyclass = null;
                String bodyname = null;
                HashMap<String, String> bodyparams = null;
                List nodes = ((Element)bodyNode).elements();
                int n = nodes.size();
                for (int i = 0; i < n; ++i) {
                    Node node = (Node)nodes.get(i);
                    if ("CLASS".equalsIgnoreCase(node.getName())) {
                        bodyclass = node.getText().trim();
                        continue;
                    }
                    if ("TEMPLATE".equalsIgnoreCase(node.getName())) {
                        bodyname = node.getText().trim();
                        if (bodyname.startsWith("/")) continue;
                        bodyname = CmsResource.getFolderPath(resourcename) + bodyname;
                        continue;
                    }
                    if (!"PARAMETER".equalsIgnoreCase(node.getName())) continue;
                    Element paramElement = (Element)node;
                    if (bodyparams == null) {
                        bodyparams = new HashMap<String, String>();
                    }
                    bodyparams.put(paramElement.attribute("name").getText(), paramElement.getTextTrim());
                }
                if (mastertemplate == null || bodyname == null) {
                    CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_CANNOT_MERGE_PAGE_FILE_3", resourcename, mastertemplate, bodyname);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message.key());
                    }
                    throw new CmsImportExportException(message);
                }
                this.m_cms.lockResource(resourcename);
                List<CmsProperty> properties = this.m_cms.readPropertyObjects(resourcename, false);
                CmsFile bodyfile = this.m_cms.readFile(bodyname, CmsResourceFilter.IGNORE_EXPIRATION);
                String encoding = CmsProperty.get("content-encoding", properties).getValue();
                if (encoding == null) {
                    encoding = OpenCms.getSystemInfo().getDefaultEncoding();
                }
                if (this.m_convertToXmlPage) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_START_CONVERTING_TO_XML_0"));
                    }
                    CmsXmlPage xmlPage = CmsXmlPageConverter.convertToXmlPage(this.m_cms, bodyfile.getContents(), this.getLocale(resourcename, properties), encoding);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_END_CONVERTING_TO_XML_0"));
                    }
                    if (xmlPage != null) {
                        pagefile.setContents(xmlPage.marshal());
                        pagefile.setType(CmsResourceTypeXmlPage.getStaticTypeId());
                    }
                }
                CmsProperty newProperty = new CmsProperty("template", mastertemplate, null);
                properties.remove(newProperty);
                properties.add(newProperty);
                if (CmsStringUtil.isNotEmpty(bodyclass)) {
                    newProperty = new CmsProperty("template", mastertemplate, null);
                    newProperty.setAutoCreatePropertyDefinition(true);
                    properties.remove(newProperty);
                    properties.add(newProperty);
                }
                if (bodyparams != null) {
                    for (Map.Entry entry : bodyparams.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        newProperty = new CmsProperty(key, value, null);
                        newProperty.setAutoCreatePropertyDefinition(true);
                        properties.remove(newProperty);
                        properties.add(newProperty);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_START_IMPORTING_XML_PAGE_0"));
                }
                this.m_cms.importResource(resourcename, pagefile, pagefile.getContents(), properties);
                this.m_cms.lockResource(bodyname);
                this.m_cms.deleteResource(bodyname, CmsResource.DELETE_PRESERVE_SIBLINGS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_END_IMPORTING_XML_PAGE_0"));
                }
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            } else {
                this.m_cms.lockResource(resourcename);
                pagefile.setType(CmsResourceTypePlain.getStaticTypeId());
                this.m_cms.writeFile(pagefile);
                this.m_cms.unlockResource(resourcename);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_CANNOT_CONVERT_XML_STRUCTURE_1", resourcename));
                }
                this.m_report.println(Messages.get().container("RPT_NOT_CONVERTED_0"), 4);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_END_MERGING_1", resourcename));
            }
        }
        catch (CmsXmlException e) {
            throw e;
        }
        catch (CmsException e) {
            this.m_report.println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_MERGING_PAGE_FILE_1", resourcename);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    private void mergePageFiles() throws CmsXmlException, CmsImportExportException {
        try {
            try {
                this.m_cms.readPropertyDefinition("template");
            }
            catch (CmsException e) {
                this.m_cms.createPropertyDefinition("template");
            }
            List<CmsPropertyDefinition> definitions = this.m_cms.readAllPropertyDefinitions();
            for (CmsPropertyDefinition definition : definitions) {
                try {
                    this.m_cms.readPropertyDefinition(definition.getName());
                }
                catch (Exception e) {
                    this.m_cms.createPropertyDefinition(definition.getName());
                }
            }
        }
        catch (CmsException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_COPYING_PROPERTY_DEFINITIONS_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message);
        }
        int size = this.m_pageStorage.size();
        this.m_report.println(Messages.get().container("RPT_MERGE_START_0"), 2);
        Iterator i = this.m_pageStorage.iterator();
        int counter = 1;
        while (i.hasNext()) {
            String resname = (String)i.next();
            if (!resname.startsWith("/")) {
                resname = "/" + resname;
            }
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(counter), String.valueOf(size)), 3);
            this.m_report.print(Messages.get().container("RPT_MERGE_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", resname));
            this.mergePageFile(resname);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_MERGING_3", String.valueOf(counter), String.valueOf(size), resname));
            }
            ++counter;
        }
        this.m_pageStorage.clear();
    }

    private void removeFolders() throws CmsImportExportException {
        try {
            int size = this.m_folderStorage.size();
            this.m_report.println(Messages.get().container("RPT_DELFOLDER_START_0"), 2);
            int counter = 1;
            for (int j = size - 1; j >= 0; --j) {
                List<CmsResource> folders;
                String resname = (String)this.m_folderStorage.get(j);
                List<CmsResource> files = this.m_cms.getFilesInFolder(resname = (resname.startsWith("/") ? "" : "/") + resname + (resname.endsWith("/") ? "" : "/"), CmsResourceFilter.IGNORE_EXPIRATION);
                if (files.size() != 0 || (folders = this.m_cms.getSubFolders(resname, CmsResourceFilter.IGNORE_EXPIRATION)).size() != 0) continue;
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(counter), String.valueOf(size)), 3);
                this.m_report.print(Messages.get().container("RPT_DELFOLDER_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", resname), 0);
                this.m_cms.lockResource(resname);
                this.m_cms.deleteResource(resname, CmsResource.DELETE_PRESERVE_SIBLINGS);
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                ++counter;
            }
        }
        catch (CmsException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_REMOVING_FOLDERS_OF_IMPORTED_BODY_FILES_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }
}

