/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Map;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspNavElement
implements Comparable<CmsJspNavElement> {
    private String m_fileName;
    private Boolean m_hasNav;
    private int m_navTreeLevel = Integer.MIN_VALUE;
    private float m_position;
    private Map<String, String> m_properties;
    private CmsResource m_resource;
    private String m_sitePath;
    private String m_text;
    private boolean m_changedNavPos;

    public CmsJspNavElement() {
    }

    public CmsJspNavElement(String sitePath, CmsResource resource, Map<String, String> properties) {
        this.setResource(resource);
        this.init(sitePath, properties);
    }

    public CmsJspNavElement(String sitePath, CmsResource resource, Map<String, String> properties, int navTreeLevel) {
        this.setResource(resource);
        this.init(sitePath, properties, navTreeLevel);
    }

    @Deprecated
    public CmsJspNavElement(String sitePath, Map<String, String> properties) {
        this.init(sitePath, properties, -1);
    }

    @Deprecated
    public CmsJspNavElement(String sitePath, Map<String, String> properties, int navTreeLevel) {
        this.init(sitePath, properties, navTreeLevel);
    }

    @Override
    public int compareTo(CmsJspNavElement obj) {
        if (obj == this) {
            return 0;
        }
        float pos = obj.getNavPosition();
        if (this.m_position == pos) {
            return 0;
        }
        return this.m_position < pos ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsJspNavElement) {
            return ((CmsJspNavElement)obj).m_sitePath.equals(this.m_sitePath);
        }
        return false;
    }

    public String getDescription() {
        return this.m_properties.get("Description");
    }

    public String getFileName() {
        if (this.m_fileName == null) {
            this.m_fileName = !this.m_sitePath.endsWith("/") ? this.m_sitePath.substring(this.m_sitePath.lastIndexOf("/") + 1, this.m_sitePath.length()) : this.m_sitePath.substring(this.m_sitePath.substring(0, this.m_sitePath.length() - 1).lastIndexOf("/") + 1, this.m_sitePath.length());
        }
        return this.m_fileName;
    }

    public String getInfo() {
        return this.m_properties.get("NavInfo");
    }

    public String getLocale() {
        return this.m_properties.get("locale");
    }

    public String getNavImage() {
        return this.m_properties.get("NavImage");
    }

    public float getNavPosition() {
        return this.m_position;
    }

    public String getNavText() {
        if (this.m_text == null) {
            this.m_text = this.m_properties.get("NavText");
            if (this.m_text == null) {
                this.m_text = CmsMessages.formatUnknownKey("NavText");
            }
        }
        return this.m_text;
    }

    public int getNavTreeLevel() {
        if (this.m_navTreeLevel < 0) {
            this.m_navTreeLevel = CmsResource.getPathLevel(this.m_sitePath);
        }
        return this.m_navTreeLevel;
    }

    public String getParentFolderName() {
        return CmsResource.getParentFolder(this.m_sitePath);
    }

    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public String getProperty(String key) {
        return this.m_properties.get(key);
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public String getResourceName() {
        return this.m_sitePath;
    }

    public String getTitle() {
        return this.m_properties.get("Title");
    }

    public boolean hasChangedNavPosition() {
        return this.m_changedNavPos;
    }

    public int hashCode() {
        return this.m_sitePath.hashCode();
    }

    public void init(String resource, Map<String, String> properties) {
        this.init(resource, properties, -1);
    }

    public void init(String resource, Map<String, String> properties, int navTreeLevel) {
        this.m_sitePath = resource;
        this.m_properties = properties;
        this.m_navTreeLevel = navTreeLevel;
        this.m_position = Float.MAX_VALUE;
        try {
            this.m_position = Float.parseFloat(this.m_properties.get("NavPos"));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isFolderLink() {
        return this.m_sitePath.endsWith("/");
    }

    public boolean isInNavigation() {
        if (this.m_hasNav == null) {
            String o1 = this.m_properties.get("NavText");
            String o2 = this.m_properties.get("NavPos");
            this.m_hasNav = (o1 != null || o2 != null) && !CmsResource.isTemporaryFileName(this.m_sitePath);
        }
        return this.m_hasNav;
    }

    public void setNavPosition(float value) {
        this.m_position = value;
        this.m_changedNavPos = true;
    }

    protected String getSitePath() {
        return this.m_sitePath;
    }

    protected void setResource(CmsResource resource) {
        this.m_resource = resource;
    }
}

