/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.CmsDirectEditJspIncludeProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;

public class CmsJspTagEditable
extends BodyTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagEditable.class);
    private static final long serialVersionUID = 4137789622146499225L;
    protected String m_file;
    protected transient CmsDirectEditMode m_mode;
    protected String m_provider;
    private boolean m_firstOnPage;
    private boolean m_manualPlacement;

    public static void editableTagAction(PageContext context, String provider, CmsDirectEditMode mode, String fileName) throws JspException {
        if (mode == CmsDirectEditMode.FALSE) {
            return;
        }
        ServletRequest req = context.getRequest();
        if (CmsHistoryResourceHandler.isHistoryRequest(req)) {
            return;
        }
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return;
        }
        if (CmsResource.isTemporaryFileName(cms.getRequestContext().getUri())) {
            return;
        }
        I_CmsDirectEditProvider eb = CmsJspTagEditable.getDirectEditProvider(context);
        if (eb == null) {
            if (CmsStringUtil.isNotEmpty(fileName) && CmsStringUtil.isEmpty(provider)) {
                provider = CmsDirectEditJspIncludeProvider.class.getName();
            }
            if (CmsStringUtil.isNotEmpty(provider)) {
                try {
                    eb = (I_CmsDirectEditProvider)Class.forName(provider).newInstance();
                }
                catch (Exception e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_DIRECT_EDIT_PROVIDER_1", provider), (Throwable)e);
                }
            }
            if (eb == null) {
                eb = OpenCms.getWorkplaceManager().getDirectEditProvider();
            }
            if (mode == null) {
                mode = CmsDirectEditMode.AUTO;
            }
            eb.init(cms, mode, fileName);
            CmsJspTagEditable.setDirectEditProvider(context, eb);
        }
        if (eb.isManual(mode)) {
            CmsDirectEditParams params = CmsJspTagEditable.getDirectEditProviderParams(context);
            if (params != null) {
                eb.insertDirectEditStart(context, params);
            } else {
                eb.insertDirectEditEnd(context);
            }
        } else {
            eb.insertDirectEditIncludes(context, new CmsDirectEditParams(cms.getRequestContext().getUri()));
        }
    }

    public static void endDirectEdit(PageContext context) throws JspException {
        I_CmsDirectEditProvider eb = CmsJspTagEditable.getDirectEditProvider(context);
        if (eb != null) {
            eb.insertDirectEditEnd(context);
        }
    }

    public static I_CmsDirectEditProvider getDirectEditProvider(PageContext context) {
        return (I_CmsDirectEditProvider)context.getRequest().getAttribute("org.opencms.workplace.editors.directedit.__directEditProvider");
    }

    public static boolean startDirectEdit(PageContext context, CmsDirectEditParams params) throws JspException {
        I_CmsDirectEditProvider eb = CmsJspTagEditable.getDirectEditProvider(context);
        boolean result = false;
        if (eb != null) {
            if (eb.isManual(params.getMode())) {
                CmsJspTagEditable.setDirectEditProviderParams(context, params);
            } else {
                result = eb.insertDirectEditStart(context, params);
            }
        }
        return result;
    }

    protected static CmsDirectEditParams getDirectEditProviderParams(PageContext context) {
        ServletRequest req = context.getRequest();
        CmsDirectEditParams result = (CmsDirectEditParams)req.getAttribute("org.opencms.workplace.editors.directedit.__directEditProviderParams");
        if (result != null) {
            req.removeAttribute("org.opencms.workplace.editors.directedit.__directEditProviderParams");
        }
        return result;
    }

    protected static void setDirectEditProvider(PageContext context, I_CmsDirectEditProvider provider) {
        context.getRequest().setAttribute("org.opencms.workplace.editors.directedit.__directEditProvider", (Object)provider);
    }

    protected static void setDirectEditProviderParams(PageContext context, CmsDirectEditParams params) {
        context.getRequest().setAttribute("org.opencms.workplace.editors.directedit.__directEditProviderParams", (Object)params);
    }

    public int doEndTag() throws JspException {
        if (this.m_firstOnPage || this.m_manualPlacement) {
            CmsJspTagEditable.editableTagAction(this.pageContext, this.m_provider, this.m_mode, this.m_file);
        }
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        if (!CmsFlexController.isCmsOnlineRequest(this.pageContext.getRequest()) && !CmsResource.isTemporaryFileName(CmsFlexController.getCmsObject(this.pageContext.getRequest()).getRequestContext().getUri())) {
            I_CmsDirectEditProvider eb = CmsJspTagEditable.getDirectEditProvider(this.pageContext);
            this.m_firstOnPage = eb == null;
            this.m_manualPlacement = false;
            if (this.m_mode == CmsDirectEditMode.MANUAL && !this.m_firstOnPage && eb != null && eb.isManual(this.m_mode)) {
                this.m_manualPlacement = true;
                CmsJspTagEditable.editableTagAction(this.pageContext, this.m_provider, this.m_mode, this.m_file);
            }
        } else {
            this.m_firstOnPage = false;
            this.m_manualPlacement = false;
        }
        return 1;
    }

    public String getFile() {
        return this.m_file != null ? this.m_file : "";
    }

    public String getMode() {
        return this.m_mode != null ? this.m_mode.toString() : "";
    }

    public String getProvider() {
        return this.m_provider != null ? this.m_provider : "";
    }

    public void release() {
        super.release();
        this.m_file = null;
        this.m_provider = null;
        this.m_mode = null;
        this.m_firstOnPage = false;
        this.m_manualPlacement = true;
    }

    public void setFile(String file) {
        this.m_file = file;
    }

    public void setMode(String mode) {
        this.m_mode = CmsDirectEditMode.valueOf(mode);
    }

    public void setProvider(String provider) {
        this.m_provider = provider;
    }
}

