/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.notification;

import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.notification.Messages;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public abstract class A_CmsNotification
extends CmsHtmlMail {
    private static final Log LOG = CmsLog.getLog(A_CmsNotification.class);
    private CmsObject m_cms;
    private Locale m_locale;
    private CmsMacroResolver m_macroResolver;
    private CmsXmlContent m_mailContent;
    private CmsUser m_receiver;

    public A_CmsNotification(CmsObject cms, CmsUser receiver) {
        this.m_cms = cms;
        this.m_receiver = receiver;
        this.m_macroResolver = new CmsMacroResolver();
    }

    public void addMacro(String key, String value) {
        this.m_macroResolver.addMacro(key, value);
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public CmsUser getReceiver() {
        return this.m_receiver;
    }

    public String send() throws EmailException {
        String messageID = null;
        try {
            Locale userLocale;
            if (CmsStringUtil.isEmpty(this.m_receiver.getEmail())) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_NO_ADDRESS_1", this.m_receiver.getName()));
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_SEND_1", this.m_receiver.getEmail()));
            }
            this.m_mailContent = CmsXmlContentFactory.unmarshal(this.m_cms, this.m_cms.readFile(this.getNotificationContent()));
            List<Locale> locales = this.m_mailContent.getLocales();
            this.m_locale = locales.contains(userLocale = new CmsUserSettings(this.m_receiver).getLocale()) ? userLocale : (locales.contains(OpenCms.getWorkplaceManager().getDefaultLocale()) ? OpenCms.getWorkplaceManager().getDefaultLocale() : locales.get(0));
            this.m_macroResolver.addMacro("firstname", this.m_receiver.getFirstname());
            this.m_macroResolver.addMacro("lastname", this.m_receiver.getLastname());
            this.m_macroResolver.addMacro("project", this.m_cms.getRequestContext().getCurrentProject().getName());
            StringBuffer msg = new StringBuffer();
            this.appendHtmlHeader(msg);
            msg.append(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, "Header", this.m_locale), this.m_macroResolver));
            msg.append("\n<br/><br/>\n");
            msg.append(this.generateHtmlMsg());
            msg.append("\n<br/><br/>\n");
            msg.append(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, "Footer", this.m_locale), this.m_macroResolver));
            this.appenHtmlFooter(msg);
            this.addTo(this.m_receiver.getEmail(), this.m_receiver.getFirstname() + ' ' + this.m_receiver.getLastname());
            this.setSubject(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, "Subject", this.m_locale), this.m_macroResolver));
            this.setHtmlMsg(msg.toString());
            super.send();
            messageID = this.getMimeMessage().getMessageID();
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_SEND_ERROR_0"), (Throwable)e);
        }
        catch (MessagingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_SEND_ERROR_0"), (Throwable)e);
        }
        return messageID;
    }

    protected void appendHtmlHeader(StringBuffer buffer) {
        buffer.append("<html><head><style type=\"text/css\">\n");
        buffer.append("<!--\n");
        buffer.append("body { font-family: Verdana, Arial, Helvetica, sans-serif; background-color:#ffefdb; }\n");
        buffer.append("a { color:#b22222; text-decoration:none; }\n");
        buffer.append("table { white-space: nowrap; font-size: x-small; }\n");
        buffer.append("tr.trow1 { background-color: #cdc0b0; }\n");
        buffer.append("tr.trow2 { background-color: #eedfcc; }\n");
        buffer.append("tr.trow3 { background-color: #ffefdb; }\n");
        buffer.append("--></style>\n");
        buffer.append("</head><body><span style='font-size:8.0pt;'>");
    }

    protected void appenHtmlFooter(StringBuffer buffer) {
        buffer.append("</span></body></html>");
    }

    protected abstract String generateHtmlMsg();

    protected abstract String getNotificationContent();
}

