/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.TypedBuffer;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishHistory;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsPublishQueue {
    private static final Log LOG = CmsLog.getLog(CmsPublishHistory.class);
    protected final CmsPublishEngine m_publishEngine;

    protected CmsPublishQueue(CmsPublishEngine publishEngine) {
        this.m_publishEngine = publishEngine;
    }

    public static Buffer getQueue() {
        return BufferUtils.synchronizedBuffer((Buffer)TypedBuffer.decorate((Buffer)new UnboundedFifoBuffer(){
            private static final long serialVersionUID = 606444342980861724L;

            public Object remove() {
                CmsPublishJobInfoBean publishJob = (CmsPublishJobInfoBean)super.remove();
                return publishJob;
            }
        }, CmsPublishJobInfoBean.class));
    }

    protected boolean abortPublishJob(CmsPublishJobInfoBean publishJob) {
        if (OpenCms.getMemoryMonitor().getCachedPublishJob(publishJob.getPublishHistoryId().toString()) != null) {
            OpenCms.getMemoryMonitor().uncachePublishJob(publishJob);
            return true;
        }
        return false;
    }

    protected void add(CmsPublishJobInfoBean publishJob) throws CmsException {
        publishJob.enqueue();
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContext(null);
            try {
                this.m_publishEngine.getDriverManager().createPublishJob(dbc, publishJob);
            }
            catch (CmsException e) {
                dbc.rollback();
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            finally {
                dbc.clear();
            }
        }
        OpenCms.getMemoryMonitor().cachePublishJob(publishJob);
    }

    protected List<CmsPublishJobEnqueued> asList() {
        List<CmsPublishJobInfoBean> cachedPublishJobs = OpenCms.getMemoryMonitor().getAllCachedPublishJobs();
        ArrayList<CmsPublishJobEnqueued> result = new ArrayList<CmsPublishJobEnqueued>(cachedPublishJobs.size());
        for (CmsPublishJobInfoBean publishJob : cachedPublishJobs) {
            result.add(new CmsPublishJobEnqueued(publishJob));
        }
        return Collections.unmodifiableList(result);
    }

    protected boolean contains(CmsPublishJobInfoBean publishJob) {
        List<CmsPublishJobInfoBean> l = OpenCms.getMemoryMonitor().getAllCachedPublishJobs();
        if (l != null) {
            for (int i = 0; i < l.size(); ++i) {
                CmsPublishJobInfoBean b = l.get(i);
                if (b != publishJob) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(CmsObject adminCms, boolean revive) {
        block20: {
            CmsDriverManager driverManager = this.m_publishEngine.getDriverManager();
            try {
                OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PUBLISH_QUEUE);
                if (!revive) break block20;
                CmsDbContext dbc = this.m_publishEngine.getDbContext(null);
                List<CmsPublishJobInfoBean> publishJobs = null;
                try {
                    publishJobs = driverManager.readPublishJobs(dbc, 0L, 0L);
                }
                catch (Exception e) {
                    dbc.rollback();
                }
                finally {
                    dbc.clear();
                    dbc = null;
                }
                for (CmsPublishJobInfoBean job : publishJobs) {
                    dbc = this.m_publishEngine.getDbContext(null);
                    if (!job.isStarted()) {
                        try {
                            job.revive(adminCms, driverManager.readPublishList(dbc, job.getPublishHistoryId()));
                            this.m_publishEngine.lockPublishList(job);
                            OpenCms.getMemoryMonitor().cachePublishJob(job);
                            continue;
                        }
                        catch (CmsException exc) {
                            dbc.rollback();
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_JOB_INVALID_1", job.getPublishHistoryId()), (Throwable)exc);
                            }
                            this.m_publishEngine.getDriverManager().deletePublishJob(dbc, job.getPublishHistoryId());
                            continue;
                        }
                        finally {
                            dbc.clear();
                            continue;
                        }
                    }
                    try {
                        job.revive(adminCms, driverManager.readPublishList(dbc, job.getPublishHistoryId()));
                        this.m_publishEngine.unlockPublishList(job);
                        new CmsPublishJobEnqueued((CmsPublishJobInfoBean)job).m_publishJob.finish();
                        this.m_publishEngine.getPublishHistory().add(job);
                    }
                    catch (CmsException exc) {
                        dbc.rollback();
                        LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
                    }
                    finally {
                        dbc.clear();
                    }
                }
            }
            catch (CmsException exc) {
                if (!LOG.isErrorEnabled()) break block20;
                LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
            }
        }
    }

    protected boolean isEmpty() {
        return OpenCms.getMemoryMonitor() == null || OpenCms.getMemoryMonitor().getFirstCachedPublishJob() == null;
    }

    protected CmsPublishJobInfoBean next() {
        CmsPublishJobInfoBean publishJob = OpenCms.getMemoryMonitor().getFirstCachedPublishJob();
        if (publishJob != null) {
            OpenCms.getMemoryMonitor().uncachePublishJob(publishJob);
        }
        return publishJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(CmsPublishJobInfoBean publishJob) throws CmsException {
        try {
            this.m_publishEngine.publishJobRemoved(publishJob);
        }
        finally {
            OpenCms.getMemoryMonitor().uncachePublishJob(publishJob);
        }
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContext(null);
            try {
                this.m_publishEngine.getDriverManager().deletePublishJob(dbc, publishJob.getPublishHistoryId());
            }
            catch (CmsException e) {
                dbc.rollback();
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            finally {
                dbc.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(CmsPublishJobInfoBean publishJob) {
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContext(null);
            try {
                this.m_publishEngine.getDriverManager().writePublishJob(dbc, publishJob);
            }
            catch (CmsException e) {
                dbc.rollback();
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                dbc.clear();
            }
        }
    }
}

