/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.loader.CmsJspLoader;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishException;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.Messages;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CmsPublishThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsPublishThread.class);
    protected CmsJspLoader m_jspLoader;
    private boolean m_abort;
    private final CmsPublishEngine m_publishEngine;
    private CmsPublishJobInfoBean m_publishJob;
    private I_CmsReport m_report;
    private boolean m_started;
    private final boolean m_updateSessionInfo;

    protected CmsPublishThread(CmsPublishEngine publishEngine, CmsPublishJobInfoBean publishJob) {
        super(publishJob.getCmsObject(), Messages.get().getBundle().key("GUI_PUBLISH_TRHEAD_NAME_0"));
        this.m_publishJob = publishJob;
        this.m_publishEngine = publishEngine;
        this.m_updateSessionInfo = this.getCms().getRequestContext().getCurrentProject().getType() == CmsProject.PROJECT_TYPE_TEMPORARY;
        try {
            this.m_jspLoader = (CmsJspLoader)OpenCms.getResourceManager().getLoader(6);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public boolean isAborted() {
        return this.m_abort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block21: {
            this.m_publishJob.start(this.getUUID());
            this.m_report = this.m_publishJob.getPublishReport();
            this.m_publishEngine.publishJobStarted(this.m_publishJob);
            this.m_started = true;
            if (this.isAborted()) {
                return;
            }
            this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_BEGIN_0"), 2);
            Set<String> includingFiles = null;
            if (this.m_jspLoader != null) {
                includingFiles = this.getStrongLinkReferences();
            }
            CmsDbContext dbc = this.m_publishEngine.getDbContext(this.getCms().getRequestContext());
            try {
                try {
                    this.m_publishEngine.getDriverManager().publishJob(this.getCms(), dbc, this.m_publishJob.getPublishList(), this.m_report);
                }
                catch (Throwable e) {
                    dbc.rollback();
                    this.m_report.println(e);
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISH_PROJECT_FAILED_0"), e);
                    Object var5_5 = null;
                    dbc.clear();
                    dbc = null;
                    if (this.m_updateSessionInfo) {
                        OpenCms.getSessionManager().updateSessionInfos(this.getCms());
                    }
                    if (this.m_jspLoader != null) {
                        this.m_jspLoader.removeFromCache(includingFiles, true);
                    }
                    this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_END_0"), 2);
                }
                Object var5_4 = null;
                dbc.clear();
                dbc = null;
                if (this.m_updateSessionInfo) {
                    OpenCms.getSessionManager().updateSessionInfos(this.getCms());
                }
                if (this.m_jspLoader != null) {
                    this.m_jspLoader.removeFromCache(includingFiles, true);
                }
                this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_END_0"), 2);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                dbc.clear();
                dbc = null;
                if (this.m_updateSessionInfo) {
                    OpenCms.getSessionManager().updateSessionInfos(this.getCms());
                }
                if (this.m_jspLoader != null) {
                    this.m_jspLoader.removeFromCache(includingFiles, true);
                }
                this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_END_0"), 2);
                throw throwable;
            }
            Object var7_9 = null;
            try {
                this.m_publishEngine.publishJobFinished(this.getPublishJob());
            }
            catch (Throwable e2) {
                LOG.error((Object)e2.getMessage(), e2);
            }
            break block21;
            {
                catch (Throwable e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISH_PROJECT_FAILED_0"), e);
                    Object var7_10 = null;
                    try {
                        this.m_publishEngine.publishJobFinished(this.getPublishJob());
                    }
                    catch (Throwable e2) {
                        LOG.error((Object)e2.getMessage(), e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    this.m_publishEngine.publishJobFinished(this.getPublishJob());
                }
                catch (Throwable e2) {
                    LOG.error((Object)e2.getMessage(), e2);
                }
                throw throwable;
            }
        }
    }

    protected void abort() throws CmsPublishException {
        if (this.m_started) {
            throw new CmsPublishException(Messages.get().container("ERR_PUBLISH_ENGINE_MISSING_PUBLISH_JOB_0"));
        }
        this.m_abort = true;
    }

    protected CmsPublishJobInfoBean getPublishJob() {
        return this.m_publishJob;
    }

    @Override
    protected I_CmsReport getReport() {
        return this.m_report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getStrongLinkReferences() {
        HashSet<String> includingFiles = new HashSet<String>();
        CmsDbContext dbc = this.m_publishEngine.getDbContext(this.getCms().getRequestContext());
        try {
            try {
                CmsObject jspCms = OpenCms.initCmsObject(this.m_publishJob.getCmsObject());
                jspCms.getRequestContext().setCurrentProject(jspCms.readProject(CmsProject.ONLINE_PROJECT_ID));
                this.m_report.println(Messages.get().container("RPT_JSPLOADER_UPDATE_CACHE_BEGIN_0"), 2);
                int plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
                for (CmsResource resource : this.m_publishJob.getPublishList().getFileList()) {
                    if (!CmsResourceTypeJsp.isJsp(resource) && resource.getTypeId() != plainId) continue;
                    this.m_report.print(Messages.get().container("RPT_JSPLOADER_UPDATE_CACHE_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(resource.getRootPath())));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    this.m_jspLoader.getReferencingStrongLinks(jspCms, resource, includingFiles);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                }
                Object var8_8 = null;
                dbc.clear();
                dbc = null;
                this.m_report.println(Messages.get().container("RPT_JSPLOADER_UPDATE_CACHE_END_0"), 2);
            }
            catch (Throwable e) {
                this.m_report.println(e);
                Object var8_9 = null;
                dbc.clear();
                dbc = null;
                this.m_report.println(Messages.get().container("RPT_JSPLOADER_UPDATE_CACHE_END_0"), 2);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            dbc.clear();
            dbc = null;
            this.m_report.println(Messages.get().container("RPT_JSPLOADER_UPDATE_CACHE_END_0"), 2);
            throw throwable;
        }
        return includingFiles;
    }
}

