/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.relations.Messages;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.CmsProgressThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsRelationSystemValidator {
    private static final Log LOG = CmsLog.getLog(CmsRelationSystemValidator.class);
    protected CmsDriverManager m_driverManager;

    public CmsRelationSystemValidator(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    public Map<String, List<CmsRelation>> validateResources(CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) throws Exception {
        boolean interProject;
        CmsProgressThread thread = null;
        if (Thread.currentThread() instanceof CmsProgressThread) {
            thread = (CmsProgressThread)Thread.currentThread();
        }
        HashMap<String, List<CmsRelation>> invalidResources = new HashMap<String, List<CmsRelation>>();
        boolean bl = interProject = publishList != null;
        if (report != null) {
            report.println(Messages.get().container("RPT_HTMLLINK_VALIDATOR_BEGIN_0"), 2);
        }
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        if (publishList == null) {
            CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION;
            List<I_CmsResourceType> resTypes = OpenCms.getResourceManager().getResourceTypes();
            Iterator<I_CmsResourceType> itTypes = resTypes.iterator();
            int count = 0;
            while (itTypes.hasNext()) {
                I_CmsResourceType type;
                ++count;
                if (thread != null) {
                    if (thread.isInterrupted()) {
                        throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                    }
                    thread.setProgress(count * 10 / resTypes.size());
                }
                if (!((type = itTypes.next()) instanceof I_CmsLinkParseable)) continue;
                filter = filter.addRequireType(type.getTypeId());
                try {
                    resources.addAll(this.m_driverManager.readResources(dbc, this.m_driverManager.readResource(dbc, "/", filter), filter, true));
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_RETRIEVAL_RESOURCES_1", type.getTypeName()), (Throwable)e);
                }
            }
        } else {
            resources.addAll(publishList.getAllResources());
        }
        HashMap<String, CmsResource> offlineFilesLookup = new HashMap<String, CmsResource>();
        Iterator itResources = resources.iterator();
        int count = 0;
        while (itResources.hasNext()) {
            ++count;
            if (thread != null) {
                if (thread.isInterrupted()) {
                    throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                }
                thread.setProgress(count * 10 / resources.size() + 10);
            }
            CmsResource resource = (CmsResource)itResources.next();
            offlineFilesLookup.put(resource.getRootPath(), resource);
        }
        CmsProject project = dbc.currentProject();
        if (interProject) {
            try {
                project = this.m_driverManager.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String name = publishList == null ? "CmsPublishSitemapCache(null)" : "CmsPublishSitemapCache(pubHistId=" + publishList.getPublishHistoryId().toString() + ")";
        boolean foundBrokenLinks = false;
        int size = resources.size();
        for (int index = 0; index < size; ++index) {
            List<CmsRelation> brokenLinks;
            if (thread != null) {
                if (thread.isInterrupted()) {
                    throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                }
                thread.setProgress(index * 20 / resources.size() + 20);
            }
            CmsResource resource = (CmsResource)resources.get(index);
            String resourceName = resource.getRootPath();
            if (report != null) {
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", new Integer(index + 1), new Integer(size)), 3);
                report.print(Messages.get().container("RPT_HTMLLINK_VALIDATING_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(resourceName)));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            }
            if ((brokenLinks = this.validateLinks(dbc, resource, offlineFilesLookup, project, report)).size() > 0) {
                invalidResources.put(resourceName, brokenLinks);
                foundBrokenLinks = true;
                continue;
            }
            if (report == null) continue;
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        if (foundBrokenLinks && report != null) {
            report.println(Messages.get().container("RPT_HTMLLINK_VALIDATOR_ERROR_0"), 5);
        }
        if (report != null) {
            report.println(Messages.get().container("RPT_HTMLLINK_VALIDATOR_END_0"), 2);
        }
        return invalidResources;
    }

    protected boolean checkLinkForDeletedLinkTarget(String link, Map<String, CmsResource> fileLookup) {
        boolean isValidLink = false;
        if (fileLookup.containsKey(link)) {
            CmsResource offlineResource = fileLookup.get(link);
            isValidLink = offlineResource.getState().isDeleted();
        }
        return isValidLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkLinkForNewOrChangedLinkSource(CmsDbContext dbc, CmsResource resource, CmsRelation relation, String link, CmsProject project, Map<String, CmsResource> fileLookup) {
        boolean isValidLink = true;
        try {
            try {
                link = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, project.getUuid(), relation.getTargetId(), true).getRootPath();
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_READBYID_FAILED_2", relation.getTargetId().toString(), project.getName()), (Throwable)e);
                }
                this.m_driverManager.getVfsDriver(dbc).readResource(dbc, project.getUuid(), relation.getTargetPath(), true);
            }
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_READBYPATH_FAILED_2", relation.getTargetPath(), project.getName()), (Throwable)e);
            }
            if (!fileLookup.containsKey(link)) {
                isValidLink = false;
            }
        }
        finally {
            CmsResource offlineResource;
            if (fileLookup.containsKey(link) && (offlineResource = fileLookup.get(link)).getState().isDeleted()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_RESOURCEDELETED_1", link));
                }
                isValidLink = false;
            }
        }
        return isValidLink;
    }

    protected boolean checkLinkValid(CmsDbContext dbc, CmsResource resource, CmsRelation relation, String link, CmsProject project, Map<String, CmsResource> fileLookup) {
        if (resource.getState().isDeleted()) {
            return this.checkLinkForDeletedLinkTarget(link, fileLookup);
        }
        return this.checkLinkForNewOrChangedLinkSource(dbc, resource, relation, link, project, fileLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CmsRelation> getLinkRelations(CmsDbContext dbc, CmsProject project, CmsResource resource) throws CmsException {
        List<CmsRelation> relations;
        if (!resource.getState().isDeleted()) {
            relations = this.m_driverManager.getRelationsForResource(dbc, resource, CmsRelationFilter.TARGETS);
        } else {
            CmsProject currentProject = dbc.currentProject();
            dbc.getRequestContext().setCurrentProject(project);
            try {
                relations = this.m_driverManager.getRelationsForResource(dbc, resource, CmsRelationFilter.SOURCES);
            }
            finally {
                dbc.getRequestContext().setCurrentProject(currentProject);
            }
        }
        return relations;
    }

    protected List<CmsRelation> validateLinks(CmsDbContext dbc, CmsResource resource, Map<String, CmsResource> fileLookup, CmsProject project, I_CmsReport report) {
        ArrayList<CmsRelation> brokenRelations = new ArrayList<CmsRelation>();
        HashMap<String, Boolean> validatedLinks = new HashMap<String, Boolean>();
        List<CmsRelation> relations = null;
        try {
            relations = this.getLinkRelations(dbc, project, resource);
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_LINK_SEARCH_1", resource), (Throwable)e);
            if (report != null) {
                report.println(Messages.get().container("LOG_LINK_SEARCH_1", dbc.removeSiteRoot(resource.getRootPath())), 5);
            }
            return brokenRelations;
        }
        boolean first = true;
        for (CmsRelation relation : relations) {
            String link = !resource.getState().isDeleted() ? relation.getTargetPath() : relation.getSourcePath();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(link)) continue;
            if (validatedLinks.keySet().contains(link)) {
                if (!((Boolean)validatedLinks.get(link)).booleanValue()) continue;
                brokenRelations.add(relation);
                continue;
            }
            boolean isValidLink = this.checkLinkValid(dbc, resource, relation, link, project, fileLookup);
            if (!isValidLink) {
                if (first) {
                    if (report != null) {
                        report.println(Messages.get().container("RPT_HTMLLINK_FOUND_BROKEN_LINKS_0"), 1);
                    }
                    first = false;
                }
                brokenRelations.add(relation);
                if (report != null) {
                    if (!resource.getState().isDeleted()) {
                        report.println(Messages.get().container("RPT_HTMLLINK_BROKEN_TARGET_2", relation.getSourcePath(), dbc.removeSiteRoot(link)), 1);
                    } else {
                        report.println(Messages.get().container("RPT_HTMLLINK_BROKEN_SOURCE_2", dbc.removeSiteRoot(link), relation.getTargetPath()), 1);
                    }
                }
            }
            validatedLinks.put(link, !isValidLink);
        }
        return brokenRelations;
    }
}

