/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractorOpenOffice;
import org.opencms.search.extractors.I_CmsExtractionResult;

public class CmsDocumentOpenOffice
extends A_CmsVfsDocument {
    public CmsDocumentOpenOffice(String name) {
        super(name);
    }

    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsIndexException, CmsException {
        this.logContentExtraction(resource, index);
        CmsFile file = this.readFile(cms, resource);
        try {
            return CmsExtractorOpenOffice.getExtractor().extractText(file.getContents());
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    public boolean isLocaleDependend() {
        return false;
    }

    public boolean isUsingCache() {
        return true;
    }
}

