/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSearchField {
    public static final float BOOST_DEFAULT = 1.0f;
    public static final String FIELD_CATEGORY = "category";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_CONTENT_BLOB = "contentblob";
    public static final String FIELD_DATE_CONTENT = "contentdate";
    public static final String FIELD_DATE_CREATED = "created";
    public static final String FIELD_DATE_CREATED_LOOKUP = "created_lookup";
    public static final String FIELD_DATE_LASTMODIFIED = "lastmodified";
    public static final String FIELD_DATE_LASTMODIFIED_LOOKUP = "lastmodified_lookup";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_KEYWORDS = "keywords";
    public static final String FIELD_META = "meta";
    public static final String FIELD_PARENT_FOLDERS = "parent-folders";
    public static final String FIELD_PATH = "path";
    public static final String FIELD_PRIORITY = "priority";
    public static final String FIELD_TITLE = "title-key";
    public static final String FIELD_TITLE_UNSTORED = "title";
    public static final String FIELD_TYPE = "type";
    public static final String IGNORE_DISPLAY_NAME = "-";
    public static final String STR_COMPRESS = "compress";
    public static final String STR_NO = "no";
    public static final String STR_TOKENIZED = "tokenized";
    public static final String STR_UN_TOKENIZED = "untokenized";
    public static final String STR_YES = "yes";
    private Analyzer m_analyzer;
    private float m_boost = 1.0f;
    private boolean m_compressed;
    private String m_defaultValue;
    private boolean m_displayed;
    private String m_displayName;
    private String m_displayNameForConfiguration;
    private boolean m_excerpt;
    private boolean m_indexed;
    private List<CmsSearchFieldMapping> m_mappings = new ArrayList<CmsSearchFieldMapping>();
    private String m_name;
    private boolean m_stored;
    private boolean m_tokenized;

    public CmsSearchField() {
    }

    public CmsSearchField(String name, String displayName, boolean isStored, boolean isIndexed) {
        this(name, displayName, isStored, isIndexed, isIndexed, false, 1.0f, null);
    }

    public CmsSearchField(String name, String displayName, boolean isStored, boolean isCompressed, boolean isIndexed, boolean isTokenized, boolean isInExcerpt, Analyzer analyzer, float boost, String defaultValue) {
        this();
        this.setDisplayName(displayName);
        this.setName(name);
        this.setStored(isStored);
        this.setCompressed(isCompressed);
        this.setIndexed(isIndexed);
        this.setTokenized(isTokenized);
        this.setInExcerpt(isInExcerpt);
        this.setAnalyzer(analyzer);
        this.setBoost(boost);
        this.setDefaultValue(defaultValue);
    }

    public CmsSearchField(String name, String displayName, boolean isStored, boolean isIndexed, boolean isTokenized, boolean isInExcerpt, float boost, String defaultValue) {
        this(name, displayName, isStored, false, isIndexed, isTokenized, isInExcerpt, null, boost, defaultValue);
    }

    public void addMapping(CmsSearchFieldMapping mapping) {
        this.m_mappings.add(mapping);
    }

    public Field createField(String content) {
        return this.createField(this.getName(), content);
    }

    public Field createField(String name, String content) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(content)) {
            content = this.getDefaultValue();
        }
        if (content != null) {
            Field.Index index = Field.Index.NO;
            if (this.isIndexed()) {
                index = this.isTokenizedAndIndexed() ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED;
            }
            Field.Store store = Field.Store.NO;
            if (this.isStored() || this.isCompressed()) {
                store = Field.Store.YES;
            }
            Field result = new Field(name, content, store, index);
            if (this.getBoost() != 1.0f) {
                result.setBoost(this.getBoost());
            }
            return result;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CmsSearchField) {
            return CmsStringUtil.isEqual(this.m_name, ((CmsSearchField)obj).m_name);
        }
        return false;
    }

    public Analyzer getAnalyzer() {
        return this.m_analyzer;
    }

    public float getBoost() {
        return this.m_boost;
    }

    public String getBoostDisplay() {
        if (this.m_boost == 1.0f) {
            return null;
        }
        return String.valueOf(this.m_boost);
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getDisplayName() {
        if (!this.isDisplayed()) {
            return IGNORE_DISPLAY_NAME;
        }
        if (this.m_displayName == null) {
            return this.m_name;
        }
        return this.m_displayName;
    }

    public String getDisplayNameForConfiguration() {
        return this.m_displayNameForConfiguration;
    }

    public String getIndexed() {
        if (this.isTokenizedAndIndexed()) {
            return String.valueOf(this.isTokenizedAndIndexed());
        }
        if (this.isIndexed()) {
            return STR_UN_TOKENIZED;
        }
        return String.valueOf(this.isIndexed());
    }

    public List<CmsSearchFieldMapping> getMappings() {
        return this.m_mappings;
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name == null ? 41 : this.m_name.hashCode();
    }

    public boolean isCompressed() {
        return this.m_compressed;
    }

    public boolean isDisplayed() {
        return this.m_displayed;
    }

    public boolean isIndexed() {
        return this.m_indexed;
    }

    public boolean isInExcerpt() {
        return this.m_excerpt;
    }

    public boolean isInExcerptAndStored() {
        return this.m_excerpt && this.m_stored;
    }

    public boolean isStored() {
        return this.m_stored;
    }

    public boolean isTokenized() {
        return this.m_tokenized;
    }

    public boolean isTokenizedAndIndexed() {
        return this.m_tokenized && this.m_indexed;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.m_analyzer = analyzer;
    }

    public void setAnalyzer(String analyzer) throws Exception {
        this.setAnalyzer(CmsSearchManager.getAnalyzer(analyzer));
    }

    public void setBoost(float boost) {
        if (boost < 0.0f) {
            boost = 0.0f;
        }
        this.m_boost = boost;
    }

    public void setBoost(String boost) {
        try {
            this.setBoost(Float.valueOf(boost).floatValue());
        }
        catch (NumberFormatException e) {
            this.setBoost(1.0f);
        }
    }

    public void setBoostDisplay(String boost) {
        this.setBoost(boost);
    }

    public void setCompressed(boolean compressed) {
        this.m_compressed = compressed;
        if (compressed) {
            this.setStored(true);
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = CmsStringUtil.isNotEmptyOrWhitespaceOnly(defaultValue) ? defaultValue.trim() : null;
    }

    public void setDisplayed(boolean displayed) {
        this.m_displayed = displayed;
    }

    public void setDisplayName(String displayName) {
        if (CmsStringUtil.isEmpty(displayName) || IGNORE_DISPLAY_NAME.equals(displayName)) {
            this.m_displayName = null;
            this.setDisplayed(false);
        } else {
            this.m_displayName = displayName;
            this.m_displayNameForConfiguration = displayName;
            this.setDisplayed(true);
        }
    }

    public void setDisplayNameForConfiguration(String displayNameForConfiguration) {
        this.m_displayNameForConfiguration = displayNameForConfiguration;
        this.setDisplayName(displayNameForConfiguration);
    }

    public void setIndexed(boolean indexed) {
        this.m_indexed = indexed;
    }

    public void setIndexed(String indexed) {
        boolean isIndexed = false;
        boolean isTokenized = false;
        if (indexed != null) {
            if (STR_TOKENIZED.equals(indexed = indexed.trim().toLowerCase())) {
                isIndexed = true;
                isTokenized = true;
            } else if (STR_UN_TOKENIZED.equals(indexed)) {
                isIndexed = true;
            } else if (!STR_NO.equals(indexed)) {
                isTokenized = isIndexed = Boolean.valueOf(indexed).booleanValue();
            }
        }
        this.setIndexed(isIndexed);
        this.setTokenized(isTokenized);
    }

    public void setInExcerpt(boolean excerpt) {
        this.m_excerpt = excerpt;
    }

    public void setInExcerpt(String excerpt) {
        this.setInExcerpt(Boolean.valueOf(String.valueOf(excerpt)));
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setStored(boolean stored) {
        this.m_stored = stored;
    }

    public void setStored(String stored) {
        boolean isStored = false;
        boolean isCompressed = false;
        if (stored != null) {
            if (STR_COMPRESS.equals(stored = stored.trim().toLowerCase())) {
                isCompressed = true;
                isStored = true;
            } else {
                isStored = STR_YES.equals(stored) ? true : Boolean.valueOf(stored);
            }
        }
        this.setStored(isStored);
        this.setCompressed(isCompressed);
    }

    public void setTokenized(boolean tokenized) {
        this.m_tokenized = tokenized;
    }
}

