/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import org.opencms.util.A_CmsModeIntEnumeration;
import org.opencms.util.CmsStringUtil;

public final class CmsSearchFieldMappingType
extends A_CmsModeIntEnumeration {
    public static final CmsSearchFieldMappingType ATTRIBUTE = new CmsSearchFieldMappingType(5);
    public static final CmsSearchFieldMappingType CONTENT = new CmsSearchFieldMappingType(0);
    public static final CmsSearchFieldMappingType DYNAMIC = new CmsSearchFieldMappingType(4);
    public static final CmsSearchFieldMappingType ITEM = new CmsSearchFieldMappingType(3);
    public static final CmsSearchFieldMappingType PROPERTY = new CmsSearchFieldMappingType(1);
    public static final CmsSearchFieldMappingType PROPERTY_SEARCH = new CmsSearchFieldMappingType(2);
    private static final long serialVersionUID = 1959271063305411797L;
    private static final String STR_ATTRIBUTE = "attribute";
    private static final String STR_CONTENT = "content";
    private static final String STR_DYNAMIC = "dynamic";
    private static final String STR_ITEM = "item";
    private static final String STR_PROPERTY = "property";
    private static final String STR_PROPERTY_SEARCH = "property-search";

    private CmsSearchFieldMappingType(int mode) {
        super(mode);
    }

    public static CmsSearchFieldMappingType valueOf(String value) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            return null;
        }
        if (STR_CONTENT.equals(value = value.trim().toLowerCase())) {
            return CONTENT;
        }
        if (STR_PROPERTY.equals(value)) {
            return PROPERTY;
        }
        if (STR_PROPERTY_SEARCH.equals(value)) {
            return PROPERTY_SEARCH;
        }
        if (STR_ITEM.equals(value)) {
            return ITEM;
        }
        if (STR_DYNAMIC.equals(value)) {
            return DYNAMIC;
        }
        if (STR_ATTRIBUTE.equals(value)) {
            return ATTRIBUTE;
        }
        return null;
    }

    public String toString() {
        switch (this.getMode()) {
            case 1: {
                return STR_PROPERTY;
            }
            case 2: {
                return STR_PROPERTY_SEARCH;
            }
            case 3: {
                return STR_ITEM;
            }
            case 4: {
                return STR_DYNAMIC;
            }
            case 5: {
                return STR_ATTRIBUTE;
            }
        }
        return STR_CONTENT;
    }
}

