/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONArray;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsGalleryWidgetConfiguration;
import org.opencms.widgets.CmsVfsImageWidgetConfiguration;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplace;

public abstract class A_CmsGalleryWidget
extends A_CmsWidget {
    protected A_CmsGalleryWidget() {
        this("");
    }

    protected A_CmsGalleryWidget(String configuration) {
        super(configuration);
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(256);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/" + this.getNameLower() + "gallery.js"));
        return result.toString();
    }

    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "\tinit" + this.getNameUpper() + "Gallery();\n";
    }

    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append("function init");
        result.append(this.getNameUpper());
        result.append("Gallery() {\n");
        result.append("\t");
        result.append(this.getNameLower());
        result.append("GalleryPath = '");
        result.append("/system/workplace/galleries/");
        result.append(this.getNameLower());
        result.append("gallery/index.jsp?");
        result.append("';\n");
        result.append("}\n");
        return result.toString();
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        long idHash = id.hashCode();
        if (idHash < 0L) {
            idHash = -idHash;
            idHash += 0x100000000L;
        }
        StringBuffer result = new StringBuffer(128);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"xmlTd\">");
        result.append("<input class=\"xmlInput textInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        String value = param.getStringValue(cms);
        result.append(value);
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" onkeyup=\"checkPreview('");
        result.append(id);
        result.append("');\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button("javascript:open" + this.getNameUpper() + "Gallery('" + "widget" + "',  '" + id + "',  '" + idHash + "');return false;", null, this.getNameLower() + "gallery", Messages.getButtonName(this.getNameLower()), widgetDialog.getButtonStyle()));
        String previewClass = "hide";
        if (this.showPreview(value)) {
            previewClass = "show";
        }
        result.append("<td class=\"");
        result.append(previewClass);
        result.append("\" id=\"preview");
        result.append(id);
        result.append("\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button("javascript:preview" + this.getNameUpper() + "('" + id + "');return false;", null, "preview.png", "GUI_BUTTON_PREVIEW_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        result.append("</tr></table>");
        result.append("</td>");
        if (this.getNameLower().equals("image")) {
            CmsVfsImageWidgetConfiguration configuration = new CmsVfsImageWidgetConfiguration(cms, widgetDialog, param, this.getConfiguration());
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration.getStartup())) {
                result.append("\n<script type=\"text/javascript\">");
                result.append("\nvar startupFolder").append(idHash).append(" = \"").append(configuration.getStartup()).append("\";");
                result.append("\nvar startupType").append(idHash).append(" = \"").append(configuration.getType()).append("\";");
                result.append("\n</script>");
            } else {
                result.append("\n<script type=\"text/javascript\">");
                result.append("\nvar startupFolder").append(idHash).append(" = null;");
                result.append("\nvar startupType").append(idHash).append(" = null;");
                result.append("\n</script>");
            }
            if (configuration.isShowFormat()) {
                result.append("\n<script type=\"text/javascript\">");
                JSONArray formatsJson = new JSONArray(configuration.getFormatValues());
                result.append("\nvar imgFmts").append(idHash).append(" = ").append(formatsJson).append(";");
                result.append("\nvar imgFmtNames").append(idHash).append(" = \"").append(CmsEncoder.escape(configuration.getSelectFormatString(), "UTF-8")).append("\";");
                result.append("\nvar useFmts").append(idHash).append(" = true;");
                result.append("\n</script>");
            } else {
                result.append("\n<script type=\"text/javascript\">");
                result.append("\nvar useFmts").append(idHash).append(" = false;");
                result.append("\nvar imgFmts").append(idHash).append(" = null;");
                result.append("\nvar imgFmtNames").append(idHash).append(" = null;");
                result.append("\n</script>");
            }
        } else {
            CmsGalleryWidgetConfiguration configuration = new CmsGalleryWidgetConfiguration(cms, widgetDialog, param, this.getConfiguration());
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration.getStartup())) {
                result.append("\n<script type=\"text/javascript\">");
                result.append("\nvar startupFolder").append(idHash).append(" = \"").append(configuration.getStartup()).append("\";");
                result.append("\nvar startupType").append(idHash).append(" = \"").append(configuration.getType()).append("\";");
                result.append("\n</script>");
            } else {
                result.append("\n<script type=\"text/javascript\">");
                result.append("\nvar startupFolder").append(idHash).append(" = null;");
                result.append("\nvar startupType").append(idHash).append(" = null;");
                result.append("\n</script>");
            }
        }
        return result.toString();
    }

    public abstract String getNameLower();

    public abstract String getNameUpper();

    public abstract boolean showPreview(String var1);
}

