/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Set;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;

public class CmsDisplayWidget
extends A_CmsWidget {
    private static final String DISABLED_POSTFIX = ".disabled";

    public CmsDisplayWidget() {
        this("");
    }

    public CmsDisplayWidget(String configuration) {
        super(configuration);
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String value;
        String localizedValue = value = param.getStringValue(cms);
        if (CmsStringUtil.TRUE.equalsIgnoreCase(value) || CmsStringUtil.FALSE.equalsIgnoreCase(value)) {
            boolean booleanValue = Boolean.valueOf(value);
            localizedValue = booleanValue ? Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_LABEL_TRUE_0") : Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_LABEL_FALSE_0");
        }
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\">");
        result.append("<span class=\"xmlInput textInput\" style=\"border: 0px solid black;\">");
        if (CmsStringUtil.isNotEmpty(this.getConfiguration())) {
            result.append(this.getConfiguration());
        } else {
            result.append(localizedValue);
        }
        result.append("</span>");
        result.append("<input type=\"hidden\"");
        result.append(" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" value=\"");
        result.append(CmsEncoder.escapeXml(value));
        result.append("\">");
        result.append("</td>");
        return result.toString();
    }

    public String getHelpBubble(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(128);
        String locKey = this.getDisabledHelpKey(param);
        String locValue = widgetDialog.getMessages().key(locKey, true);
        if (locValue == null) {
            return widgetDialog.dialogHorizontalSpacer(16);
        }
        result.append("<td>");
        result.append("<img name=\"img");
        result.append(locKey);
        result.append("\" id=\"img");
        result.append(locKey);
        result.append("\" src=\"");
        result.append(OpenCms.getLinkManager().substituteLink(cms, "/system/workplace/resources/commons/help.png"));
        result.append("\" alt=\"\" border=\"0\"");
        if (widgetDialog.useNewStyle()) {
            result.append(this.getJsHelpMouseHandler(widgetDialog, locKey, null));
        } else {
            result.append(this.getJsHelpMouseHandler(widgetDialog, locKey, CmsEncoder.escape(locValue, cms.getRequestContext().getEncoding())));
        }
        result.append("></td>");
        return result.toString();
    }

    public String getHelpText(I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String helpId = this.getDisabledHelpKey(param);
        Set<String> helpIdsShown = widgetDialog.getHelpMessageIds();
        if (helpIdsShown.contains(helpId)) {
            return "";
        }
        helpIdsShown.add(helpId);
        String locValue = widgetDialog.getMessages().key(helpId, true);
        if (locValue == null) {
            return "";
        }
        if (widgetDialog.useNewStyle()) {
            StringBuffer result = new StringBuffer(128);
            result.append("<div class=\"help\" id=\"help");
            result.append(helpId);
            result.append("\"");
            result.append(this.getJsHelpMouseHandler(widgetDialog, helpId, helpId));
            result.append(">");
            result.append(locValue);
            result.append("</div>\n");
            return result.toString();
        }
        return "";
    }

    public I_CmsWidget newInstance() {
        return new CmsDisplayWidget(this.getConfiguration());
    }

    private String getDisabledHelpKey(I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(64);
        result.append("label.");
        result.append(param.getKey());
        result.append(".help");
        result.append(DISABLED_POSTFIX);
        return result.toString();
    }
}

