/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.opencms.file.CmsObject;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsGalleryWidgetDynamicConfiguration;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

public class CmsGalleryWidgetConfiguration {
    public static final String CONFIG_KEY_CLASS = "class";
    public static final String CONFIG_KEY_STARTUP = "startup";
    public static final String CONFIG_KEY_TYPE = "type";
    public static final String CONFIG_VALUE_DYNAMIC = "dynamic";
    protected String m_className;
    protected String m_startup;
    protected String m_type;

    protected CmsGalleryWidgetConfiguration() {
    }

    public CmsGalleryWidgetConfiguration(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param, String configuration) {
        this.init(cms, widgetDialog, param, configuration);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getStartup() {
        return this.m_startup;
    }

    public String getType() {
        return this.m_type;
    }

    protected void init(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param, String configuration) {
        if (configuration == null) {
            return;
        }
        configuration = CmsMacroResolver.resolveMacros(configuration, cms, widgetDialog.getMessages());
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj = new JSONObject(configuration);
        }
        catch (JSONException e) {
            return;
        }
        this.setClassName(jsonObj.optString(CONFIG_KEY_CLASS, null));
        I_CmsGalleryWidgetDynamicConfiguration dynConf = null;
        if (this.getClassName() != null) {
            try {
                dynConf = (I_CmsGalleryWidgetDynamicConfiguration)Class.forName(this.getClassName()).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.setType(jsonObj.optString(CONFIG_KEY_TYPE));
        if ((CONFIG_VALUE_DYNAMIC.equals(this.getType()) || CmsStringUtil.isEmpty(this.getType())) && dynConf != null) {
            this.setType(dynConf.getType(cms, widgetDialog, param));
        }
        this.setStartup(jsonObj.optString(CONFIG_KEY_STARTUP));
        if ((CONFIG_VALUE_DYNAMIC.equals(this.getStartup()) || CmsStringUtil.isEmpty(this.getStartup())) && dynConf != null) {
            this.setStartup(dynConf.getStartup(cms, widgetDialog, param));
        }
    }

    protected void setClassName(String className) {
        this.m_className = className;
    }

    protected void setStartup(String startup) {
        this.m_startup = startup;
    }

    protected void setType(String type) {
        this.m_type = type;
    }
}

