/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsMultiSelectWidget
extends A_CmsSelectWidget {
    public static final String CONFIGURATION_ASCHECKBOXES = "ascheckboxes";
    public static final String CONFIGURATION_REQUIRES_ACTIVATION = "requiresactivation";
    private boolean m_asCheckBoxes;
    private boolean m_requiresActivation;

    public CmsMultiSelectWidget() {
    }

    public CmsMultiSelectWidget(List<CmsSelectWidgetOption> configuration) {
        this(configuration, false);
    }

    public CmsMultiSelectWidget(List<CmsSelectWidgetOption> configuration, boolean asCheckboxes) {
        super(configuration);
        this.m_asCheckBoxes = asCheckboxes;
    }

    public CmsMultiSelectWidget(String configuration) {
        super(configuration);
    }

    public static void setMultiSelectEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            StringBuffer value = new StringBuffer(128);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    value.append(',');
                }
                value.append(values[i]);
            }
            param.setStringValue(cms, value.toString());
        } else {
            param.setStringValue(cms, "");
        }
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/multiselector.js");
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        List<CmsSelectWidgetOption> options = this.parseSelectOptions(cms, widgetDialog, param);
        result.append("<td class=\"xmlTd\">");
        if (!this.m_asCheckBoxes) {
            if (this.m_requiresActivation) {
                result.append("<input style=\"vertical-align:middle;\" type=\"checkbox\" id=\"check" + id + "\" name=\"check" + id + "\"" + "onclick=toggleMultiSelectWidget(this);" + " />");
                result.append("&nbsp;<label style=\"vertical-align:middle;\" for=\"check" + id + "\">");
                result.append(widgetDialog.getMessages().key("GUI_MULTISELECT_ACTIVATE_0"));
                result.append("</label>&nbsp;");
                result.append("<input type='hidden' name='").append(id).append("' id='").append(id).append("' value='");
                List<String> values = this.getSelectedValues(cms, param);
                if (values.size() > 0) {
                    result.append(values.get(0));
                    for (int i = 1; i < values.size(); ++i) {
                        result.append(",").append(values.get(i));
                    }
                }
                result.append("' />");
                id = "display" + id;
            }
            result.append("<select multiple size='");
            result.append(options.size());
            result.append("' style=\"vertical-align:middle;\" class=\"xmlInput");
            if (param.hasError()) {
                result.append(" xmlInputError");
            }
            result.append("\" ");
            if (this.m_requiresActivation) {
                result.append("disabled=\"true\" ");
            }
            result.append("name=\"");
            result.append(id);
            result.append("\" id=\"");
            result.append(id);
            result.append("\">");
        }
        List<String> selected = this.getSelectedValues(cms, param);
        for (CmsSelectWidgetOption option : options) {
            if (!this.m_asCheckBoxes) {
                result.append("<option value=\"");
                result.append(option.getValue());
                result.append("\"");
                if (selected.contains(option.getValue())) {
                    result.append(" selected=\"selected\"");
                }
                result.append(">");
                result.append(option.getOption());
                result.append("</option>");
                continue;
            }
            result.append("<input type='checkbox' name='");
            result.append(id);
            result.append("' value='");
            result.append(option.getValue());
            result.append("'");
            if (selected.contains(option.getValue())) {
                result.append(" checked");
            }
            result.append(">");
            result.append(option.getOption());
            result.append("<br>");
        }
        if (!this.m_asCheckBoxes) {
            result.append("</select>");
        }
        result.append("</td>");
        return result.toString();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsMultiSelectWidget(this.getConfiguration());
    }

    @Override
    public void setConfiguration(String configuration) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int reqiresActivationIndex;
            int asCheckBoxesIndex = configuration.indexOf(CONFIGURATION_ASCHECKBOXES);
            if (asCheckBoxesIndex != -1) {
                String asCheckBoxes = configuration.substring(asCheckBoxesIndex + CONFIGURATION_ASCHECKBOXES.length() + 1);
                if (asCheckBoxes.indexOf(124) != -1) {
                    asCheckBoxes = asCheckBoxes.substring(0, asCheckBoxes.indexOf(124));
                }
                this.m_asCheckBoxes = Boolean.parseBoolean(asCheckBoxes);
            }
            if ((reqiresActivationIndex = configuration.indexOf(CONFIGURATION_REQUIRES_ACTIVATION)) != -1) {
                String requiresActivation = configuration.substring(reqiresActivationIndex + CONFIGURATION_REQUIRES_ACTIVATION.length() + 1);
                if (requiresActivation.indexOf(124) != -1) {
                    requiresActivation = requiresActivation.substring(0, requiresActivation.indexOf(124));
                }
                this.m_requiresActivation = Boolean.parseBoolean(requiresActivation);
            }
        }
        super.setConfiguration(configuration);
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        CmsMultiSelectWidget.setMultiSelectEditorValue(cms, formParameters, widgetDialog, param);
    }
}

