/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsMacroResolver;
import org.opencms.widgets.A_CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSelectWidget
extends A_CmsSelectWidget {
    public CmsSelectWidget() {
    }

    public CmsSelectWidget(List<CmsSelectWidgetOption> configuration) {
        super(configuration);
    }

    public CmsSelectWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\" style=\"height: 25px;\"><select class=\"xmlInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\">");
        List<CmsSelectWidgetOption> options = this.parseSelectOptions(cms, widgetDialog, param);
        String selected = this.getSelectedValue(cms, param);
        for (CmsSelectWidgetOption option : options) {
            result.append("<option value=\"");
            result.append(option.getValue());
            result.append("\"");
            if (selected != null && selected.equals(option.getValue())) {
                result.append(" selected=\"selected\"");
            }
            result.append(">");
            result.append(option.getOption());
            result.append("</option>");
        }
        result.append("</select>");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getWidgetStringValue(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String result = super.getWidgetStringValue(cms, widgetDialog, param);
        String configuration = CmsMacroResolver.resolveMacros(this.getConfiguration(), cms, widgetDialog.getMessages());
        if (configuration == null) {
            configuration = param.getDefault(cms);
        }
        List<CmsSelectWidgetOption> options = CmsSelectWidgetOption.parseOptions(configuration);
        for (int m = 0; m < options.size(); ++m) {
            CmsSelectWidgetOption option = options.get(m);
            if (!result.equals(option.getValue())) continue;
            result = option.getOption();
            break;
        }
        return result;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsSelectWidget(this.getConfiguration());
    }
}

