/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.Messages;

public class CmsDialogSelector {
    public static final String DIALOG_DELETE = "class_dialog_delete";
    public static final String DIALOG_LOCK = "class_dialog_lock";
    public static final String DIALOG_PROPERTY = "class_dialog_property";
    private static final Log LOG = CmsLog.getLog(CmsDialogSelector.class);
    private String m_handler;
    private CmsJspActionElement m_jsp;
    private String m_paramResource;

    public CmsDialogSelector(CmsJspActionElement jsp, String handler) {
        this.setJsp(jsp);
        this.setHandler(handler);
        this.setParamResource(CmsEncoder.decode(jsp.getRequest().getParameter("resource")));
    }

    public String getSelectedDialogUri() {
        I_CmsDialogHandler dialogClass;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DIALOG_HANDLER_CLASS_2", this.getClass().getName(), this.getHandler()));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_PARAM_RESOURCE_2", this.getClass().getName(), this.getParamResource()));
        }
        if ((dialogClass = OpenCms.getWorkplaceManager().getDialogHandler(this.getHandler())) == null) {
            return "/system/workplace/views/explorer/explorer_files.jsp";
        }
        return dialogClass.getDialogUri(this.getParamResource(), this.getJsp());
    }

    private String getHandler() {
        return this.m_handler;
    }

    private CmsJspActionElement getJsp() {
        return this.m_jsp;
    }

    private String getParamResource() {
        return this.m_paramResource;
    }

    private void setHandler(String handler) {
        this.m_handler = handler;
    }

    private void setJsp(CmsJspActionElement jsp) {
        this.m_jsp = jsp;
    }

    private void setParamResource(String resource) {
        this.m_paramResource = resource;
    }
}

