/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.Buffer;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CmsWorkplace {
    public static final boolean DEBUG = false;
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final String DEFAULT_LANGUAGE = DEFAULT_LOCALE.getLanguage();
    public static final int HTML_END = 1;
    public static final int HTML_START = 0;
    public static final String PARAM_WP_EXPLORER_RESOURCE = "wpExplorerResource";
    public static final String PARAM_WP_PROJECT = "wpProject";
    public static final String PARAM_WP_SITE = "wpSite";
    public static final String RES_PATH_FILETYPES = "filetypes/";
    public static final String VFS_PATH_SYSTEM = "/system/";
    public static final String VFS_PATH_WORKPLACE = "/system/workplace/";
    public static final String PATH_DIALOGS = "/system/workplace/commons/";
    public static final String PATH_WORKPLACE = "/system/workplace/";
    public static final String RFS_PATH_RESOURCES = "/resources/";
    public static final String VFS_DIR_DEFAULTBODIES = "default_bodies/";
    public static final String VFS_DIR_TEMPLATES = "templates/";
    public static final String VFS_PATH_COMMONS = "/system/workplace/commons/";
    public static final String VFS_PATH_EDITORS = "/system/workplace/editors/";
    public static final String VFS_PATH_GALLERIES = "/system/galleries/";
    public static final String VFS_PATH_LOCALES = "/system/workplace/locales/";
    public static final String VFS_PATH_MODULES = "/system/modules/";
    public static final String VFS_PATH_RESOURCES = "/system/workplace/resources/";
    public static final String VFS_PATH_VIEWS = "/system/workplace/views/";
    public static final String FILE_EXPLORER_FILELIST = "/system/workplace/views/explorer/explorer_files.jsp";
    public static final String DIALOG_PATH_COMMON = "/system/workplace/commons/includes/";
    public static final String FILE_DIALOG_CLOSE = "/system/workplace/commons/includes/closedialog.jsp";
    public static final String FILE_DIALOG_SCREEN_CONFIRM = "/system/workplace/commons/includes/confirmation.jsp";
    public static final String FILE_DIALOG_SCREEN_ERROR = "/system/workplace/commons/includes/error.jsp";
    public static final String FILE_DIALOG_SCREEN_ERRORPAGE = "/system/workplace/commons/includes/errorpage.jsp";
    public static final String FILE_DIALOG_SCREEN_WAIT = "/system/workplace/commons/includes/wait.jsp";
    public static final String FILE_REPORT_OUTPUT = "/system/workplace/commons/includes/report.jsp";
    public static final String VIEW_DIRECT_EDIT = "/system/workplace/views/explorer/directEdit.jsp";
    public static final String VIEW_WORKPLACE = "/system/workplace/views/explorer/explorer_fs.jsp";
    protected static final String REQUEST_ATTRIBUTE_MULTIPART = "__CmsWorkplace.MULTIPART";
    protected static final String REQUEST_ATTRIBUTE_RELOADTREE = "__CmsWorkplace.RELOADTREE";
    protected static final String SESSION_WORKPLACE_CLASS = "__CmsWorkplace.WORKPLACE_CLASS";
    private static final Log LOG = CmsLog.getLog(CmsWorkplace.class);
    private static String m_file_explorer_filelist;
    private static String m_skinUri;
    private static String m_styleUri;
    private CmsObject m_cms;
    private CmsUUID m_currentProjectId;
    private boolean m_forwarded;
    private CmsJspActionElement m_jsp;
    private CmsMacroResolver m_macroResolver;
    private CmsMultiMessages m_messages;
    private List<FileItem> m_multiPartFileItems;
    private Map<String, String[]> m_parameterMap;
    private String m_resourceUri;
    private HttpSession m_session;
    private CmsWorkplaceSettings m_settings;

    public CmsWorkplace(CmsJspActionElement jsp) {
        this.initWorkplaceMembers(jsp);
    }

    public CmsWorkplace(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String buildSelect(String parameters, List<String> options, List<String> values, int selected, boolean useLineFeed) {
        StringBuffer result = new StringBuffer(1024);
        result.append("<select ");
        if (parameters != null) {
            result.append(parameters);
        }
        result.append(">");
        if (useLineFeed) {
            result.append("\n");
        }
        int length = options.size();
        String value = null;
        for (int i = 0; i < length; ++i) {
            if (values != null) {
                try {
                    value = values.get(i);
                }
                catch (Exception e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)e.getLocalizedMessage());
                    }
                    value = null;
                }
            }
            if (value == null) {
                result.append("<option");
                if (i == selected) {
                    result.append(" selected=\"selected\"");
                }
                result.append(">");
                result.append(options.get(i));
                result.append("</option>");
                if (!useLineFeed) continue;
                result.append("\n");
                continue;
            }
            result.append("<option value=\"");
            result.append(value);
            result.append("\"");
            if (i == selected) {
                result.append(" selected=\"selected\"");
            }
            result.append(">");
            result.append(options.get(i));
            result.append("</option>");
            if (!useLineFeed) continue;
            result.append("\n");
        }
        result.append("</select>");
        if (useLineFeed) {
            result.append("\n");
        }
        return result.toString();
    }

    public static String getResourceUri(String resourceName) {
        StringBuffer result = new StringBuffer(256);
        result.append(CmsWorkplace.getSkinUri());
        result.append(resourceName);
        return result.toString();
    }

    public static String getSkinUri() {
        if (m_skinUri == null) {
            m_skinUri = OpenCms.getSystemInfo().getContextPath() + RFS_PATH_RESOURCES;
        }
        return m_skinUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStyleUri(CmsJspActionElement jsp) {
        if (m_styleUri == null) {
            CmsProject project = jsp.getCmsObject().getRequestContext().getCurrentProject();
            try {
                jsp.getCmsObject().getRequestContext().setCurrentProject(jsp.getCmsObject().readProject(CmsProject.ONLINE_PROJECT_ID));
                m_styleUri = jsp.link("/system/workplace/commons/style/");
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
            finally {
                jsp.getCmsObject().getRequestContext().setCurrentProject(project);
            }
        }
        return m_styleUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStyleUri(CmsJspActionElement jsp, String filename) {
        if (m_styleUri == null) {
            CmsProject project = jsp.getCmsObject().getRequestContext().getCurrentProject();
            try {
                jsp.getCmsObject().getRequestContext().setCurrentProject(jsp.getCmsObject().readProject(CmsProject.ONLINE_PROJECT_ID));
                m_styleUri = jsp.link("/system/workplace/commons/style/");
            }
            catch (CmsException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                jsp.getCmsObject().getRequestContext().setCurrentProject(project);
            }
        }
        return m_styleUri + filename;
    }

    public static String getTemporaryFileName(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(resourceName.length() + 2);
        result.append(CmsResource.getFolderPath(resourceName));
        result.append("~");
        result.append(CmsResource.getName(resourceName));
        return result.toString();
    }

    public static CmsWorkplaceSettings initUserSettings(CmsObject cms, CmsWorkplaceSettings settings, boolean update) {
        CmsUser user;
        if (settings == null) {
            settings = new CmsWorkplaceSettings();
        }
        if (update) {
            try {
                user = cms.readUser(cms.getRequestContext().getCurrentUser().getId());
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
                user = cms.getRequestContext().getCurrentUser();
            }
        } else {
            user = cms.getRequestContext().getCurrentUser();
        }
        settings.setUser(user);
        settings.setUserSettings(new CmsUserSettings(user));
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CmsWorkplaceSettings initWorkplaceSettings(CmsObject cms, CmsWorkplaceSettings settings, boolean update) {
        List<CmsSite> sites;
        settings = CmsWorkplace.initUserSettings(cms, settings, update);
        settings.setProject(cms.getRequestContext().getCurrentProject().getUuid());
        String siteRoot = settings.getUserSettings().getStartSite();
        if (siteRoot.endsWith("/")) {
            siteRoot = siteRoot.substring(0, siteRoot.length() - 1);
        }
        if (CmsStringUtil.isNotEmpty(siteRoot) && OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot) == null && (siteRoot = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartSite()).endsWith("/")) {
            siteRoot = siteRoot.substring(0, siteRoot.length() - 1);
        }
        boolean access = false;
        CmsResource res = null;
        String currentSite = cms.getRequestContext().getSiteRoot();
        cms.getRequestContext().setSiteRoot(siteRoot);
        try {
            res = cms.readResource("/");
            access = cms.hasPermissions(res, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ONLY_VISIBLE);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            cms.getRequestContext().setSiteRoot(currentSite);
        }
        if (!(res != null && access || (sites = OpenCms.getSiteManager().getAvailableSites(cms, true)).size() <= 0)) {
            siteRoot = sites.get(0).getSiteRoot();
            cms.getRequestContext().setSiteRoot(siteRoot);
        }
        settings.setSite(siteRoot);
        String startFolder = settings.getUserSettings().getStartFolder();
        if (!cms.existsResource(startFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
            startFolder = "/";
            settings.getUserSettings().setStartFolder(startFolder);
        }
        if (OpenCms.getSiteManager().startsWithShared(cms.getRequestContext().getSiteRoot())) {
            String contextSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot(siteRoot);
                settings.setExplorerResource(startFolder, cms);
            }
            finally {
                cms.getRequestContext().setSiteRoot(contextSiteRoot);
            }
        } else {
            settings.setExplorerResource(startFolder, cms);
        }
        settings.setViewUri(OpenCms.getLinkManager().substituteLink(cms, settings.getUserSettings().getStartView()));
        return settings;
    }

    public static boolean isTemporaryFile(CmsResource resource) {
        return resource != null && resource.isFile() && ((resource.getFlags() & 0x400) > 0 || CmsResource.isTemporaryFileName(resource.getName()));
    }

    static void storeSettings(HttpSession session, CmsWorkplaceSettings settings) {
        session.setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)settings);
    }

    public String allParamsAsHidden() {
        StringBuffer result = new StringBuffer(512);
        Map<String, Object> params = this.allParamValues();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            result.append("<input type=\"hidden\" name=\"");
            result.append(entry.getKey());
            result.append("\" value=\"");
            String encoded = CmsEncoder.encode(entry.getValue().toString(), this.getCms().getRequestContext().getEncoding());
            result.append(encoded);
            result.append("\">\n");
        }
        return result.toString();
    }

    public String allParamsAsRequest() {
        StringBuffer retValue = new StringBuffer(512);
        HttpServletRequest request = this.getJsp().getRequest();
        Iterator paramNames = request.getParameterMap().keySet().iterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            String paramValue = request.getParameter(paramName);
            retValue.append(paramName + "=" + CmsEncoder.encode(paramValue, this.getCms().getRequestContext().getEncoding()));
            if (!paramNames.hasNext()) continue;
            retValue.append("&");
        }
        return retValue.toString();
    }

    public String bodyEnd() {
        return this.pageBody(1, null, null);
    }

    public String bodyStart(String className) {
        return this.pageBody(0, className, null);
    }

    public String bodyStart(String className, String parameters) {
        return this.pageBody(0, className, parameters);
    }

    public String buildSelect(String parameters, List<String> options, List<String> values, int selected) {
        return CmsWorkplace.buildSelect(parameters, options, values, selected, true);
    }

    public String button(String href, String target, String image, String label, int type) {
        return this.button(href, target, image, label, type, CmsWorkplace.getSkinUri() + "buttons/");
    }

    public String button(String href, String target, String image, String label, int type, String imagePath) {
        StringBuffer result = new StringBuffer(256);
        String anchorStart = "<a href=\"";
        if (href != null && href.toLowerCase().startsWith("javascript:")) {
            anchorStart = "<a href=\"#\" onclick=\"";
        }
        result.append("<td style=\"vertical-align: top;\">");
        switch (type) {
            case 1: {
                if (href != null) {
                    result.append(anchorStart);
                    result.append(href);
                    result.append("\" class=\"button\"");
                    if (target != null) {
                        result.append(" target=\"");
                        result.append(target);
                        result.append("\"");
                    }
                    result.append(">");
                }
                result.append("<span unselectable=\"on\" ");
                if (href != null) {
                    result.append("class=\"norm\" onmouseover=\"className='over'\" onmouseout=\"className='norm'\" onmousedown=\"className='push'\" onmouseup=\"className='over'\"");
                } else {
                    result.append("class=\"disabled\"");
                }
                result.append("><span unselectable=\"on\" class=\"combobutton\" ");
                result.append("style=\"background-image: url('");
                result.append(imagePath);
                result.append(image);
                if (image != null && image.indexOf(46) == -1) {
                    result.append(".png");
                }
                result.append("');\">");
                result.append(this.shortKey(label));
                result.append("</span></span>");
                if (href == null) break;
                result.append("</a>");
                break;
            }
            case 2: {
                if (href != null) {
                    result.append(anchorStart);
                    result.append(href);
                    result.append("\" class=\"button\"");
                    if (target != null) {
                        result.append(" target=\"");
                        result.append(target);
                        result.append("\"");
                    }
                    result.append(">");
                }
                result.append("<span unselectable=\"on\" ");
                if (href != null) {
                    result.append("class=\"norm\" onmouseover=\"className='over'\" onmouseout=\"className='norm'\" onmousedown=\"className='push'\" onmouseup=\"className='over'\"");
                } else {
                    result.append("class=\"disabled\"");
                }
                result.append("><span unselectable=\"on\" class=\"txtbutton\">");
                result.append(this.shortKey(label));
                result.append("</span></span>");
                if (href == null) break;
                result.append("</a>");
                break;
            }
            default: {
                if (href != null) {
                    result.append(anchorStart);
                    result.append(href);
                    result.append("\" class=\"button\"");
                    if (target != null) {
                        result.append(" target=\"");
                        result.append(target);
                        result.append("\"");
                    }
                    result.append(" title=\"");
                    result.append(this.key(label));
                    result.append("\">");
                }
                result.append("<span unselectable=\"on\" ");
                if (href != null) {
                    result.append("class=\"norm\" onmouseover=\"className='over'\" onmouseout=\"className='norm'\" onmousedown=\"className='push'\" onmouseup=\"className='over'\"");
                } else {
                    result.append("class=\"disabled\"");
                }
                result.append("><img class=\"button\" src=\"");
                result.append(imagePath);
                result.append(image);
                if (image != null && image.indexOf(46) == -1) {
                    result.append(".png");
                }
                result.append("\" alt=\"");
                result.append(this.key(label));
                result.append("\">");
                result.append("</span>");
                if (href == null) break;
                result.append("</a>");
            }
        }
        result.append("</td>\n");
        return result.toString();
    }

    public String buttonBar(int segment) {
        return this.buttonBar(segment, null);
    }

    public String buttonBar(int segment, String attributes) {
        if (segment == 0) {
            String result = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"";
            if (attributes != null) {
                result = result + " " + attributes;
            }
            return result + "><tr>\n";
        }
        return "</tr></table>";
    }

    public String buttonBarHorizontalLine() {
        StringBuffer result = new StringBuffer(256);
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\">\n");
        result.append("<tr>\n");
        result.append("\t<td class=\"horseparator\" ><img src=\"");
        result.append(CmsWorkplace.getSkinUri());
        result.append("tree/empty.gif\" border=\"0\" width=\"1\" height=\"1\" alt=\"\"></td>\n");
        result.append("</tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    public String buttonBarLabel(String label) {
        return this.buttonBarLabel(label, "norm");
    }

    public String buttonBarLabel(String label, String className) {
        StringBuffer result = new StringBuffer(128);
        result.append("<td><span class=\"");
        result.append(className);
        result.append("\"><span unselectable=\"on\" class=\"txtbutton\">");
        result.append(this.key(label));
        result.append("</span></span></td>\n");
        return result.toString();
    }

    public String buttonBarLine(int leftPixel, int rightPixel, String className) {
        StringBuffer result = new StringBuffer(512);
        if (leftPixel > 0) {
            result.append(this.buttonBarLineSpacer(leftPixel));
        }
        result.append("<td><span class=\"");
        result.append(className);
        result.append("\"></span></td>\n");
        if (rightPixel > 0) {
            result.append(this.buttonBarLineSpacer(rightPixel));
        }
        return result.toString();
    }

    public String buttonBarLineSpacer(int pixel) {
        StringBuffer result = new StringBuffer(128);
        result.append("<td><span class=\"norm\"><span unselectable=\"on\" class=\"txtbutton\" style=\"padding-right: 0px; padding-left: ");
        result.append(pixel);
        result.append("px;\"></span></span></td>\n");
        return result.toString();
    }

    public String buttonBarSeparator(int leftPixel, int rightPixel) {
        return this.buttonBarLine(leftPixel, rightPixel, "separator");
    }

    public String buttonBarSpacer(int width) {
        StringBuffer result = new StringBuffer(128);
        result.append("<td><span class=\"norm\"><span unselectable=\"on\" class=\"txtbutton\" style=\"width: ");
        result.append(width);
        result.append("px;\"></span></span></td>\n");
        return result.toString();
    }

    public String buttonBarStartTab(int leftPixel, int rightPixel) {
        StringBuffer result = new StringBuffer(512);
        result.append(this.buttonBarLineSpacer(leftPixel));
        result.append("<td><span class=\"starttab\"><span style=\"width:1px; height:1px\"></span></span></td>\n");
        result.append(this.buttonBarLineSpacer(rightPixel));
        return result.toString();
    }

    public void checkLock(String resource) throws CmsException {
        this.checkLock(resource, CmsLockType.EXCLUSIVE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkLock(String resource, CmsLockType type) throws CmsException {
        CmsResource res = this.getCms().readResource(resource, CmsResourceFilter.ALL);
        CmsLock lock = this.getCms().getLock(res);
        boolean lockable = lock.isLockableBy(this.getCms().getRequestContext().getCurrentUser());
        if (OpenCms.getWorkplaceManager().autoLockResources()) {
            if (!lockable) throw new CmsException(Messages.get().container("ERR_WORKPLACE_LOCK_RESOURCE_1", resource));
            if (type == CmsLockType.TEMPORARY) {
                this.getCms().lockResourceTemporary(resource);
                return;
            } else {
                this.getCms().lockResource(resource);
            }
            return;
        } else {
            if (lockable) return;
            throw new CmsException(Messages.get().container("ERR_WORKPLACE_LOCK_RESOURCE_1", resource));
        }
    }

    public void fillParamValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.initSettings(settings, request);
        this.fillParamValues(request);
    }

    public void fillParamValues(HttpServletRequest request) {
        this.m_parameterMap = null;
        if (null == request.getAttribute(REQUEST_ATTRIBUTE_MULTIPART)) {
            this.m_multiPartFileItems = CmsRequestUtil.readMultipartFileItems(request);
            if (this.m_multiPartFileItems != null) {
                this.m_parameterMap = CmsRequestUtil.readParameterMapFromMultiPart(this.getCms().getRequestContext().getEncoding(), this.m_multiPartFileItems);
                request.setAttribute(REQUEST_ATTRIBUTE_MULTIPART, (Object)Boolean.TRUE);
            }
        }
        if (this.m_parameterMap == null) {
            this.m_parameterMap = request.getParameterMap();
        }
        List<Method> methods = this.paramSetMethods();
        for (Method m : methods) {
            String name = m.getName().substring(8).toLowerCase();
            String[] values = this.m_parameterMap.get(name);
            String value = null;
            if (values != null) {
                value = values[0];
            }
            if (CmsStringUtil.isEmpty(value)) {
                value = null;
            }
            value = this.decodeParamValue(name, value);
            try {
                if (LOG.isDebugEnabled() && value != null) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_PARAM_2", m.getName(), value));
                }
                m.invoke((Object)this, value);
            }
            catch (InvocationTargetException ite) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)ite.getLocalizedMessage());
            }
            catch (IllegalAccessException eae) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)eae.getLocalizedMessage());
            }
        }
    }

    public String getBroadcastMessageString() {
        CmsSessionInfo sessionInfo = OpenCms.getSessionManager().getSessionInfo(this.getSession());
        if (sessionInfo == null) {
            return null;
        }
        String sessionId = sessionInfo.getSessionId().toString();
        Buffer messageQueue = OpenCms.getSessionManager().getBroadcastQueue(sessionId);
        if (!messageQueue.isEmpty()) {
            StringBuffer result = new StringBuffer(512);
            while (!messageQueue.isEmpty()) {
                CmsBroadcast message = (CmsBroadcast)messageQueue.remove();
                result.append('[');
                result.append(this.getMessages().getDateTime(message.getSendTime()));
                result.append("] ");
                result.append(this.key("GUI_LABEL_BROADCASTMESSAGEFROM_0"));
                result.append(' ');
                if (message.getUser() != null) {
                    result.append(message.getUser().getName());
                } else {
                    result.append(this.key("GUI_LABEL_BROADCAST_FROM_SYSTEM_0"));
                }
                result.append(":\n");
                result.append(message.getMessage());
                result.append("\n\n");
            }
            return result.toString();
        }
        return null;
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public String getEncoding() {
        return OpenCms.getWorkplaceManager().getEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplorerFileListFullUri() {
        if (m_file_explorer_filelist != null) {
            return m_file_explorer_filelist;
        }
        CmsWorkplace cmsWorkplace = this;
        synchronized (cmsWorkplace) {
            m_file_explorer_filelist = OpenCms.getLinkManager().substituteLink(this.getCms(), FILE_EXPLORER_FILELIST);
        }
        return m_file_explorer_filelist;
    }

    public String getFrameSource(String frameName, String uri) {
        String frameString = "name=\"" + frameName + "\" src=\"" + uri + "\"";
        int paramIndex = uri.indexOf("?");
        if (paramIndex != -1) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        this.getSettings().getFrameUris().put(frameName, uri);
        return frameString;
    }

    public CmsJspActionElement getJsp() {
        return this.m_jsp;
    }

    public Locale getLocale() {
        return this.m_settings.getUserSettings().getLocale();
    }

    public CmsMacroResolver getMacroResolver() {
        if (this.m_macroResolver == null) {
            this.m_macroResolver = CmsMacroResolver.newInstance().setCmsObject(this.m_cms).setMessages(this.getMessages()).setJspPageContext(this.m_jsp == null ? null : this.m_jsp.getJspContext());
        }
        return this.m_macroResolver;
    }

    public CmsMessages getMessages() {
        return this.m_messages;
    }

    public List<FileItem> getMultiPartFileItems() {
        return this.m_multiPartFileItems;
    }

    public String getResourceUri() {
        if (this.m_resourceUri == null) {
            this.m_resourceUri = OpenCms.getSystemInfo().getContextPath() + RFS_PATH_RESOURCES;
        }
        return this.m_resourceUri;
    }

    public HttpSession getSession() {
        return this.m_session;
    }

    public CmsWorkplaceSettings getSettings() {
        return this.m_settings;
    }

    public String getStyleUri(String filename) {
        return CmsWorkplace.getStyleUri(this.getJsp(), filename);
    }

    public String htmlEnd() {
        return this.pageHtml(1, null);
    }

    public String htmlStart(String title) {
        return this.pageHtml(0, title);
    }

    public boolean initSettings(CmsWorkplaceSettings settings, HttpServletRequest request) {
        String explorerResource;
        String site;
        String project = request.getParameter(PARAM_WP_PROJECT);
        boolean reloadRequired = false;
        if (project != null) {
            block7: {
                reloadRequired = true;
                try {
                    this.getCms().readProject(new CmsUUID(project));
                }
                catch (Exception e) {
                    project = String.valueOf(CmsProject.ONLINE_PROJECT_ID);
                }
                try {
                    this.m_cms.getRequestContext().setCurrentProject(this.getCms().readProject(new CmsUUID(project)));
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) break block7;
                    LOG.info((Object)e);
                }
            }
            settings.setProject(new CmsUUID(project));
        }
        if ((site = request.getParameter(PARAM_WP_SITE)) != null) {
            reloadRequired = true;
            this.m_cms.getRequestContext().setSiteRoot(site);
            settings.setSite(site);
        }
        if ((explorerResource = request.getParameter(PARAM_WP_EXPLORER_RESOURCE)) != null) {
            reloadRequired = true;
            settings.setExplorerResource(explorerResource, this.getCms());
        }
        return reloadRequired;
    }

    public boolean isForwarded() {
        return this.m_forwarded;
    }

    public boolean isHelpEnabled() {
        return this.getCms().existsResource(this.resolveMacros("/system/workplace/locales/${request.locale}/help/"), CmsResourceFilter.IGNORE_EXPIRATION);
    }

    public boolean isSubElement() {
        return !this.getJsp().getRequestContext().getUri().equals(this.getJsp().info("opencms.request.element.uri"));
    }

    public String key(String keyName) {
        return this.getMessages().key(keyName);
    }

    public String key(String keyName, Object[] params) {
        return this.getMessages().key(keyName, params);
    }

    public String keyDefault(String keyName, String defaultValue) {
        return this.getMessages().keyDefault(keyName, defaultValue);
    }

    public String nullToEmpty(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }

    public String pageBody(int segment, String className, String parameters) {
        if (segment == 0) {
            StringBuffer result = new StringBuffer(128);
            result.append("</head>\n<body unselectable=\"on\"");
            if (className != null) {
                result.append(" class=\"");
                result.append(className);
                result.append("\"");
            }
            if (CmsStringUtil.isNotEmpty(parameters)) {
                result.append(" ");
                result.append(parameters);
            }
            result.append(">\n");
            return result.toString();
        }
        return "</body>";
    }

    public String pageHtml(int segment, String title) {
        return this.pageHtmlStyle(segment, title, null);
    }

    public String pageHtmlStyle(int segment, String title, String stylesheet) {
        if (segment == 0) {
            StringBuffer result = new StringBuffer(512);
            result.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n");
            result.append("<html>\n<head>\n");
            if (title != null) {
                result.append("<title>");
                result.append(title);
                result.append("</title>\n");
            }
            result.append("<meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=");
            result.append(this.getEncoding());
            result.append("\">\n");
            result.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            result.append(CmsWorkplace.getStyleUri(this.getJsp(), stylesheet == null ? "workplace.css" : stylesheet));
            result.append("\">\n");
            return result.toString();
        }
        return "</html>";
    }

    public String paramsAsHidden() {
        return this.paramsAsHidden(null);
    }

    public String paramsAsHidden(Collection<String> excludes) {
        StringBuffer result = new StringBuffer(512);
        Map<String, Object> params = this.paramValues();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String param = entry.getKey();
            if (excludes != null && excludes.contains(param)) continue;
            result.append("<input type=\"hidden\" name=\"");
            result.append(param);
            result.append("\" value=\"");
            String encoded = CmsEncoder.encode(entry.getValue().toString(), this.getCms().getRequestContext().getEncoding());
            result.append(encoded);
            result.append("\">\n");
        }
        return result.toString();
    }

    public Map<String, String[]> paramsAsParameterMap() {
        return CmsRequestUtil.createParameterMap(this.paramValues());
    }

    public String paramsAsRequest() {
        StringBuffer result = new StringBuffer(512);
        Map<String, Object> params = this.paramValues();
        Iterator<Map.Entry<String, Object>> i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Object> entry = i.next();
            result.append(entry.getKey());
            result.append("=");
            result.append(CmsEncoder.encode(entry.getValue().toString(), this.getCms().getRequestContext().getEncoding()));
            if (!i.hasNext()) continue;
            result.append("&");
        }
        return result.toString();
    }

    public String resolveMacros(String input) {
        return this.getMacroResolver().resolveMacros(input);
    }

    public void sendCmsRedirect(String location) throws IOException {
        this.getJsp().getResponse().sendRedirect(OpenCms.getSystemInfo().getOpenCmsContext() + location);
    }

    public void sendForward(String location, Map<String, ?> params) throws IOException, ServletException {
        this.setForwarded(true);
        Map<String, String[]> parameters = CmsRequestUtil.createParameterMap(params);
        CmsRequestUtil.forwardRequest(this.getJsp().link(location), parameters, this.getJsp().getRequest(), this.getJsp().getResponse());
    }

    public void setForwarded(boolean forwarded) {
        this.m_forwarded = forwarded;
    }

    public String shortKey(String keyName) {
        String value = this.keyDefault(keyName + ".short", null);
        if (value == null) {
            return this.key(keyName);
        }
        return value;
    }

    protected void addMessages(CmsMessages messages) {
        if (messages != null) {
            this.m_messages.addMessages(messages);
        }
    }

    protected void addMessages(String bundleName) {
        this.addMessages(new CmsMessages(bundleName, this.getLocale()));
    }

    protected Map<String, Object> allParamValues() {
        List<Method> methods = this.paramGetMethods();
        HashMap<String, Object> map = new HashMap<String, Object>(methods.size());
        for (Method m : methods) {
            Object o;
            block6: {
                o = null;
                try {
                    o = m.invoke((Object)this, new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)ite);
                    }
                }
                catch (IllegalAccessException eae) {
                    if (!LOG.isInfoEnabled()) break block6;
                    LOG.info((Object)eae);
                }
            }
            if (o == null) {
                o = "";
            }
            map.put(m.getName().substring(8).toLowerCase(), o);
        }
        return map;
    }

    protected void checkRole() throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(this.m_cms, CmsRole.WORKPLACE_USER);
    }

    protected String decodeParamValue(String paramName, String paramValue) {
        if (paramName != null && paramValue != null) {
            return CmsEncoder.decode(paramValue, this.getCms().getRequestContext().getEncoding());
        }
        return null;
    }

    protected Map<String, String[]> getParameterMap() {
        return this.m_parameterMap;
    }

    protected void initMessages() {
    }

    protected void initTimeWarp(CmsUserSettings settings, HttpSession session) {
        long timeWarpSet;
        long timeWarpConf = settings.getTimeWarp();
        Long timeWarpSetLong = (Long)session.getAttribute("__org.opencms.main.CmsContextInfo#m_requestTime");
        long l = timeWarpSet = timeWarpSetLong != null ? timeWarpSetLong : -1L;
        if (timeWarpConf == -1L) {
            if (timeWarpSetLong != null) {
                session.removeAttribute("__org.opencms.main.CmsContextInfo#m_requestTime");
            }
        } else if (timeWarpSet != timeWarpConf) {
            session.setAttribute("__org.opencms.main.CmsContextInfo#m_requestTime", (Object)new Long(timeWarpConf));
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        if (jsp != null) {
            this.m_jsp = jsp;
            this.m_cms = this.m_jsp.getCmsObject();
            this.m_session = this.m_jsp.getRequest().getSession();
            try {
                this.checkRole();
            }
            catch (CmsRoleViolationException e) {
                throw new CmsIllegalStateException(e.getMessageContainer(), (Throwable)e);
            }
            this.m_settings = (CmsWorkplaceSettings)this.m_session.getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS");
            if (this.m_settings == null) {
                this.m_settings = new CmsWorkplaceSettings();
                this.m_settings = CmsWorkplace.initWorkplaceSettings(this.m_cms, this.m_settings, false);
                CmsWorkplace.storeSettings(this.m_session, this.m_settings);
            }
            CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(this.getLocale());
            this.m_messages = new CmsMultiMessages(this.getLocale());
            this.m_messages.addMessages(messages);
            this.initMessages();
            this.initWorkplaceRequestValues(this.m_settings, this.m_jsp.getRequest());
            this.initWorkplaceCmsContext(this.m_settings, this.m_cms);
            this.initTimeWarp(this.m_settings.getUserSettings(), this.m_session);
        }
    }

    protected abstract void initWorkplaceRequestValues(CmsWorkplaceSettings var1, HttpServletRequest var2);

    protected Map<String, Object> paramValues() {
        List<Method> methods = this.paramGetMethods();
        HashMap<String, Object> map = new HashMap<String, Object>(methods.size());
        for (Method m : methods) {
            Object o;
            block5: {
                o = null;
                try {
                    o = m.invoke((Object)this, new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)ite.getLocalizedMessage());
                    }
                }
                catch (IllegalAccessException eae) {
                    if (!LOG.isInfoEnabled()) break block5;
                    LOG.info((Object)eae.getLocalizedMessage());
                }
            }
            if (o == null) continue;
            map.put(m.getName().substring(8).toLowerCase(), o);
        }
        return map;
    }

    protected String substituteSiteTitle(String title) {
        if (title.equals("%SHARED_FOLDER%")) {
            return Messages.get().getBundle(this.getSettings().getUserSettings().getLocale()).key("GUI_SHARED_TITLE_0");
        }
        return title;
    }

    protected void switchToCurrentProject() throws CmsException {
        if (this.m_currentProjectId != null) {
            this.getCms().getRequestContext().setCurrentProject(this.getCms().readProject(this.m_currentProjectId));
        }
    }

    protected CmsUUID switchToTempProject() throws CmsException {
        this.m_currentProjectId = this.getSettings().getProject();
        CmsUUID tempProjectId = OpenCms.getWorkplaceManager().getTempFileProjectId();
        this.getCms().getRequestContext().setCurrentProject(this.getCms().readProject(tempProjectId));
        return tempProjectId;
    }

    private void initWorkplaceCmsContext(CmsWorkplaceSettings settings, CmsObject cms) {
        CmsRequestContext reqCont;
        block8: {
            reqCont = cms.getRequestContext();
            if (!settings.getProject().equals(reqCont.getCurrentProject().getUuid())) {
                try {
                    reqCont.setCurrentProject(cms.readProject(settings.getProject()));
                }
                catch (CmsDbEntryNotFoundException e) {
                    try {
                        reqCont.setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                        settings.setProject(CmsProject.ONLINE_PROJECT_ID);
                    }
                    catch (CmsException ex) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)ex.getLocalizedMessage());
                        }
                    }
                }
                catch (CmsException e1) {
                    if (!LOG.isInfoEnabled()) break block8;
                    LOG.info((Object)e1.getLocalizedMessage());
                }
            }
        }
        if (!settings.getSite().equals(reqCont.getSiteRoot())) {
            reqCont.setSiteRoot(settings.getSite());
        }
    }

    private List<Method> paramGetMethods() {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : this.getClass().getMethods()) {
            if (!method.getName().startsWith("getParam") || method.getParameterTypes().length != 0) continue;
            list.add(method);
        }
        return list;
    }

    private List<Method> paramSetMethods() {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : this.getClass().getMethods()) {
            if (!method.getName().startsWith("setParam") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            list.add(method);
        }
        return list;
    }
}

