/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsChnav
extends CmsDialog {
    public static final int ACTION_CHNAV = 100;
    public static final String DIALOG_TYPE = "chnav";
    public static final String PARAM_NAVPOS = "navpos";
    public static final String PARAM_NAVTEXT = "navtext";
    private static final Log LOG = CmsLog.getLog(CmsChnav.class);
    private String m_paramNavpos;
    private String m_paramNavtext;

    public CmsChnav(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsChnav(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String buildNavPosSelector(CmsObject cms, String filename, String attributes, CmsMessages messages) {
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(cms);
        CmsJspNavElement curNav = navBuilder.getNavigationForResource(filename);
        filename = CmsResource.getParentFolder(filename);
        List<CmsJspNavElement> navList = navBuilder.getNavigationForFolder(filename);
        float maxValue = 0.0f;
        float nextPos = 0.0f;
        float firstValue = 1.0f;
        if (navList.size() > 0) {
            try {
                CmsJspNavElement ne = navList.get(0);
                maxValue = ne.getNavPosition();
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
        if (maxValue != 0.0f) {
            firstValue = maxValue / 2.0f;
        }
        ArrayList<String> options = new ArrayList<String>(navList.size() + 1);
        ArrayList<String> values = new ArrayList<String>(navList.size() + 1);
        options.add(messages.key("GUI_CHNAV_POS_FIRST_0"));
        values.add(firstValue + "");
        for (int i = 0; i < navList.size(); ++i) {
            CmsJspNavElement ne = navList.get(i);
            String navText = ne.getNavText();
            float navPos = ne.getNavPosition();
            nextPos = navPos + 2.0f;
            if (i + 1 < navList.size()) {
                nextPos = navList.get(i + 1).getNavPosition();
            }
            float newPos = nextPos - navPos > 1.0f ? navPos + 1.0f : (navPos + nextPos) / 2.0f;
            if (navPos > maxValue) {
                maxValue = navPos;
            }
            if (curNav != null && curNav.getNavText().equals(navText) && curNav.getNavPosition() == navPos) {
                options.add(CmsEncoder.escapeHtml(messages.key("GUI_CHNAV_POS_CURRENT_1", new Object[]{ne.getFileName()})));
                values.add("-1");
                continue;
            }
            options.add(CmsEncoder.escapeHtml(navText + " [" + ne.getFileName() + "]"));
            values.add(newPos + "");
        }
        options.add(messages.key("GUI_CHNAV_POS_LAST_0"));
        values.add(maxValue + 1.0f + "");
        options.add(messages.key("GUI_CHNAV_NO_CHANGE_0"));
        if (curNav != null && curNav.getNavPosition() == Float.MAX_VALUE) {
            values.add(maxValue + 1.0f + "");
        } else {
            values.add("-1");
        }
        attributes = CmsStringUtil.isNotEmptyOrWhitespaceOnly(attributes) ? " " + attributes : "";
        return CmsWorkplace.buildSelect("name=\"navpos\"" + attributes, options, values, values.size() - 1, true);
    }

    public void actionChangeNav() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        String filename = this.getParamResource();
        String newText = this.getJsp().getRequest().getParameter(PARAM_NAVTEXT);
        String selectedPosString = this.getParamNavpos();
        try {
            float selectedPos;
            block23: {
                this.checkLock(this.getParamResource());
                if (newText != null) {
                    CmsProperty newNavText = new CmsProperty();
                    newNavText.setName("NavText");
                    CmsProperty oldNavText = this.getCms().readPropertyObject(filename, "NavText", false);
                    if (oldNavText.isNullProperty()) {
                        if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                            newNavText.setStructureValue(newText);
                        } else {
                            newNavText.setResourceValue(newText);
                        }
                    } else if (oldNavText.getStructureValue() != null) {
                        newNavText.setStructureValue(newText);
                        newNavText.setResourceValue(oldNavText.getResourceValue());
                    } else {
                        newNavText.setResourceValue(newText);
                    }
                    String oldStructureValue = oldNavText.getStructureValue();
                    String newStructureValue = newNavText.getStructureValue();
                    if (CmsStringUtil.isEmpty(oldStructureValue)) {
                        oldStructureValue = "";
                    }
                    if (CmsStringUtil.isEmpty(newStructureValue)) {
                        newStructureValue = "";
                    }
                    String oldResourceValue = oldNavText.getResourceValue();
                    String newResourceValue = newNavText.getResourceValue();
                    if (CmsStringUtil.isEmpty(oldResourceValue)) {
                        oldResourceValue = "";
                    }
                    if (CmsStringUtil.isEmpty(newResourceValue)) {
                        newResourceValue = "";
                    }
                    if (!oldResourceValue.equals(newResourceValue) || !oldStructureValue.equals(newStructureValue)) {
                        this.getCms().writePropertyObject(this.getParamResource(), newNavText);
                    }
                }
                selectedPos = -1.0f;
                try {
                    selectedPos = Float.parseFloat(selectedPosString);
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) break block23;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            if (selectedPos != -1.0f) {
                CmsProperty newNavPos = new CmsProperty();
                newNavPos.setName("NavPos");
                CmsProperty oldNavPos = this.getCms().readPropertyObject(filename, "NavPos", false);
                if (oldNavPos.isNullProperty()) {
                    if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                        newNavPos.setStructureValue(selectedPosString);
                    } else {
                        newNavPos.setResourceValue(selectedPosString);
                    }
                } else if (oldNavPos.getStructureValue() != null) {
                    newNavPos.setStructureValue(selectedPosString);
                    newNavPos.setResourceValue(oldNavPos.getResourceValue());
                } else {
                    newNavPos.setResourceValue(selectedPosString);
                }
                this.getCms().writePropertyObject(filename, newNavPos);
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
        this.actionCloseDialog();
    }

    public String buildNavPosSelector() {
        return CmsChnav.buildNavPosSelector(this.getCms(), this.getParamResource(), null, this.getMessages());
    }

    public String getCurrentNavText() {
        try {
            String navText = this.getCms().readPropertyObject(this.getParamResource(), "NavText", false).getValue();
            if (navText == null) {
                navText = "";
            }
            return CmsEncoder.escapeXml(navText);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage());
            }
            return "";
        }
    }

    public String getParamNavpos() {
        return this.m_paramNavpos;
    }

    public String getParamNavtext() {
        return this.m_paramNavtext;
    }

    public void setParamNavpos(String value) {
        this.m_paramNavpos = value;
    }

    public void setParamNavtext(String value) {
        this.m_paramNavtext = value;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_CHNAV_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        }
    }
}

