/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.commons.CmsChnav;
import org.opencms.workplace.commons.CmsPropertyAdvanced;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsPropertyCustom
extends CmsPropertyAdvanced {
    public static final int ACTION_EDIT = 500;
    private static final Log LOG = CmsLog.getLog(CmsPropertyCustom.class);
    private CmsExplorerTypeSettings m_explorerTypeSettings;
    private boolean m_showNavigation;

    public CmsPropertyCustom(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPropertyCustom(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionEdit(HttpServletRequest request) throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.isEditable()) {
                this.performEditOperation(request);
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String buildEditForm() {
        StringBuffer result = new StringBuffer(2048);
        boolean editable = this.isEditable();
        result.append("<table border=\"0\" style=\"width:100%\">\n");
        result.append("<tr>\n");
        result.append("\t<td class=\"textbold\" nowrap>");
        result.append(this.key("GUI_PROPERTY_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\">");
        result.append(this.key("GUI_PROPERTY_VALUE_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\" style=\"white-space: nowrap;\">");
        result.append("&nbsp;");
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<tr><td><span style=\"height: 6px;\"></span></td></tr>\n");
        result.append(this.buildTextInput(editable));
        if (this.showNavigation()) {
            result.append(this.buildNavigationProperties(editable));
        }
        result.append("</table>");
        return result.toString();
    }

    public String buildSetFormValues() {
        CmsProperty property;
        String propValue;
        StringBuffer result = new StringBuffer(1024);
        for (String curProperty : this.getExplorerTypeSettings().getProperties()) {
            CmsProperty property2;
            String propValue2;
            if (!this.getActiveProperties().containsKey(curProperty) || (propValue2 = (property2 = (CmsProperty)this.getActiveProperties().get(curProperty)).getValue()) == null) continue;
            propValue2 = propValue2.trim();
            propValue2 = CmsStringUtil.escapeJavaScript(propValue2);
            result.append("\tdocument.getElementById(\"");
            result.append("valprop");
            result.append(curProperty);
            result.append("\").value = \"");
            result.append(propValue2);
            result.append("\";\n");
        }
        if (this.showNavigation() && this.getActiveProperties().containsKey("NavText") && (propValue = (property = (CmsProperty)this.getActiveProperties().get("NavText")).getValue()) != null) {
            propValue = propValue.trim();
            propValue = CmsStringUtil.escapeJavaScript(propValue);
            result.append("\tdocument.getElementById(\"");
            result.append("valprop");
            result.append("NavText");
            result.append("\").value = \"");
            result.append(propValue);
            result.append("\";\n");
        }
        return result.toString();
    }

    public String dialogButtonsOkCancelAdvanced(String okAttributes, String cancelAttributes, String advancedAttributes) {
        if (this.isEditable()) {
            int okButton = 0;
            if (this.getParamDialogmode() != null && this.getParamDialogmode().startsWith("wizard")) {
                okButton = 202;
            }
            if (this.isHideButtonAdvanced()) {
                return this.dialogButtons(new int[]{okButton, 1}, new String[]{okAttributes, cancelAttributes});
            }
            return this.dialogButtons(new int[]{okButton, 1, 3}, new String[]{okAttributes, cancelAttributes, advancedAttributes});
        }
        if (this.isHideButtonAdvanced()) {
            return this.dialogButtons(new int[]{2}, new String[]{cancelAttributes});
        }
        return this.dialogButtons(new int[]{2, 3}, new String[]{cancelAttributes, advancedAttributes});
    }

    public CmsExplorerTypeSettings getExplorerTypeSettings() {
        return this.m_explorerTypeSettings;
    }

    public void setExplorerTypeSettings(CmsExplorerTypeSettings typeSettings) {
        this.m_explorerTypeSettings = typeSettings;
    }

    public void setShowNavigation(boolean showNav) {
        this.m_showNavigation = showNav;
    }

    public boolean showNavigation() {
        return this.m_showNavigation;
    }

    protected StringBuffer buildNavigationProperties(boolean editable) {
        String navPos;
        StringBuffer result;
        block5: {
            result = new StringBuffer(1024);
            String disabled = "";
            if (!editable) {
                disabled = " disabled=\"disabled\"";
            }
            result.append(this.buildTableRowStart(this.key("GUI_PROPERTY_ADD_TO_NAV_0")));
            result.append("<input type=\"checkbox\" name=\"enablenav\" id=\"enablenav\" value=\"true\" onClick=\"toggleNav();\"");
            if (this.getActiveProperties().containsKey("NavText") || this.getActiveProperties().containsKey("NavPos")) {
                result.append(" checked=\"checked\"");
            }
            result.append(disabled);
            result.append(">");
            result.append("</td>\n");
            result.append("\t<td class=\"textcenter\">");
            result.append("&nbsp;");
            result.append(this.buildTableRowEnd());
            result.append(this.buildPropertyEntry("NavText", this.key("GUI_LABEL_NAVTEXT_0"), editable));
            result.append(this.buildTableRowStart(this.key("GUI_CHNAV_INSERT_AFTER_0")));
            result.append(CmsChnav.buildNavPosSelector(this.getCms(), this.getParamResource(), disabled + " id=\"navpos\" class=\"maxwidth noborder\"", this.getMessages()));
            navPos = null;
            try {
                navPos = this.getCms().readPropertyObject(this.getParamResource(), "NavPos", false).getValue();
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block5;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        if (navPos == null) {
            navPos = "";
        }
        result.append("<input type=\"hidden\" name=\"");
        result.append("valhidden");
        result.append("NavPos");
        result.append("\" value=\"");
        result.append(navPos);
        result.append("\">");
        result.append("</td>\n");
        result.append("\t<td class=\"textcenter\">");
        result.append("&nbsp;");
        result.append(this.buildTableRowEnd());
        return result;
    }

    protected StringBuffer buildPropertyEntry(String propertyName, String propertyTitle, boolean editable) {
        StringBuffer result = new StringBuffer(256);
        String disabled = "";
        if (!editable) {
            disabled = " disabled=\"disabled\"";
        }
        result.append(this.buildTableRowStart(propertyTitle));
        CmsProperty currentProperty = (CmsProperty)this.getActiveProperties().get(propertyName);
        String propValue = "";
        if (currentProperty != null) {
            propValue = currentProperty.getValue();
        }
        if (propValue != null) {
            propValue = propValue.trim();
        }
        propValue = CmsEncoder.escapeXml(propValue);
        result.append("<input type=\"text\" class=\"maxwidth\"");
        result.append(" name=\"");
        result.append("valprop");
        result.append(propertyName);
        result.append("\" id=\"");
        result.append("valprop");
        result.append(propertyName);
        result.append("\"");
        if (editable) {
            result.append(" onKeyup=\"checkValue('");
            result.append(propertyName);
            result.append("');\"");
        }
        result.append(disabled);
        result.append(">");
        result.append("<input type=\"hidden\" name=\"");
        result.append("valhidden");
        result.append(propertyName);
        result.append("\" id=\"");
        result.append("valhidden");
        result.append(propertyName);
        result.append("\" value=\"");
        result.append(propValue);
        result.append("\">");
        result.append("</td>\n");
        result.append("\t<td class=\"propertydialog-checkboxcell\">");
        result.append("<input type=\"checkbox\" name=\"");
        result.append("useprop");
        result.append(propertyName);
        result.append("\" id=\"");
        result.append("useprop");
        result.append(propertyName);
        result.append("\" value=\"true\"");
        if (CmsStringUtil.isNotEmpty(propValue)) {
            result.append(" checked=\"checked\"");
        }
        if (editable) {
            result.append(" onClick=\"toggleDelete('");
            result.append(propertyName);
            result.append("');\"");
        }
        result.append(disabled + ">");
        result.append(this.buildTableRowEnd());
        return result;
    }

    protected String buildTableRowEnd() {
        return "</td>\n</tr>\n";
    }

    protected StringBuffer buildTableRowStart(String propertyName) {
        StringBuffer result = new StringBuffer(96);
        result.append("<tr>\n");
        result.append("\t<td style=\"white-space: nowrap;\" unselectable=\"on\">");
        result.append(propertyName);
        result.append("</td>\n");
        result.append("\t<td class=\"maxwidth\">");
        return result;
    }

    protected StringBuffer buildTextInput(boolean editable) {
        StringBuffer result = new StringBuffer(256);
        for (String curProperty : this.getExplorerTypeSettings().getProperties()) {
            result.append(this.buildPropertyEntry(curProperty, curProperty, editable));
        }
        return result;
    }

    protected void initExplorerTypeSettings() {
        try {
            CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
            if (res.isFolder() && !this.getParamResource().endsWith("/")) {
                this.setParamResource(this.getParamResource() + "/");
            }
            String resTypeName = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
            this.setExplorerTypeSettings(this.getSettingsForType(resTypeName));
            this.setShowNavigation(this.getExplorerTypeSettings().isShowNavigation());
        }
        catch (Throwable e) {
            try {
                this.includeErrorpage(this, e);
            }
            catch (JspException exc) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_INCLUDE_FAILED_1", "/system/workplace/commons/includes/errorpage.jsp"));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.initExplorerTypeSettings();
        this.setParamDialogtype("property");
        boolean isPopup = Boolean.valueOf(this.getParamIsPopup());
        if ("default".equals(this.getParamAction())) {
            this.setAction(0);
            try {
                this.actionEdit(request);
                this.sendForward("/system/workplace/commons/property_advanced.jsp", this.paramsAsParameterMap());
                return;
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) return;
                LOG.info((Object)e.getLocalizedMessage());
                return;
            }
        } else if ("saveedit".equals(this.getParamAction())) {
            if (isPopup) {
                this.setAction(7);
                return;
            } else {
                this.setAction(300);
            }
            return;
        } else if ("cancel".equals(this.getParamAction())) {
            if (isPopup) {
                this.setAction(6);
                return;
            } else {
                this.setAction(4);
            }
            return;
        } else {
            this.setAction(500);
            String resName = CmsResource.getName(this.getParamResource());
            if (CmsResource.isTemporaryFileName(resName)) {
                resName = resName.substring(1);
            }
            this.setParamTitle(this.key("GUI_PROPERTIES_1", new Object[]{resName}));
        }
    }

    protected boolean isHideButtonAdvanced() {
        I_CmsDialogHandler handler = OpenCms.getWorkplaceManager().getDialogHandler(this.getDialogHandler());
        CmsParameterConfiguration handlerParams = handler.getConfiguration();
        if (handlerParams != null && handlerParams.containsKey("hideadvanced")) {
            boolean isHideAdvancedSet = false;
            List<String> hAdvanced = handlerParams.getList("hideadvanced");
            if (!hAdvanced.isEmpty()) {
                isHideAdvancedSet = Boolean.valueOf(hAdvanced.get(0));
            }
            if (isHideAdvancedSet) {
                if (OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.ROOT_ADMIN)) {
                    return false;
                }
                if (handlerParams.containsKey("showgroup")) {
                    CmsUser currentUser = this.getCms().getRequestContext().getCurrentUser();
                    List<String> confGroups = handlerParams.getList("showgroup");
                    for (String groupName : confGroups) {
                        try {
                            if (!this.getCms().userInGroup(currentUser.getName(), groupName)) continue;
                            return false;
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean performEditOperation(HttpServletRequest request) throws CmsException {
        boolean useTempfileProject = Boolean.valueOf(this.getParamUsetempfileproject());
        try {
            if (useTempfileProject) {
                this.switchToTempProject();
            }
            for (String curProperty : this.getExplorerTypeSettings().getProperties()) {
                String paramValue = request.getParameter("valprop" + curProperty);
                String oldValue = request.getParameter("valhidden" + curProperty);
                this.writeProperty(curProperty, paramValue, oldValue);
            }
            if (this.showNavigation()) {
                String paramValue = request.getParameter("enablenav");
                String oldValue = null;
                if (Boolean.valueOf(paramValue).booleanValue()) {
                    paramValue = request.getParameter("navpos");
                    if (!"-1".equals(paramValue) && !String.valueOf(Float.MAX_VALUE).equals(paramValue)) {
                        oldValue = request.getParameter("valhiddenNavPos");
                        this.writeProperty("NavPos", paramValue, oldValue);
                    }
                    paramValue = request.getParameter("valpropNavText");
                    oldValue = request.getParameter("valhiddenNavText");
                    this.writeProperty("NavText", paramValue, oldValue);
                } else {
                    this.writeProperty("NavPos", null, null);
                    this.writeProperty("NavText", null, null);
                }
            }
            Object var8_7 = null;
            if (!useTempfileProject) return true;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!useTempfileProject) throw throwable;
            this.switchToCurrentProject();
            throw throwable;
        }
        this.switchToCurrentProject();
        return true;
    }

    protected void writeProperty(String propName, String propValue, String oldValue) throws CmsException {
        CmsProperty currentProperty = (CmsProperty)this.getActiveProperties().get(propName);
        if (currentProperty == null) {
            currentProperty = new CmsProperty();
            currentProperty.setName(propName);
        } else {
            currentProperty = currentProperty.cloneAsProperty();
        }
        boolean emptyParam = true;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(propValue)) {
            emptyParam = false;
        }
        if (emptyParam) {
            if (this.getActiveProperties().containsKey(propName)) {
                this.checkLock(this.getParamResource());
                if (currentProperty.getStructureValue() != null) {
                    currentProperty.setStructureValue("");
                    currentProperty.setResourceValue(null);
                } else {
                    currentProperty.setResourceValue("");
                    currentProperty.setStructureValue(null);
                }
                this.getCms().writePropertyObject(this.getParamResource(), currentProperty);
            }
        } else if (!propValue.equals(oldValue)) {
            this.checkLock(this.getParamResource());
            if (currentProperty.getStructureValue() == null && currentProperty.getResourceValue() == null) {
                if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                    currentProperty.setStructureValue(propValue);
                    currentProperty.setResourceValue(null);
                } else {
                    currentProperty.setResourceValue(propValue);
                    currentProperty.setStructureValue(null);
                }
            } else if (currentProperty.getStructureValue() != null) {
                currentProperty.setStructureValue(propValue);
                currentProperty.setResourceValue(null);
            } else {
                currentProperty.setResourceValue(propValue);
                currentProperty.setStructureValue(null);
            }
            currentProperty.setAutoCreatePropertyDefinition(true);
            this.getCms().writePropertyObject(this.getParamResource(), currentProperty);
        }
    }
}

