/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsSecure
extends CmsDialog {
    public static final int ACTION_CHSECEXP = 100;
    public static final String DIALOG_TYPE = "secure";
    private static final Log LOG = CmsLog.getLog(CmsSecure.class);
    private String m_paramExport;
    private String m_paramExportname;
    private String m_paramIntern;
    private String m_paramSecure;

    public CmsSecure(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSecure(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionChangeSecureExport() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        String filename = this.getParamResource();
        try {
            this.checkLock(this.getParamResource());
            this.writeProperty("export", this.getParamExport());
            this.writeProperty("exportname", this.getParamExportname());
            this.writeProperty(DIALOG_TYPE, this.getParamSecure());
            CmsResource resource = this.getCms().readResource(filename, CmsResourceFilter.IGNORE_EXPIRATION);
            if (resource.isInternal() && !Boolean.valueOf(this.getParamIntern()).booleanValue()) {
                this.getCms().chflags(filename, resource.getFlags() & 0xFFFFFDFF);
            } else if (!resource.isInternal() && Boolean.valueOf(this.getParamIntern()).booleanValue()) {
                this.getCms().chflags(filename, resource.getFlags() | 0x200);
            }
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String buildRadio(String propName) throws CmsException {
        String propVal = this.readProperty(propName);
        StringBuffer result = new StringBuffer("<table border=\"0\"><tr>");
        result.append("<td><input type=\"radio\" value=\"true\" onClick=\"checkNoIntern()\" name=\"").append(propName).append("\" ").append(Boolean.valueOf(propVal) != false ? "checked=\"checked\"" : "").append("/></td><td id=\"tablelabel\">").append(this.key("GUI_LABEL_TRUE_0")).append("</td>");
        result.append("<td><input type=\"radio\" value=\"false\" onClick=\"checkNoIntern()\" name=\"").append(propName).append("\" ").append(Boolean.valueOf(propVal) != false ? "" : "checked=\"checked\"").append("/></td><td id=\"tablelabel\">").append(this.key("GUI_LABEL_FALSE_0")).append("</td>");
        result.append("<td><input type=\"radio\" value=\"\" onClick=\"checkNoIntern()\" name=\"").append(propName).append("\" ").append(CmsStringUtil.isEmpty(propVal) ? "checked=\"checked\"" : "").append("/></td><td id=\"tablelabel\">").append(this.getPropertyInheritanceInfo(propName)).append("</td></tr></table>");
        return result.toString();
    }

    public String getParamExport() {
        return this.m_paramExport;
    }

    public String getParamExportname() {
        return this.m_paramExportname;
    }

    public String getParamIntern() {
        return this.m_paramIntern;
    }

    public String getParamSecure() {
        return this.m_paramSecure;
    }

    public String getPropertyInheritanceInfo(String propName) throws CmsException {
        CmsProperty prop;
        String folderName = CmsResource.getParentFolder(this.getParamResource());
        String folderPropVal = null;
        while (CmsStringUtil.isNotEmpty(folderName) && !CmsStringUtil.isNotEmpty(folderPropVal = (prop = this.getCms().readPropertyObject(folderName, propName, false)).getValue())) {
            folderName = CmsResource.getParentFolder(folderName);
        }
        if (CmsStringUtil.isNotEmpty(folderPropVal)) {
            return this.key("GUI_SECURE_INHERIT_FROM_2", new Object[]{folderPropVal, folderName});
        }
        return this.key("GUI_SECURE_NOT_SET_0");
    }

    public String getResourceUrl() {
        return OpenCms.getLinkManager().getOnlineLink(this.getCms(), this.getParamResource());
    }

    public boolean exportUserHasReadPermission() {
        String vfsName = this.getParamResource();
        CmsObject cms = this.getCms();
        try {
            CmsObject exportCms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
            exportCms.getRequestContext().setSiteRoot(this.getCms().getRequestContext().getSiteRoot());
            return exportCms.hasPermissions(cms.readResource(vfsName, CmsResourceFilter.IGNORE_EXPIRATION), CmsPermissionSet.ACCESS_READ);
        }
        catch (CmsException cmsException) {
            return false;
        }
    }

    public String readInternProp() {
        boolean internProp;
        block2: {
            internProp = false;
            try {
                internProp = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION).isInternal();
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        return String.valueOf(internProp);
    }

    public String readProperty(String propertyName) {
        String propVal;
        block3: {
            propVal = null;
            try {
                propVal = this.getCms().readPropertyObject(this.getParamResource(), propertyName, false).getValue();
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block3;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        if (CmsStringUtil.isEmpty(propVal)) {
            propVal = "";
        }
        return propVal;
    }

    public boolean resourceIsFolder() throws CmsException {
        return this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION).isFolder();
    }

    public void setParamExport(String value) {
        this.m_paramExport = value;
    }

    public void setParamExportname(String value) {
        this.m_paramExportname = value;
    }

    public void setParamIntern(String value) {
        this.m_paramIntern = value;
    }

    public void setParamSecure(String value) {
        this.m_paramSecure = value;
    }

    public boolean showExportSettings() {
        return this.getSettings().getUserSettings().getDialogShowExportSettings();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_SECURE_EXPORT_RESOURCE_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        }
    }

    protected void writeProperty(String propertyName, String propertyValue) throws CmsException {
        if (CmsStringUtil.isEmpty(propertyValue)) {
            propertyValue = "";
        }
        CmsProperty newProp = new CmsProperty();
        newProp.setName(propertyName);
        CmsProperty oldProp = this.getCms().readPropertyObject(this.getParamResource(), propertyName, false);
        if (oldProp.isNullProperty()) {
            if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                newProp.setStructureValue(propertyValue);
            } else {
                newProp.setResourceValue(propertyValue);
            }
        } else if (oldProp.getStructureValue() != null) {
            newProp.setStructureValue(propertyValue);
            newProp.setResourceValue(oldProp.getResourceValue());
        } else {
            newProp.setResourceValue(propertyValue);
        }
        newProp.setAutoCreatePropertyDefinition(true);
        String oldStructureValue = oldProp.getStructureValue();
        String newStructureValue = newProp.getStructureValue();
        if (CmsStringUtil.isEmpty(oldStructureValue)) {
            oldStructureValue = "";
        }
        if (CmsStringUtil.isEmpty(newStructureValue)) {
            newStructureValue = "";
        }
        String oldResourceValue = oldProp.getResourceValue();
        String newResourceValue = newProp.getResourceValue();
        if (CmsStringUtil.isEmpty(oldResourceValue)) {
            oldResourceValue = "";
        }
        if (CmsStringUtil.isEmpty(newResourceValue)) {
            newResourceValue = "";
        }
        if (!oldResourceValue.equals(newResourceValue) || !oldStructureValue.equals(newStructureValue)) {
            this.getCms().writePropertyObject(this.getParamResource(), newProp);
        }
    }
}

