/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.A_CmsDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.CmsDirectEditPermissions;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;

public class CmsDirectEditJspIncludeProvider
extends A_CmsDirectEditProvider {
    public static final String DIRECT_EDIT_AREA_END = "end_directedit";
    public static final String DIRECT_EDIT_AREA_START = "start_directedit";
    public static final String DIRECT_EDIT_INCLUDE_FILE_URI_DEFAULT = "/system/workplace/editors/direct_edit.jsp";
    public static final String DIRECT_EDIT_INCLUDES = "directedit_includes";
    public static final String DIRECT_EDIT_PARAM_BUTTONSTYLE = "__directEditButtonStyle";
    public static final String DIRECT_EDIT_PARAM_ELEMENT = "__directEditElement";
    public static final String DIRECT_EDIT_PARAM_LOCALE = "__directEditLocale";
    public static final String DIRECT_EDIT_PARAM_NEWLINK = "__directEditNewLink";
    public static final String DIRECT_EDIT_PARAM_OPTIONS = "__directEditOptions";
    public static final String DIRECT_EDIT_PARAM_TARGET = "__directEditTarget";
    protected String m_editElement;
    protected String m_editTarget;
    protected String m_permissions;

    public static String includeDirectEditElement(PageContext context, String jspIncludeFile, String element, String editTarget, String editElement, String editOptions, String editPermissions, String createLink) throws JspException {
        if (editPermissions == null) {
            return null;
        }
        ServletRequest req = context.getRequest();
        ServletResponse res = context.getResponse();
        CmsFlexController controller = CmsFlexController.getController(req);
        element = element + "_" + editPermissions;
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        CmsJspTagInclude.addParameter(parameterMap, "__element", element, true);
        CmsJspTagInclude.addParameter(parameterMap, DIRECT_EDIT_PARAM_TARGET, editTarget, true);
        CmsJspTagInclude.addParameter(parameterMap, DIRECT_EDIT_PARAM_LOCALE, controller.getCmsObject().getRequestContext().getLocale().toString(), true);
        CmsUserSettings settings = new CmsUserSettings(controller.getCmsObject());
        CmsJspTagInclude.addParameter(parameterMap, DIRECT_EDIT_PARAM_BUTTONSTYLE, String.valueOf(settings.getDirectEditButtonStyle()), true);
        if (editElement != null) {
            CmsJspTagInclude.addParameter(parameterMap, DIRECT_EDIT_PARAM_ELEMENT, editElement, true);
        }
        if (editOptions != null) {
            CmsJspTagInclude.addParameter(parameterMap, DIRECT_EDIT_PARAM_OPTIONS, editOptions, true);
        }
        if (createLink != null) {
            CmsJspTagInclude.addParameter(parameterMap, DIRECT_EDIT_PARAM_NEWLINK, CmsEncoder.encode(createLink), true);
        }
        Map<String, String[]> oldParameterMap = controller.getCurrentRequest().getParameterMap();
        try {
            try {
                controller.getCurrentRequest().addParameterMap(parameterMap);
                context.getOut().print('\u0000');
                controller.getCurrentResponse().addToIncludeList(jspIncludeFile, parameterMap, CmsRequestUtil.getAtrributeMap(req));
                controller.getCurrentRequest().getRequestDispatcher(jspIncludeFile).include(req, res);
            }
            catch (ServletException e) {
                Throwable t = e.getRootCause() != null ? e.getRootCause() : e;
                t = controller.setThrowable(t, jspIncludeFile);
                throw new JspException(t);
            }
            catch (IOException e) {
                Throwable t = controller.setThrowable(e, jspIncludeFile);
                throw new JspException(t);
            }
            Object var17_14 = null;
            if (oldParameterMap != null) {
                controller.getCurrentRequest().setParameterMap(oldParameterMap);
            }
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            if (oldParameterMap != null) {
                controller.getCurrentRequest().setParameterMap(oldParameterMap);
            }
            throw throwable;
        }
        return editPermissions;
    }

    public void init(CmsObject cms, CmsDirectEditMode mode, String fileName) {
        this.m_cms = cms;
        this.m_fileName = fileName;
        if (CmsStringUtil.isEmpty(this.m_fileName)) {
            this.m_fileName = DIRECT_EDIT_INCLUDE_FILE_URI_DEFAULT;
        }
        this.m_mode = mode != null ? mode : CmsDirectEditMode.AUTO;
    }

    public void insertDirectEditEnd(PageContext context) throws JspException {
        if (this.m_editTarget != null) {
            CmsDirectEditJspIncludeProvider.includeDirectEditElement(context, this.m_fileName, DIRECT_EDIT_AREA_END, this.m_editTarget, this.m_editElement, null, this.m_permissions, null);
            this.m_editTarget = null;
            this.m_permissions = null;
            this.m_editElement = null;
        }
    }

    public void insertDirectEditIncludes(PageContext context, CmsDirectEditParams params) throws JspException {
        try {
            CmsJspTagInclude.includeTagAction(context, this.m_fileName, DIRECT_EDIT_INCLUDES, false, null, null, context.getRequest(), context.getResponse());
        }
        catch (Throwable t) {
            throw new JspException(t);
        }
    }

    public boolean insertDirectEditStart(PageContext context, CmsDirectEditParams params) throws JspException {
        String result = null;
        CmsDirectEditPermissions permissions = this.getResourceInfo(params.getResourceName()).getPermissions();
        if (permissions.getPermission() > 0) {
            this.m_permissions = permissions.toString();
            this.m_editTarget = params.getResourceName();
            this.m_editElement = params.getElement();
            result = CmsDirectEditJspIncludeProvider.includeDirectEditElement(context, this.m_fileName, DIRECT_EDIT_AREA_START, this.m_editTarget, this.m_editElement, params.getButtonSelection().toString(), this.m_permissions, params.getLinkForNew());
        } else {
            this.m_editTarget = null;
            this.m_permissions = null;
            this.m_editElement = null;
        }
        return result != null;
    }

    public boolean isManual(CmsDirectEditMode mode) {
        return false;
    }

    public I_CmsDirectEditProvider newInstance() {
        CmsDirectEditJspIncludeProvider result = new CmsDirectEditJspIncludeProvider();
        result.m_configurationParameters = this.m_configurationParameters;
        return result;
    }
}

