/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessages;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.A_CmsModeIntEnumeration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsResourceUtil {
    public static final int LAYOUTSTYLE_AFTEREXPIRE = 2;
    public static final int LAYOUTSTYLE_BEFORERELEASE = 1;
    public static final int LAYOUTSTYLE_INRANGE = 0;
    public static final CmsResourceUtilSiteMode SITE_MODE_CURRENT = new CmsResourceUtilSiteMode();
    public static final CmsResourceUtilSiteMode SITE_MODE_MATCHING = new CmsResourceUtilSiteMode();
    public static final CmsResourceUtilSiteMode SITE_MODE_ROOT = new CmsResourceUtilSiteMode();
    public static final CmsResourceProjectState STATE_LOCKED_FOR_PUBLISHING = CmsResourceProjectState.LOCKED_FOR_PUBLISHING;
    public static final CmsResourceProjectState STATE_MODIFIED_IN_CURRENT_PROJECT = CmsResourceProjectState.MODIFIED_IN_CURRENT_PROJECT;
    public static final CmsResourceProjectState STATE_MODIFIED_IN_OTHER_PROJECT = CmsResourceProjectState.MODIFIED_IN_OTHER_PROJECT;
    private static final Log LOG = CmsLog.getLog(CmsResourceUtil.class);
    private static final String SIZE_DIR = "-";
    private static final CmsResourceProjectState STATE_CLEAN = CmsResourceProjectState.CLEAN;
    private int m_abbrevLength;
    private CmsObject m_cms;
    private CmsLock m_lock;
    private CmsMessages m_messages;
    private List<String> m_projectResources;
    private CmsProject m_referenceProject;
    private String m_relativeTo;
    private CmsRequestContext m_request;
    private CmsResource m_resource;
    private I_CmsResourceType m_resourceType;
    private CmsResourceUtilSiteMode m_siteMode = SITE_MODE_CURRENT;

    public CmsResourceUtil(CmsObject cms) {
        this.setCms(cms);
    }

    public CmsResourceUtil(CmsObject cms, CmsResource resource) {
        this.setCms(cms);
        this.setResource(resource);
    }

    public CmsResourceUtil(CmsResource resource) {
        this.setResource(resource);
    }

    public int getAbbrevLength() {
        return this.m_abbrevLength;
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public String getDateExpired() {
        long release = this.m_resource.getDateExpired();
        if (release != Long.MAX_VALUE) {
            return this.getMessages().getDateTime(release);
        }
        return SIZE_DIR;
    }

    public String getDateReleased() {
        long release = this.m_resource.getDateReleased();
        if (release != 0L) {
            return this.getMessages().getDateTime(release);
        }
        return SIZE_DIR;
    }

    public String getFullPath() {
        String site;
        String path = this.m_resource.getRootPath();
        if (this.m_siteMode != SITE_MODE_ROOT && this.m_cms != null && path.startsWith(site = this.getSite())) {
            path = path.substring(site.length());
        }
        return path;
    }

    public String getIconPathExplorer() {
        if (this.m_resource.getSiblingCount() > 1) {
            if (this.m_resource.isLabeled()) {
                return "explorer/link_labeled.gif";
            }
            return "explorer/link.gif";
        }
        return this.getIconPathResourceType();
    }

    public String getIconPathLock() {
        CmsLock lock = this.getLock();
        String iconPath = null;
        if (!lock.isUnlocked() && this.m_request != null && this.isInsideProject()) {
            iconPath = this.getLock().isOwnedBy(this.m_request.getCurrentUser()) && this.getLockedInProjectId().equals(this.getReferenceProject().getUuid()) ? (lock.isShared() ? "shared" : "user") : "other";
        }
        iconPath = iconPath == null ? "project_none" : "lock_" + iconPath;
        return "explorer/" + iconPath + ".gif";
    }

    public String getIconPathProjectState() {
        String iconPath = this.getProjectState() == STATE_MODIFIED_IN_CURRENT_PROJECT ? "this.png" : (this.getProjectState() == STATE_MODIFIED_IN_OTHER_PROJECT ? "other.png" : (this.getProjectState() == STATE_LOCKED_FOR_PUBLISHING ? "publish.png" : "none.gif"));
        return "explorer/project_" + iconPath;
    }

    public String getIconPathResourceType() {
        if (!this.isEditable()) {
            return "filetypes/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypePlain.getStaticTypeName()).getIcon();
        }
        return "filetypes/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.getResourceTypeName()).getIcon();
    }

    public int getLinkType() {
        if (this.m_resource.getSiblingCount() > 1) {
            if (this.m_resource.isLabeled()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public CmsLock getLock() {
        if (this.m_lock == null) {
            try {
                this.m_lock = this.getCms().getLock(this.m_resource);
            }
            catch (Throwable e) {
                this.m_lock = CmsLock.getNullLock();
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
        return this.m_lock;
    }

    public String getLockedByName() {
        String lockedBy = "";
        if (!this.getLock().isNullLock()) {
            lockedBy = this.getLock().getUserId().toString();
            try {
                lockedBy = this.getCurrentOuRelativeName(CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), this.getLock().getUserId()).getName());
            }
            catch (Throwable e) {
                lockedBy = e.getMessage();
            }
        }
        return lockedBy;
    }

    public CmsUUID getLockedInProjectId() {
        CmsUUID lockedInProject = null;
        if (this.getLock().isNullLock() && !this.getResource().getState().isUnchanged()) {
            lockedInProject = this.getResource().getProjectLastModified();
        } else if (!this.getResource().getState().isUnchanged()) {
            lockedInProject = this.getProjectId();
        } else if (!this.getLock().isNullLock()) {
            lockedInProject = this.getLock().getProjectId();
        }
        return lockedInProject;
    }

    public String getLockedInProjectName() {
        try {
            CmsUUID pId = this.getLockedInProjectId();
            if (pId == null || pId.isNullUUID()) {
                return "";
            }
            try {
                return this.getCurrentOuRelativeName(this.getCms().readProject(pId).getName());
            }
            catch (CmsDbEntryNotFoundException e) {
                return this.getCurrentOuRelativeName(this.getCms().readHistoryProject(pId).getName());
            }
        }
        catch (Throwable e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
            return "";
        }
    }

    public int getLockState() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getLockedByName())) {
            return 0;
        }
        if (!this.getLockedByName().equals(this.getCurrentOuRelativeName(this.m_request.getCurrentUser().getName())) || !this.getLockedInProjectId().equals(this.m_request.getCurrentProject().getUuid())) {
            return 1;
        }
        if (this.getLock().getType().isShared()) {
            return 2;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNavText() {
        String navText = "";
        try {
            navText = this.getCms().readPropertyObject(this.getCms().getSitePath(this.m_resource), "NavText", false).getValue();
        }
        catch (Throwable e) {
            String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
            try {
                this.getCms().getRequestContext().setSiteRoot("");
                navText = this.getCms().readPropertyObject(this.m_resource.getRootPath(), "NavText", false).getValue();
            }
            catch (Exception e1) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e);
                }
            }
            finally {
                this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        if (navText == null) {
            navText = "";
        }
        return navText;
    }

    public String getNoEditReason(Locale locale) throws CmsException {
        return this.getNoEditReason(locale, false);
    }

    public String getNoEditReason(Locale locale, boolean ignoreExpiration) throws CmsException {
        String reason = "";
        if (this.m_resource instanceof I_CmsHistoryResource) {
            reason = Messages.get().getBundle(locale).key("GUI_NO_EDIT_REASON_HISTORY_0");
        } else if (!this.m_cms.hasPermissions(this.m_resource, CmsPermissionSet.ACCESS_WRITE, false, ignoreExpiration ? CmsResourceFilter.IGNORE_EXPIRATION : CmsResourceFilter.DEFAULT) || !this.isEditable()) {
            reason = Messages.get().getBundle(locale).key("GUI_NO_EDIT_REASON_PERMISSION_0");
        } else if (!this.getLock().isLockableBy(this.m_cms.getRequestContext().getCurrentUser())) {
            reason = Messages.get().getBundle(locale).key("GUI_NO_EDIT_REASON_LOCK_1", this.getLockedByName());
        }
        return reason;
    }

    public String getPath() {
        String path = this.getFullPath();
        if (this.m_relativeTo != null) {
            path = this.getResource().getRootPath();
            if (path.startsWith(this.m_relativeTo)) {
                if ((path = path.substring(this.m_relativeTo.length())).length() == 0) {
                    path = ".";
                }
            } else {
                String site = this.getSite();
                if (path.startsWith(site + "/") || path.equals(site)) {
                    path = path.substring(site.length());
                }
            }
        }
        if (this.m_abbrevLength > 0) {
            boolean absolute = path.startsWith("/");
            path = CmsStringUtil.formatResourceName(path, this.m_abbrevLength);
            if (!absolute && path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    public CmsPermissionSet getPermissionSet() {
        CmsPermissionSetCustom pset = new CmsPermissionSetCustom();
        CmsResource resource = this.getResource();
        try {
            if (this.getCms().hasPermissions(resource, CmsPermissionSet.ACCESS_CONTROL, false, CmsResourceFilter.ALL)) {
                pset.grantPermissions(8);
            } else {
                pset.denyPermissions(8);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        try {
            if (this.getCms().hasPermissions(resource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL)) {
                pset.grantPermissions(16);
            } else {
                pset.denyPermissions(16);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        try {
            if (this.getCms().hasPermissions(resource, CmsPermissionSet.ACCESS_READ, false, CmsResourceFilter.ALL)) {
                pset.grantPermissions(1);
            } else {
                pset.denyPermissions(1);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        try {
            if (this.getCms().hasPermissions(resource, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ALL)) {
                pset.grantPermissions(4);
            } else {
                pset.denyPermissions(4);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        try {
            if (this.getCms().hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL)) {
                pset.grantPermissions(2);
            } else {
                pset.denyPermissions(2);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        return pset;
    }

    public String getPermissionString() {
        return this.getPermissionSet().getPermissionString();
    }

    public CmsUUID getProjectId() {
        CmsUUID projectId = this.m_resource.getProjectLastModified();
        if (!this.getLock().isUnlocked() && !this.getLock().isInherited()) {
            projectId = this.getLock().getProjectId();
        }
        return projectId;
    }

    public CmsResourceProjectState getProjectState() {
        if (this.getResource().getState().isUnchanged()) {
            return STATE_CLEAN;
        }
        if (this.getLock().getSystemLock().isPublish()) {
            return STATE_LOCKED_FOR_PUBLISHING;
        }
        if (this.getResource().getProjectLastModified().equals(this.getReferenceProject().getUuid())) {
            return STATE_MODIFIED_IN_CURRENT_PROJECT;
        }
        return STATE_MODIFIED_IN_OTHER_PROJECT;
    }

    public CmsProject getReferenceProject() {
        if (this.m_referenceProject == null && this.m_request != null) {
            this.m_referenceProject = this.m_request.getCurrentProject();
        }
        return this.m_referenceProject;
    }

    public String getRelativeTo() {
        return this.m_relativeTo;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public I_CmsResourceType getResourceType() {
        if (this.m_resourceType == null) {
            this.m_resourceType = OpenCms.getResourceManager().getResourceType(this.m_resource);
        }
        return this.m_resourceType;
    }

    public int getResourceTypeId() {
        return this.getResourceType().getTypeId();
    }

    public String getResourceTypeName() {
        return this.getResourceType().getTypeName();
    }

    public String getSite() {
        String site = null;
        if (this.m_siteMode == SITE_MODE_MATCHING || this.m_cms == null) {
            site = OpenCms.getSiteManager().getSiteRoot(this.m_resource.getRootPath());
        } else if (this.m_siteMode == SITE_MODE_CURRENT) {
            site = this.m_cms.getRequestContext().getSiteRoot();
        } else if (this.m_siteMode == SITE_MODE_ROOT) {
            site = "";
        }
        return site == null ? "" : site;
    }

    public CmsResourceUtilSiteMode getSiteMode() {
        return this.m_siteMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSiteTitle() {
        String title = this.getSite();
        String rootSite = this.getCms().getRequestContext().getSiteRoot();
        try {
            this.getCms().getRequestContext().setSiteRoot("");
            title = this.getCms().readPropertyObject(title, "Title", false).getValue(title);
        }
        catch (CmsException cmsException) {
        }
        finally {
            this.getCms().getRequestContext().setSiteRoot(rootSite);
        }
        return title;
    }

    public String getSizeString() {
        return this.m_resource.getLength() == -1 ? SIZE_DIR : "" + this.m_resource.getLength();
    }

    public char getStateAbbreviation() {
        return this.getResource().getState().getAbbreviation();
    }

    public String getStateName() {
        CmsResourceState state = this.m_resource.getState();
        String name = this.m_request == null ? Messages.get().getBundle().key(Messages.getStateKey(state)) : Messages.get().getBundle(this.m_request.getLocale()).key(Messages.getStateKey(state));
        return name;
    }

    public String getStyleClassName() {
        if (this.isInsideProject() && this.isEditable()) {
            if (this.m_resource.getState().isChanged()) {
                return "fc";
            }
            if (this.m_resource.getState().isNew()) {
                return "fn";
            }
            if (this.m_resource.getState().isDeleted()) {
                return "fd";
            }
            return "nf";
        }
        return "fp";
    }

    public String getStyleSiblings() {
        StringBuffer style = new StringBuffer(128);
        if (this.m_resource.getSiblingCount() > 1) {
            style.append("background-image:url(");
            style.append(CmsWorkplace.getSkinUri());
            style.append(this.getIconPathResourceType());
            style.append("); background-position: 0px 0px; background-repeat: no-repeat; ");
        }
        return style.toString();
    }

    public String getSystemLockInfo(boolean forExplorer) {
        if (this.getLock().getSystemLock().isPublish()) {
            if (!forExplorer) {
                return this.getMessages().key("GUI_PUBLISH_TOOLTIP_0");
            }
            return "p";
        }
        return "";
    }

    public String getTimeWindowLayoutStyle() {
        return this.getTimeWindowLayoutType() == 0 ? "" : "font-style:italic;";
    }

    public int getTimeWindowLayoutType() {
        int layoutstyle = 0;
        if (!this.m_resource.isReleased(this.getCms().getRequestContext().getRequestTime())) {
            layoutstyle = 1;
        } else if (this.m_resource.isExpired(this.getCms().getRequestContext().getRequestTime())) {
            layoutstyle = 2;
        }
        return layoutstyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle() {
        String title = "";
        try {
            title = this.getCms().readPropertyObject(this.getCms().getSitePath(this.m_resource), "Title", false).getValue();
        }
        catch (Throwable e) {
            String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
            try {
                this.getCms().getRequestContext().setSiteRoot("");
                title = this.getCms().readPropertyObject(this.m_resource.getRootPath(), "Title", false).getValue();
            }
            catch (Exception e1) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e);
                }
            }
            finally {
                this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        if (title == null) {
            title = "";
        }
        return title;
    }

    public String getUserCreated() {
        String user = this.m_resource.getUserCreated().toString();
        try {
            user = this.getCurrentOuRelativeName(CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), this.m_resource.getUserCreated()).getName());
        }
        catch (Throwable e) {
            LOG.info((Object)e.getLocalizedMessage());
        }
        return user;
    }

    public String getUserLastModified() {
        String user = this.m_resource.getUserLastModified().toString();
        try {
            user = this.getCurrentOuRelativeName(CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), this.m_resource.getUserLastModified()).getName());
        }
        catch (Throwable e) {
            LOG.info((Object)e.getLocalizedMessage());
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEditable() {
        if (this.m_request == null) {
            return false;
        }
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.getResourceTypeName());
        if (settings != null) {
            String rightSite = OpenCms.getSiteManager().getSiteRoot(this.getResource().getRootPath());
            if (rightSite == null) {
                rightSite = "";
            }
            String currentSite = this.getCms().getRequestContext().getSiteRoot();
            try {
                this.getCms().getRequestContext().setSiteRoot(rightSite);
                boolean bl = settings.isEditable(this.getCms(), this.getResource());
                return bl;
            }
            finally {
                this.getCms().getRequestContext().setSiteRoot(currentSite);
            }
        }
        return false;
    }

    public boolean isInsideProject() {
        return CmsProject.isInsideProject(this.getProjectResources(), this.getResource());
    }

    public boolean isReleasedAndNotExpired() {
        long requestTime = this.m_request == null ? System.currentTimeMillis() : this.m_request.getRequestTime();
        return this.m_resource.isReleasedAndNotExpired(requestTime);
    }

    public void setAbbrevLength(int abbrevLength) {
        this.m_abbrevLength = abbrevLength;
    }

    public void setCms(CmsObject cms) {
        this.m_cms = cms;
        this.m_request = cms.getRequestContext();
        this.m_referenceProject = null;
        this.m_projectResources = null;
        this.m_messages = null;
    }

    public void setReferenceProject(CmsProject project) {
        this.m_referenceProject = project;
        this.m_projectResources = null;
    }

    public void setRelativeTo(String relativeTo) {
        this.m_relativeTo = relativeTo;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_relativeTo)) {
            this.m_relativeTo = null;
        } else {
            if (!this.m_relativeTo.startsWith("/")) {
                this.m_relativeTo = "/" + this.m_relativeTo;
            }
            if (!this.m_relativeTo.endsWith("/")) {
                this.m_relativeTo = this.m_relativeTo + "/";
            }
        }
    }

    public void setResource(CmsResource resource) {
        this.m_resource = resource;
        this.m_lock = null;
        this.m_resourceType = null;
    }

    public void setSiteMode(CmsResourceUtilSiteMode siteMode) {
        this.m_siteMode = siteMode;
    }

    private String getCurrentOuRelativeName(String name) {
        if (this.m_request == null) {
            return "/" + name;
        }
        String ou = CmsOrganizationalUnit.getParentFqn(name);
        if (ou.equals(this.m_request.getCurrentUser().getOuFqn())) {
            return CmsOrganizationalUnit.getSimpleName(name);
        }
        return "/" + name;
    }

    private CmsMessages getMessages() {
        if (this.m_messages == null) {
            this.m_messages = this.m_request != null ? Messages.get().getBundle(this.m_request.getLocale()) : Messages.get().getBundle();
        }
        return this.m_messages;
    }

    private List<String> getProjectResources() {
        if (this.m_projectResources == null) {
            try {
                this.m_projectResources = this.getCms().readProjectResources(this.getReferenceProject());
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
                this.m_projectResources = new ArrayList<String>();
            }
        }
        return this.m_projectResources;
    }

    private static class CmsResourceUtilSiteMode {
        protected CmsResourceUtilSiteMode() {
        }
    }

    public static class CmsResourceProjectState
    extends A_CmsModeIntEnumeration {
        protected static final CmsResourceProjectState CLEAN = new CmsResourceProjectState(0);
        protected static final CmsResourceProjectState LOCKED_FOR_PUBLISHING = new CmsResourceProjectState(5);
        protected static final CmsResourceProjectState MODIFIED_IN_CURRENT_PROJECT = new CmsResourceProjectState(1);
        protected static final CmsResourceProjectState MODIFIED_IN_OTHER_PROJECT = new CmsResourceProjectState(2);
        private static final long serialVersionUID = 4580450220255428716L;

        protected CmsResourceProjectState(int mode) {
            super(mode);
        }

        public boolean isLockedForPublishing() {
            return this == LOCKED_FOR_PUBLISHING;
        }

        public boolean isModifiedInCurrentProject() {
            return this == MODIFIED_IN_CURRENT_PROJECT;
        }

        public boolean isModifiedInOtherProject() {
            return this == MODIFIED_IN_OTHER_PROJECT;
        }

        public boolean isUnlocked() {
            return this == CLEAN;
        }
    }
}

