/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.I_CmsMenuItemRule;
import org.opencms.workplace.explorer.menu.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsMenuRule {
    private static final Log LOG = CmsLog.getLog(CmsMenuRule.class);
    private boolean m_frozen;
    private List<I_CmsMenuItemRule> m_menuItemRules = new ArrayList<I_CmsMenuItemRule>(5);
    private String m_name;

    public void addMenuItemRule(I_CmsMenuItemRule menuItemRule) {
        block2: {
            try {
                this.m_menuItemRules.add(menuItemRule);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)Messages.get().getBundle().key("ERR_INITIALIZE_MENUITEMRULE_1", menuItemRule.getClass().getName()));
            }
        }
    }

    public void addMenuItemRuleName(String className) {
        block2: {
            try {
                this.m_menuItemRules.add((I_CmsMenuItemRule)Class.forName(className).newInstance());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)Messages.get().getBundle().key("ERR_INITIALIZE_MENUITEMRULE_1", className));
            }
        }
    }

    public void freeze() {
        if (!this.m_frozen) {
            this.m_frozen = true;
            this.m_menuItemRules = Collections.unmodifiableList(this.m_menuItemRules);
        }
    }

    public I_CmsMenuItemRule getMatchingRule(CmsObject cms, CmsResourceUtil[] resourceUtil) {
        for (I_CmsMenuItemRule rule : this.getMenuItemRules()) {
            if (!rule.matches(cms, resourceUtil)) continue;
            return rule;
        }
        return null;
    }

    public List<I_CmsMenuItemRule> getMenuItemRules() {
        return this.m_menuItemRules;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isFrozen() {
        return this.m_frozen;
    }

    public void setMenuItemRules(List<I_CmsMenuItemRule> menuItemRules) {
        this.m_menuItemRules = menuItemRules;
    }

    public void setName(String name) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_MENURULE_FROZEN_0"));
        }
        this.m_name = name;
    }
}

