/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Locale;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public class CmsListDefaultAction
extends CmsListDirectAction {
    private String m_columnForLink;
    private I_CmsListFormatter m_columnFormatter;

    public CmsListDefaultAction(String id) {
        super(id);
    }

    public String getColumnForLink() {
        return this.m_columnForLink;
    }

    public I_CmsListFormatter getColumnFormatter() {
        return this.m_columnFormatter;
    }

    public void setColumnForLink(CmsListColumnDefinition columnForLink) {
        this.m_columnForLink = columnForLink.getId();
        this.m_columnFormatter = columnForLink.getFormatter();
    }

    protected CmsHtmlIconButtonStyleEnum resolveButtonStyle() {
        if (this.getColumnForLink() == null) {
            return super.resolveButtonStyle();
        }
        return CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT;
    }

    protected String resolveName(Locale locale) {
        Object content;
        if (this.getColumnForLink() == null) {
            return super.resolveName(locale);
        }
        Object object = content = this.getItem().get(this.getColumnForLink()) != null ? this.getItem().get(this.getColumnForLink()) : this.getName().key(locale);
        if (this.getColumnFormatter() != null) {
            return this.getColumnFormatter().format(content, locale);
        }
        return content.toString();
    }
}

