/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Iterator;
import java.util.List;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public class CmsListRadioMultiAction
extends CmsListMultiAction {
    private final List m_relatedActionIds;

    public CmsListRadioMultiAction(String id, List relatedActionIds) {
        super(id);
        this.m_relatedActionIds = relatedActionIds;
    }

    public String buttonHtml(CmsWorkplace wp) {
        if (!this.isVisible()) {
            return "";
        }
        if (this.isEnabled()) {
            String onClic = "listRSelMAction('" + this.getListId() + "','" + this.getId() + "', '" + CmsStringUtil.escapeJavaScript(wp.resolveMacros(this.getConfirmationMessage().key(wp.getLocale()))) + "', " + "noSelMatchHelp" + this.getId() + ", '" + this.getRelatedActionIds() + "');";
            return A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, this.getId(), this.getName().key(wp.getLocale()), this.getHelpText().key(wp.getLocale()), this.isEnabled(), this.getIconPath(), null, onClic);
        }
        return "";
    }

    public int getSelections() {
        return this.m_relatedActionIds.size();
    }

    private String getRelatedActionIds() {
        StringBuffer ret = new StringBuffer(32);
        Iterator it = this.m_relatedActionIds.iterator();
        while (it.hasNext()) {
            ret.append(it.next().toString().trim());
            if (!it.hasNext()) continue;
            ret.append(',');
        }
        return ret.toString();
    }
}

