/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.threads.Messages;

public class CmsExportThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsExportThread.class);
    private I_CmsImportExportHandler m_handler;

    public CmsExportThread(CmsObject cms, I_CmsImportExportHandler handler, boolean old) {
        super(cms, "OpenCms: " + handler.getDescription());
        this.m_handler = handler;
        if (old) {
            this.initOldHtmlReport(cms.getRequestContext().getLocale());
        } else {
            this.initHtmlReport(cms.getRequestContext().getLocale());
        }
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        try {
            OpenCms.getImportExportManager().exportData(this.getCms(), this.m_handler, this.getReport());
        }
        catch (Throwable e) {
            this.getReport().println(e);
            LOG.error((Object)Messages.get().getBundle().key("ERR_DB_EXPORT_0"), e);
        }
    }
}

