/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModuleManager;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;
import org.opencms.workplace.threads.Messages;

public class CmsModuleDeleteThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsModuleDeleteThread.class);
    private List m_moduleNames;
    private boolean m_replaceMode;

    public CmsModuleDeleteThread(CmsObject cms, List moduleNames, boolean replaceMode) {
        super(cms, Messages.get().getBundle().key("GUI_DELETE_MODULE_THREAD_NAME_1", moduleNames));
        this.m_moduleNames = moduleNames;
        this.m_replaceMode = replaceMode;
        this.initHtmlReport(cms.getRequestContext().getLocale());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_THREAD_CONSTRUCTED_0"));
        }
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        I_CmsReport report = this.getReport();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_THREAD_STARTED_0"));
            }
            if (!this.m_replaceMode) {
                OpenCms.getModuleManager().checkModuleSelectionList(this.m_moduleNames, null, true);
            }
            this.m_moduleNames = CmsModuleManager.topologicalSort(this.m_moduleNames, null);
            Collections.reverse(this.m_moduleNames);
            for (String moduleName : this.m_moduleNames) {
                moduleName = moduleName.replace('\\', '/');
                OpenCms.getModuleManager().deleteModule(this.getCms(), moduleName, this.m_replaceMode, report);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_THREAD_FINISHED_0"));
            }
        }
        catch (Throwable e) {
            report.println(e);
            LOG.error((Object)Messages.get().getBundle().key("LOG_MODULE_DELETE_FAILED_1", this.m_moduleNames), e);
        }
    }
}

