/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.threads.Messages;

public class CmsRelationsValidatorThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsRelationsValidatorThread.class);
    private CmsPublishList m_publishList;
    private boolean m_savePublishList;
    private CmsWorkplaceSettings m_settings;

    public CmsRelationsValidatorThread(CmsObject cms) {
        super(cms, Messages.get().getBundle().key("GUI_HTML_LINK_VALIDATOR_THREAD_NAME_1", new Object[]{cms.getRequestContext().getCurrentProject().getName()}));
        this.m_publishList = null;
        this.m_savePublishList = false;
        this.m_settings = null;
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    public CmsRelationsValidatorThread(CmsObject cms, CmsPublishList publishList, CmsWorkplaceSettings settings) {
        super(cms, Messages.get().getBundle().key("GUI_HTML_LINK_VALIDATOR_THREAD_NAME_1", new Object[]{cms.getRequestContext().getCurrentProject().getName()}));
        this.m_publishList = publishList;
        if (this.m_publishList == null) {
            try {
                this.m_publishList = OpenCms.getPublishManager().getPublishList(cms);
            }
            catch (CmsException e) {
                // empty catch block
            }
        }
        this.m_savePublishList = true;
        this.m_settings = settings;
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        try {
            OpenCms.getPublishManager().validateRelations(this.getCms(), this.m_publishList, this.getReport());
            if (this.m_savePublishList && this.m_settings != null) {
                this.m_settings.setPublishList(this.m_publishList);
            }
        }
        catch (Throwable e) {
            if (this.m_savePublishList && this.m_settings != null) {
                this.m_settings.setPublishList(null);
            }
            this.getReport().println(e);
            LOG.error((Object)Messages.get().getBundle().key("ERR_LINK_VALIDATION_0"), e);
        }
    }
}

