/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.Messages;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsXmlDocument
implements I_CmsXmlDocument {
    protected String m_conversion;
    protected Document m_document;
    protected Map<String, Set<Locale>> m_elementLocales;
    protected Map<Locale, Set<String>> m_elementNames;
    protected String m_encoding;
    protected CmsFile m_file;
    protected Set<Locale> m_locales;
    private Map<String, I_CmsXmlContentValue> m_bookmarks = new HashMap<String, I_CmsXmlContentValue>();

    protected A_CmsXmlDocument() {
        this.m_locales = new HashSet<Locale>();
    }

    protected static final String getBookmarkName(String name, Locale locale) {
        StringBuffer result = new StringBuffer(64);
        result.append('/');
        result.append(locale.toString());
        result.append('/');
        result.append(name);
        return result.toString();
    }

    @Override
    public void copyLocale(List<Locale> possibleSources, Locale destination) throws CmsXmlException {
        if (this.hasLocale(destination)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_ALREADY_EXISTS_1", destination));
        }
        Iterator<Locale> i = possibleSources.iterator();
        Locale source = null;
        while (i.hasNext() && source == null) {
            Locale candidate = i.next();
            if (!this.hasLocale(candidate)) continue;
            source = candidate;
        }
        if (source == null) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", CmsLocaleManager.getLocaleNames(possibleSources)));
        }
        this.copyLocale(source, destination);
    }

    @Override
    public void copyLocale(Locale source, Locale destination) throws CmsXmlException {
        if (!this.hasLocale(source)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", source));
        }
        if (this.hasLocale(destination)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_ALREADY_EXISTS_1", destination));
        }
        Element sourceElement = null;
        Element rootNode = this.m_document.getRootElement();
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(rootNode);
        String localeStr = source.toString();
        while (i.hasNext()) {
            Element element = i.next();
            String language = element.attributeValue("language", null);
            if (language == null || !localeStr.equals(language)) continue;
            sourceElement = element.createCopy();
            break;
        }
        if (sourceElement == null) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", source));
        }
        sourceElement.addAttribute("language", destination.toString());
        rootNode.add(sourceElement);
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public CmsFile correctXmlStructure(CmsObject cms) throws CmsXmlException {
        String translatedSchema;
        String schemaLocation;
        Attribute schema = this.m_document.getRootElement().attribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION);
        if (schema != null && !(schemaLocation = schema.getValue()).equals(translatedSchema = OpenCms.getResourceManager().getXsdTranslator().translateResource(schemaLocation))) {
            schema.setValue(translatedSchema);
        }
        for (Locale locale : this.m_locales) {
            List<String> names = this.getNames(locale);
            ArrayList<I_CmsXmlContentValue> validValues = new ArrayList<I_CmsXmlContentValue>();
            for (String name : names) {
                I_CmsXmlContentValue value = this.getValue(name, locale);
                if (value.isSimpleType()) {
                    String content = value.getStringValue(cms);
                    value.setStringValue(cms, content);
                }
                validValues.add(value);
            }
            if (!this.isAutoCorrectionEnabled()) continue;
            ArrayList<Element> roots = new ArrayList<Element>();
            ArrayList<CmsXmlContentDefinition> rootCds = new ArrayList<CmsXmlContentDefinition>();
            ArrayList<Element> validElements = new ArrayList<Element>();
            for (I_CmsXmlContentValue value : validValues) {
                Element root;
                Element element = value.getElement();
                validElements.add(element);
                if (!element.supportsParent() || (root = element.getParent()) == null || roots.contains(root)) continue;
                CmsXmlContentDefinition rcd = value.getContentDefinition();
                if (rcd != null) {
                    roots.add(root);
                    rootCds.add(rcd);
                    continue;
                }
                throw new CmsXmlException(Messages.get().container("ERR_CORRECT_NO_CONTENT_DEF_3", value.getName(), value.getTypeName(), value.getPath()));
            }
            for (int le = 0; le < roots.size(); ++le) {
                Element root = (Element)roots.get(le);
                CmsXmlContentDefinition cd = (CmsXmlContentDefinition)rootCds.get(le);
                ArrayList<List> nodeLists = new ArrayList<List>();
                for (I_CmsXmlSchemaType type : cd.getTypeSequence()) {
                    int maxOccures;
                    List elements = CmsXmlGenericWrapper.elements(root, type.getName());
                    int n = maxOccures = cd.getChoiceMaxOccurs() > 0 ? cd.getChoiceMaxOccurs() : type.getMaxOccurs();
                    if (elements.size() > maxOccures) {
                        for (int lo = elements.size() - 1; lo >= type.getMaxOccurs(); --lo) {
                            elements.remove(lo);
                        }
                    }
                    nodeLists.add(elements);
                }
                List<Element> nodeList = CmsXmlGenericWrapper.elements(root);
                nodeList.clear();
                for (List elements : nodeLists) {
                    nodeList.addAll(elements);
                }
                cd.addDefaultXml(cms, this, root, locale);
            }
        }
        if (this.m_file != null) {
            this.m_file.setContents(this.marshal());
        }
        return this.m_file;
    }

    @Override
    public Locale getBestMatchingLocale(Locale locale) {
        Locale check;
        if (this.hasLocale(locale)) {
            return locale;
        }
        if (locale.getVariant().length() > 0 && this.hasLocale(check = new Locale(locale.getLanguage(), locale.getCountry(), ""))) {
            return check;
        }
        if (locale.getCountry().length() > 0 && this.hasLocale(check = new Locale(locale.getLanguage(), "", ""))) {
            return check;
        }
        return null;
    }

    @Override
    public String getConversion() {
        return this.m_conversion;
    }

    @Override
    public String getEncoding() {
        return this.m_encoding;
    }

    @Override
    public CmsFile getFile() {
        return this.m_file;
    }

    @Override
    public int getIndexCount(String path, Locale locale) {
        List<I_CmsXmlContentValue> elements = this.getValues(path, locale);
        if (elements == null) {
            return 0;
        }
        return elements.size();
    }

    @Override
    public List<Locale> getLocales() {
        return new ArrayList<Locale>(this.m_locales);
    }

    @Override
    public List<Locale> getLocales(String path) {
        Set<Locale> locales = this.m_elementLocales.get(CmsXmlUtils.createXpath(path, 1));
        if (locales != null) {
            return new ArrayList<Locale>(locales);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getNames(Locale locale) {
        Set<String> names = this.m_elementNames.get(locale);
        if (names != null) {
            return new ArrayList<String>(names);
        }
        return Collections.emptyList();
    }

    @Override
    public String getStringValue(CmsObject cms, String path, Locale locale) {
        I_CmsXmlContentValue value = this.getValueInternal(CmsXmlUtils.createXpath(path, 1), locale);
        if (value != null) {
            return value.getStringValue(cms);
        }
        return null;
    }

    @Override
    public String getStringValue(CmsObject cms, String path, Locale locale, int index) {
        I_CmsXmlContentValue value = this.getValueInternal(CmsXmlUtils.createXpath(path, index + 1), locale);
        if (value != null) {
            return value.getStringValue(cms);
        }
        return null;
    }

    @Override
    public List<I_CmsXmlContentValue> getSubValues(String path, Locale locale) {
        ArrayList<I_CmsXmlContentValue> result = new ArrayList<I_CmsXmlContentValue>();
        String bookmark = A_CmsXmlDocument.getBookmarkName(CmsXmlUtils.createXpath(path, 1), locale);
        I_CmsXmlContentValue value = this.getBookmark(bookmark);
        if (value != null && !value.isSimpleType()) {
            int depth = CmsResource.getPathLevel(bookmark) + 1;
            for (String bm : this.getBookmarks()) {
                if (!bm.startsWith(bookmark) || CmsResource.getPathLevel(bm) != depth) continue;
                result.add(this.getBookmark(bm));
            }
        }
        return result;
    }

    @Override
    public I_CmsXmlContentValue getValue(String path, Locale locale) {
        return this.getValueInternal(CmsXmlUtils.createXpath(path, 1), locale);
    }

    @Override
    public I_CmsXmlContentValue getValue(String path, Locale locale, int index) {
        return this.getValueInternal(CmsXmlUtils.createXpath(path, index + 1), locale);
    }

    @Override
    public List<I_CmsXmlContentValue> getValues(Locale locale) {
        ArrayList<I_CmsXmlContentValue> result = new ArrayList<I_CmsXmlContentValue>();
        String prefix = '/' + locale.toString() + '/';
        for (Map.Entry<String, I_CmsXmlContentValue> entry : this.m_bookmarks.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            result.add(entry.getValue());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<I_CmsXmlContentValue> getValues(String path, Locale locale) {
        ArrayList<I_CmsXmlContentValue> result;
        block4: {
            result = new ArrayList<I_CmsXmlContentValue>();
            String bookmark = A_CmsXmlDocument.getBookmarkName(CmsXmlUtils.createXpath(CmsXmlUtils.removeXpathIndex(path), 1), locale);
            I_CmsXmlContentValue value = this.getBookmark(bookmark);
            if (value == null) break block4;
            if (value.getContentDefinition().getChoiceMaxOccurs() > 1) {
                String parent = CmsXmlUtils.removeLastXpathElement(bookmark);
                int depth = CmsResource.getPathLevel(bookmark);
                for (String bm : this.getBookmarks()) {
                    if (!bm.startsWith(parent) || CmsResource.getPathLevel(bm) != depth) continue;
                    result.add(this.getBookmark(bm));
                }
            } else {
                int index = 1;
                String bm = CmsXmlUtils.removeXpathIndex(bookmark);
                while (value != null) {
                    result.add(value);
                    String subpath = CmsXmlUtils.createXpathElement(bm, ++index);
                    value = this.getBookmark(subpath);
                }
            }
        }
        return result;
    }

    @Override
    public boolean hasLocale(Locale locale) {
        if (locale == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NULL_LOCALE_0"));
        }
        return this.m_locales.contains(locale);
    }

    @Override
    public boolean hasValue(String path, Locale locale) {
        return null != this.getBookmark(CmsXmlUtils.createXpath(path, 1), locale);
    }

    @Override
    public boolean hasValue(String path, Locale locale, int index) {
        return null != this.getBookmark(CmsXmlUtils.createXpath(path, index + 1), locale);
    }

    @Override
    public void initDocument() {
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    @Override
    public boolean isEnabled(String path, Locale locale) {
        return this.hasValue(path, locale);
    }

    @Override
    public boolean isEnabled(String path, Locale locale, int index) {
        return this.hasValue(path, locale, index);
    }

    public byte[] marshal() throws CmsXmlException {
        return ((ByteArrayOutputStream)this.marshal(new ByteArrayOutputStream(), this.m_encoding)).toByteArray();
    }

    @Override
    public void moveLocale(Locale source, Locale destination) throws CmsXmlException {
        this.copyLocale(source, destination);
        this.removeLocale(source);
    }

    @Override
    public void removeLocale(Locale locale) throws CmsXmlException {
        if (!this.hasLocale(locale)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", locale));
        }
        Element rootNode = this.m_document.getRootElement();
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(rootNode);
        String localeStr = locale.toString();
        while (i.hasNext()) {
            Element element = i.next();
            String language = element.attributeValue("language", null);
            if (language == null || !localeStr.equals(language)) continue;
            element.detach();
            break;
        }
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public void setConversion(String conversion) {
        this.m_conversion = conversion;
    }

    public String toString() {
        try {
            return CmsXmlUtils.marshal(this.m_document, this.m_encoding);
        }
        catch (CmsXmlException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_WRITE_XML_DOC_TO_STRING_0"), (Throwable)e);
        }
    }

    public void validateXmlStructure(EntityResolver resolver) throws CmsXmlException {
        if (this.m_file != null) {
            CmsXmlUtils.validateXmlStructure(this.m_file.getContents(), resolver);
        } else {
            CmsXmlUtils.validateXmlStructure(this.m_document, this.m_encoding, resolver);
        }
    }

    protected void addBookmark(String path, Locale locale, boolean enabled, I_CmsXmlContentValue value) {
        Set<String> sn;
        this.addLocale(locale);
        this.m_bookmarks.put(A_CmsXmlDocument.getBookmarkName(path, locale), value);
        if (enabled) {
            Set<Locale> sl = this.m_elementLocales.get(path);
            if (sl != null) {
                sl.add(locale);
            } else {
                HashSet<Locale> set = new HashSet<Locale>();
                set.add(locale);
                this.m_elementLocales.put(path, set);
            }
        }
        if ((sn = this.m_elementNames.get(locale)) == null) {
            sn = new HashSet<String>();
            this.m_elementNames.put(locale, sn);
        }
        sn.add(path);
    }

    protected void addLocale(Locale locale) {
        this.m_locales.add(locale);
    }

    protected void clearBookmarks() {
        this.m_bookmarks.clear();
    }

    protected Element createDeepElementCopy(Element element, Set<String> copyElements) {
        return this.createDeepElementCopyInternal(null, null, element, copyElements);
    }

    protected I_CmsXmlContentValue getBookmark(String bookmark) {
        return this.m_bookmarks.get(bookmark);
    }

    protected I_CmsXmlContentValue getBookmark(String path, Locale locale) {
        return this.m_bookmarks.get(A_CmsXmlDocument.getBookmarkName(path, locale));
    }

    protected Set<String> getBookmarks() {
        return this.m_bookmarks.keySet();
    }

    protected I_CmsXmlContentValue getValueInternal(String path, Locale locale) {
        return this.getBookmark(path, locale);
    }

    protected abstract void initDocument(Document var1, String var2, CmsXmlContentDefinition var3);

    protected boolean isAutoCorrectionEnabled() {
        return false;
    }

    protected OutputStream marshal(OutputStream out, String encoding) throws CmsXmlException {
        return CmsXmlUtils.marshal(this.m_document, out, encoding);
    }

    protected I_CmsXmlContentValue removeBookmark(String path, Locale locale) {
        Set<String> sn;
        Set<Locale> sl = this.m_elementLocales.get(path);
        if (sl != null) {
            sl.remove(locale);
        }
        if ((sn = this.m_elementNames.get(locale)) != null) {
            sn.remove(path);
        }
        return this.m_bookmarks.remove(A_CmsXmlDocument.getBookmarkName(path, locale));
    }

    private Element createDeepElementCopyInternal(String parentPath, Element parent, Element element, Set<String> copyElements) {
        String elName = element.getName();
        if (parentPath != null) {
            Element first = element.getParent().element(elName);
            int elIndex = element.getParent().indexOf((Node)element) - first.getParent().indexOf((Node)first) + 1;
            elName = parentPath + (parentPath.length() > 0 ? "/" : "") + elName.concat("[" + elIndex + "]");
        }
        if (parentPath == null || copyElements.contains(elName)) {
            Element copy = element.createCopy();
            if (parentPath != null) {
                parent.add(copy);
            }
            boolean copyNested = parentPath == null;
            Iterator<String> i = copyElements.iterator();
            while (!copyNested && i.hasNext()) {
                String path = i.next();
                copyNested = !elName.equals(path) && path.startsWith(elName);
            }
            if (copyNested) {
                copy.clearContent();
                i = CmsXmlGenericWrapper.elementIterator(element);
                while (i.hasNext()) {
                    Element el = (Element)i.next();
                    this.createDeepElementCopyInternal(parentPath == null ? "" : elName, copy, el, copyElements);
                }
            }
            return copy;
        }
        return null;
    }
}

