/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.Messages;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CmsXmlErrorHandler
implements ErrorHandler {
    private static final Log LOG = CmsLog.getLog(CmsXmlErrorHandler.class);
    private String m_resourceName;

    public CmsXmlErrorHandler() {
        this("");
    }

    public CmsXmlErrorHandler(String resourceName) {
        this.m_resourceName = !CmsStringUtil.isEmptyOrWhitespaceOnly(resourceName) ? " " + resourceName : "";
    }

    public void error(SAXParseException exception) throws SAXException {
        LOG.error((Object)Messages.get().getBundle().key("LOG_PARSING_XML_RESOURCE_ERROR_1", this.m_resourceName), (Throwable)exception);
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        LOG.error((Object)Messages.get().getBundle().key("LOG_PARSING_XML_RESOURCE_FATAL_ERROR_1", this.m_resourceName), (Throwable)exception);
        throw exception;
    }

    public void warning(SAXParseException exception) {
        if (LOG.isWarnEnabled()) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSING_XML_RESOURCE_WARNING_1", this.m_resourceName), (Throwable)exception);
        }
    }
}

