/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsCache;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.main.CmsLog;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsADECacheSettings;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.Messages;

public final class CmsADECache
extends CmsVfsCache {
    private static final Log LOG = CmsLog.getLog(CmsADECache.class);
    private Map<String, CmsXmlContainerPage> m_containerPagesOffline;
    private Map<String, CmsXmlContainerPage> m_containerPagesOnline;
    private Map<String, CmsXmlGroupContainer> m_groupContainersOffline;
    private Map<String, CmsXmlGroupContainer> m_groupContainersOnline;

    public CmsADECache(CmsMemoryMonitor memMonitor, CmsADECacheSettings cacheSettings) {
        this.initialize(memMonitor, cacheSettings);
        this.registerEventListener();
    }

    public void flushContainerPages(boolean online) {
        if (online) {
            this.m_containerPagesOnline.clear();
        } else {
            this.m_containerPagesOffline.clear();
        }
    }

    public void flushGroupContainers(boolean online) {
        if (online) {
            this.m_groupContainersOnline.clear();
        } else {
            this.m_groupContainersOffline.clear();
        }
    }

    public CmsXmlContainerPage getCacheContainerPage(String key, boolean online) {
        CmsXmlContainerPage retValue;
        if (online) {
            retValue = this.m_containerPagesOnline.get(key);
            if (LOG.isDebugEnabled()) {
                if (retValue == null) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_ONLINE_1", new Object[]{key}));
                } else {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_ONLINE_2", new Object[]{key, retValue}));
                }
            }
        } else {
            retValue = this.m_containerPagesOffline.get(key);
            if (LOG.isDebugEnabled()) {
                if (retValue == null) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_OFFLINE_1", new Object[]{key}));
                } else {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_OFFLINE_2", new Object[]{key, retValue}));
                }
            }
        }
        if (retValue != null) {
            // empty if block
        }
        return retValue;
    }

    public CmsXmlGroupContainer getCacheGroupContainer(String key, boolean online) {
        CmsXmlGroupContainer retValue;
        if (online) {
            retValue = this.m_groupContainersOnline.get(key);
            if (LOG.isDebugEnabled()) {
                if (retValue == null) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_ONLINE_1", new Object[]{key}));
                } else {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_ONLINE_2", new Object[]{key, retValue}));
                }
            }
        } else {
            retValue = this.m_groupContainersOffline.get(key);
            if (LOG.isDebugEnabled()) {
                if (retValue == null) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_OFFLINE_1", new Object[]{key}));
                } else {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_OFFLINE_2", new Object[]{key, retValue}));
                }
            }
        }
        return retValue;
    }

    public String getCacheKey(CmsUUID structureId, boolean keepEncoding) {
        return structureId.toString() + "_" + keepEncoding;
    }

    public void setCacheContainerPage(String key, CmsXmlContainerPage containerPage, boolean online) {
        if (online) {
            this.m_containerPagesOnline.put(key, containerPage);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_ONLINE_2", new Object[]{key, containerPage}));
            }
        } else {
            this.m_containerPagesOffline.put(key, containerPage);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_OFFLINE_2", new Object[]{key, containerPage}));
            }
        }
    }

    public void setCacheGroupContainer(String key, CmsXmlGroupContainer groupContainer, boolean online) {
        if (online) {
            this.m_groupContainersOnline.put(key, groupContainer);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_ONLINE_2", new Object[]{key, groupContainer}));
            }
        } else {
            this.m_groupContainersOffline.put(key, groupContainer);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_OFFLINE_2", new Object[]{key, groupContainer}));
            }
        }
    }

    public void uncacheContainerPage(CmsUUID structureId, boolean online) {
        if (online) {
            this.m_containerPagesOnline.remove(this.getCacheKey(structureId, true));
            this.m_containerPagesOnline.remove(this.getCacheKey(structureId, false));
        } else {
            this.m_containerPagesOffline.remove(this.getCacheKey(structureId, true));
            this.m_containerPagesOffline.remove(this.getCacheKey(structureId, false));
        }
    }

    public void uncacheGroupContainer(CmsUUID structureId, boolean online) {
        if (online) {
            this.m_groupContainersOnline.remove(this.getCacheKey(structureId, true));
            this.m_groupContainersOnline.remove(this.getCacheKey(structureId, false));
        } else {
            this.m_groupContainersOffline.remove(this.getCacheKey(structureId, true));
            this.m_groupContainersOffline.remove(this.getCacheKey(structureId, false));
        }
    }

    protected void flush(boolean online) {
        this.flushContainerPages(online);
        this.flushGroupContainers(online);
    }

    protected void uncacheResource(CmsResource resource) {
        if (resource == null) {
            LOG.warn((Object)Messages.get().container("LOG_WARN_UNCACHE_NULL_0"));
            return;
        }
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            this.uncacheContainerPage(resource.getStructureId(), false);
        } else {
            this.uncacheGroupContainer(resource.getStructureId(), false);
        }
    }

    private void initialize(CmsMemoryMonitor memMonitor, CmsADECacheSettings cacheSettings) {
        Map lruMapCntPage = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getContainerPageOfflineSize());
        this.m_containerPagesOffline = Collections.synchronizedMap(lruMapCntPage);
        memMonitor.register(CmsADECache.class.getName() + ".containerPagesOffline", lruMapCntPage);
        lruMapCntPage = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getContainerPageOnlineSize());
        this.m_containerPagesOnline = Collections.synchronizedMap(lruMapCntPage);
        memMonitor.register(CmsADECache.class.getName() + ".containerPagesOnline", lruMapCntPage);
        Map lruMapGroupContainer = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getGroupContainerOfflineSize());
        this.m_groupContainersOffline = Collections.synchronizedMap(lruMapGroupContainer);
        memMonitor.register(CmsADECache.class.getName() + ".groupContainersOffline", lruMapGroupContainer);
        lruMapGroupContainer = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getGroupContainerOnlineSize());
        this.m_groupContainersOnline = Collections.synchronizedMap(lruMapGroupContainer);
        memMonitor.register(CmsADECache.class.getName() + ".groupContainersOnline", lruMapGroupContainer);
    }
}

