/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsContainerElementBean {
    private final boolean m_createNew;
    private transient String m_editorHash;
    private final CmsUUID m_elementId;
    private final CmsUUID m_formatterId;
    private final Map<String, String> m_individualSettings;
    private boolean m_inMemoryOnly;
    private transient CmsResource m_resource;
    private transient Map<String, String> m_settings;
    private String m_sitePath;
    private boolean m_releasedAndNotExpired;

    public CmsContainerElementBean(CmsUUID elementId, CmsUUID formatterId, Map<String, String> individualSettings, boolean createNew) {
        this.m_elementId = elementId;
        this.m_formatterId = formatterId;
        HashMap newSettings = individualSettings == null ? new HashMap() : individualSettings;
        this.m_individualSettings = Collections.unmodifiableMap(newSettings);
        String clientId = this.m_elementId.toString();
        if (!this.m_individualSettings.isEmpty()) {
            int hash = this.m_individualSettings.toString().hashCode();
            clientId = clientId + "#" + hash;
        }
        this.m_editorHash = clientId;
        this.m_createNew = createNew;
    }

    public static CmsContainerElementBean cloneWithSettings(CmsContainerElementBean source, Map<String, String> settings) {
        CmsContainerElementBean result = new CmsContainerElementBean(source.m_elementId, source.m_formatterId, settings, source.m_createNew);
        result.m_resource = source.m_resource;
        result.m_sitePath = source.m_sitePath;
        result.m_inMemoryOnly = source.m_inMemoryOnly;
        if (result.m_inMemoryOnly) {
            String editorHash = source.m_editorHash;
            if (editorHash.contains("#")) {
                editorHash = editorHash.substring(0, editorHash.indexOf("#"));
            }
            result.m_editorHash = editorHash = editorHash + result.getSettingsHash();
        }
        return result;
    }

    public static CmsContainerElementBean createElementForResourceType(CmsObject cms, I_CmsResourceType resourceType, String targetFolder, Map<String, String> individualSettings, Locale locale) throws CmsException {
        if (!(resourceType instanceof CmsResourceTypeXmlContent)) {
            throw new IllegalArgumentException();
        }
        CmsContainerElementBean elementBean = new CmsContainerElementBean(CmsUUID.getNullUUID(), null, individualSettings, true);
        elementBean.m_inMemoryOnly = true;
        elementBean.m_editorHash = resourceType.getTypeName() + elementBean.getSettingsHash();
        byte[] content = new byte[]{};
        String schema = ((CmsResourceTypeXmlContent)resourceType).getSchema();
        if (schema != null) {
            CmsObject newCms = OpenCms.initCmsObject(cms);
            newCms.getRequestContext().setUri(targetFolder);
            CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, schema);
            CmsXmlContent xmlContent = CmsXmlContentFactory.createDocument(newCms, locale, OpenCms.getSystemInfo().getDefaultEncoding(), contentDefinition);
            for (Locale otherLocale : OpenCms.getLocaleManager().getAvailableLocales()) {
                if (locale.equals(otherLocale)) continue;
                xmlContent.addLocale(newCms, otherLocale);
            }
            content = xmlContent.marshal();
        }
        elementBean.m_resource = new CmsFile(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), targetFolder + "~", resourceType.getTypeId(), 0, cms.getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, 0L, cms.getRequestContext().getCurrentUser().getId(), 0L, cms.getRequestContext().getCurrentUser().getId(), 0L, Long.MAX_VALUE, 1, content.length, 0L, 0, content);
        return elementBean;
    }

    public String editorHash() {
        return this.m_editorHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsContainerElementBean)) {
            return false;
        }
        return this.editorHash().equals(((CmsContainerElementBean)obj).editorHash());
    }

    public CmsUUID getFormatterId() {
        return this.m_formatterId;
    }

    public CmsUUID getId() {
        return this.m_elementId;
    }

    public Map<String, String> getIndividualSettings() {
        return this.m_individualSettings;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public Map<String, String> getSettings() {
        return this.m_settings;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public int hashCode() {
        return this.m_editorHash.hashCode();
    }

    public void initResource(CmsObject cms) throws CmsException {
        if (this.m_resource == null) {
            if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                this.m_resource = cms.readResource(this.getId());
                this.m_releasedAndNotExpired = true;
            } else {
                this.m_resource = cms.readResource(this.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
                this.m_releasedAndNotExpired = this.m_resource.isReleasedAndNotExpired(cms.getRequestContext().getRequestTime());
            }
        } else if (!this.isInMemoryOnly()) {
            CmsUUID id = this.m_resource.getStructureId();
            if (id == null) {
                id = this.getId();
            }
            if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                this.m_resource = cms.readResource(this.getId());
                this.m_releasedAndNotExpired = true;
            } else {
                this.m_resource = cms.readResource(this.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
                this.m_releasedAndNotExpired = this.m_resource.isReleasedAndNotExpired(cms.getRequestContext().getRequestTime());
            }
        }
        if (this.m_settings == null) {
            this.m_settings = CmsXmlContentPropertyHelper.mergeDefaults(cms, this.m_resource, this.m_individualSettings);
        }
        this.m_sitePath = cms.getSitePath(this.m_resource);
    }

    public boolean isCreateNew() {
        return this.m_createNew;
    }

    public boolean isGroupContainer(CmsObject cms) throws CmsException {
        if (this.m_resource == null) {
            this.initResource(cms);
        }
        return "groupcontainer".equals(OpenCms.getResourceManager().getResourceType(this.m_resource).getTypeName());
    }

    public boolean isInMemoryOnly() {
        return this.m_inMemoryOnly;
    }

    public boolean isReleasedAndNotExpired() {
        return this.isInMemoryOnly() || this.m_releasedAndNotExpired;
    }

    public String toString() {
        return this.editorHash();
    }

    private String getSettingsHash() {
        if (!this.m_individualSettings.isEmpty()) {
            int hash = this.m_individualSettings.toString().hashCode();
            return "#" + hash;
        }
        return "";
    }
}

