/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentMacroVisitor;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;

public class CmsXmlContainerPage
extends CmsXmlContent {
    private static final Log LOG = CmsLog.getLog(CmsXmlContainerPage.class);
    private Map<Locale, CmsContainerPageBean> m_cntPages;

    protected CmsXmlContainerPage() {
    }

    protected CmsXmlContainerPage(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        this.m_document = document;
        this.m_contentDefinition = this.getContentDefinition(resolver);
        this.initDocument(cms, this.m_document, encoding, this.m_contentDefinition);
    }

    protected CmsXmlContainerPage(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsFile modelFile = cms.readFile(modelUri, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsXmlContainerPage model = CmsXmlContainerPageFactory.unmarshal(cms, modelFile);
        CmsMacroResolver macroResolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        this.m_contentDefinition = model.getContentDefinition();
        Document document = (Document)model.m_document.clone();
        this.initDocument(cms, document, model.getEncoding(), this.m_contentDefinition);
        this.visitAllValuesWith(new CmsXmlContentMacroVisitor(cms, macroResolver));
        if (!this.hasLocale(locale)) {
            try {
                this.addLocale(cms, locale);
            }
            catch (CmsXmlException e) {
                // empty catch block
            }
        }
    }

    protected CmsXmlContainerPage(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        this.m_contentDefinition = contentDefinition;
        Document document = this.m_contentDefinition.createDocument(cms, this, locale);
        this.initDocument(cms, document, encoding, this.m_contentDefinition);
    }

    public byte[] createContainerPageXml(CmsObject cms, Locale locale, CmsContainerPageBean cntPage) throws CmsException {
        this.writeContainerPage(cms, locale, cntPage);
        return this.marshal();
    }

    public CmsContainerPageBean getContainerPage(CmsObject cms, Locale locale) {
        Locale theLocale = locale;
        if (!this.m_cntPages.containsKey(theLocale)) {
            LOG.warn((Object)Messages.get().container("LOG_CONTAINER_PAGE_LOCALE_NOT_FOUND_2", cms.getSitePath(this.getFile()), theLocale.toString()).key());
            return null;
        }
        return this.m_cntPages.get(theLocale);
    }

    public boolean isAutoCorrectionEnabled() {
        return true;
    }

    public void save(CmsObject cms, Locale locale, CmsContainerPageBean cntPage) throws CmsException {
        CmsFile file = this.getFile();
        cms.lockResourceTemporary(cms.getSitePath(file));
        byte[] data = this.createContainerPageXml(cms, locale, cntPage);
        file.setContents(data);
        cms.writeFile(file);
    }

    public void writeContainerPage(CmsObject cms, Locale locale, CmsContainerPageBean cntPage) throws CmsException {
        CmsContainerPageBean savePage = this.addUnusedContainers(cms, locale, cntPage);
        if (this.hasLocale(locale)) {
            this.removeLocale(locale);
        }
        this.addLocale(cms, locale);
        Element parent = this.getLocaleNode(locale);
        this.saveContainerPage(cms, parent, savePage);
        this.initDocument(this.m_document, this.m_encoding, this.m_contentDefinition);
    }

    protected CmsContainerPageBean addUnusedContainers(CmsObject cms, Locale locale, CmsContainerPageBean cntPage) {
        Map<String, CmsContainerBean> currentContainers = cntPage.getContainers();
        ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
        for (String cntName : cntPage.getNames()) {
            containers.add(currentContainers.get(cntName));
        }
        CmsContainerPageBean currentContainerPage = this.getContainerPage(cms, locale);
        if (currentContainerPage != null) {
            for (String cntName : currentContainerPage.getNames()) {
                if (currentContainers.containsKey(cntName)) continue;
                containers.add(currentContainerPage.getContainers().get(cntName));
            }
        }
        return new CmsContainerPageBean(locale, containers);
    }

    protected CmsResource fillResource(CmsObject cms, Element element, CmsUUID resourceId) throws CmsException {
        String xpath = element.getPath();
        int pos = xpath.lastIndexOf("/" + XmlNode.Containers.name() + "/");
        if (pos > 0) {
            xpath = xpath.substring(pos + 1);
        }
        CmsRelationType type = this.getHandler().getRelationType(xpath);
        CmsResource res = cms.readResource(resourceId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsXmlVfsFileValue.fillEntry(element, res.getStructureId(), res.getRootPath(), type);
        return res;
    }

    protected void initDocument(Document document, String encoding, CmsXmlContentDefinition definition) {
        this.m_document = document;
        this.m_contentDefinition = definition;
        this.m_encoding = CmsEncoder.lookupEncoding(encoding, encoding);
        this.m_elementLocales = new HashMap();
        this.m_elementNames = new HashMap();
        this.m_locales = new HashSet();
        this.m_cntPages = new HashMap<Locale, CmsContainerPageBean>();
        this.clearBookmarks();
        Iterator<Element> itCntPages = CmsXmlGenericWrapper.elementIterator(this.m_document.getRootElement());
        while (itCntPages.hasNext()) {
            Element cntPage = itCntPages.next();
            try {
                Locale locale = CmsLocaleManager.getLocale(cntPage.attribute("language").getValue());
                this.addLocale(locale);
                ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
                Iterator<Element> itCnts = CmsXmlGenericWrapper.elementIterator(cntPage, XmlNode.Containers.name());
                while (itCnts.hasNext()) {
                    Element container = itCnts.next();
                    int cntIndex = CmsXmlUtils.getXpathIndexInt(container.getUniquePath(cntPage));
                    String cntPath = CmsXmlUtils.createXpathElement(container.getName(), cntIndex);
                    I_CmsXmlSchemaType cntSchemaType = definition.getSchemaType(container.getName());
                    I_CmsXmlContentValue cntValue = cntSchemaType.createValue(this, container, locale);
                    this.addBookmark(cntPath, locale, true, cntValue);
                    CmsXmlContentDefinition cntDef = ((CmsXmlNestedContentDefinition)cntSchemaType).getNestedContentDefinition();
                    Element name = container.element(XmlNode.Name.name());
                    this.addBookmarkForElement(name, locale, container, cntPath, cntDef);
                    Element type = container.element(XmlNode.Type.name());
                    this.addBookmarkForElement(type, locale, container, cntPath, cntDef);
                    ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
                    Iterator<Element> itElems = CmsXmlGenericWrapper.elementIterator(container, XmlNode.Elements.name());
                    while (itElems.hasNext()) {
                        Element element = itElems.next();
                        int elemIndex = CmsXmlUtils.getXpathIndexInt(element.getUniquePath(container));
                        String elemPath = CmsXmlUtils.concatXpath(cntPath, CmsXmlUtils.createXpathElement(element.getName(), elemIndex));
                        I_CmsXmlSchemaType elemSchemaType = cntDef.getSchemaType(element.getName());
                        I_CmsXmlContentValue elemValue = elemSchemaType.createValue(this, element, locale);
                        this.addBookmark(elemPath, locale, true, elemValue);
                        CmsXmlContentDefinition elemDef = ((CmsXmlNestedContentDefinition)elemSchemaType).getNestedContentDefinition();
                        Element uri = element.element(XmlNode.Uri.name());
                        this.addBookmarkForElement(uri, locale, element, elemPath, elemDef);
                        Element uriLink = uri.element("link");
                        CmsUUID elementId = null;
                        if (uriLink != null) {
                            elementId = new CmsLink(uriLink).getStructureId();
                        }
                        Element createNewElement = element.element(XmlNode.CreateNew.name());
                        boolean createNew = createNewElement != null && Boolean.parseBoolean(createNewElement.getStringValue());
                        Element formatter = element.element(XmlNode.Formatter.name());
                        this.addBookmarkForElement(formatter, locale, element, elemPath, elemDef);
                        Element formatterLink = formatter.element("link");
                        CmsUUID formatterId = null;
                        if (formatterLink != null) {
                            formatterId = new CmsLink(formatterLink).getStructureId();
                        }
                        Map<String, String> propertiesMap = CmsXmlContentPropertyHelper.readProperties(this, locale, element, elemPath, elemDef);
                        if (elementId == null) continue;
                        elements.add(new CmsContainerElementBean(elementId, formatterId, propertiesMap, createNew));
                    }
                    CmsContainerBean newContainerBean = new CmsContainerBean(name.getText(), type.getText(), elements);
                    containers.add(newContainerBean);
                }
                this.m_cntPages.put(locale, new CmsContainerPageBean(locale, containers));
            }
            catch (NullPointerException e) {
                LOG.error((Object)org.opencms.xml.content.Messages.get().getBundle().key("LOG_XMLCONTENT_INIT_BOOKMARKS_0"), (Throwable)e);
            }
        }
    }

    protected void saveContainerPage(CmsObject cms, Element parent, CmsContainerPageBean cntPage) throws CmsException {
        parent.clearContent();
        for (String containerName : cntPage.getNames()) {
            CmsContainerBean container = cntPage.getContainers().get(containerName);
            Element cntElement = parent.addElement(XmlNode.Containers.name());
            cntElement.addElement(XmlNode.Name.name()).addCDATA(container.getName());
            cntElement.addElement(XmlNode.Type.name()).addCDATA(container.getType());
            for (CmsContainerElementBean element : container.getElements()) {
                Element elemElement = cntElement.addElement(XmlNode.Elements.name());
                Element uriElem = elemElement.addElement(XmlNode.Uri.name());
                CmsResource uriRes = this.fillResource(cms, uriElem, element.getId());
                Element formatterElem = elemElement.addElement(XmlNode.Formatter.name());
                this.fillResource(cms, formatterElem, element.getFormatterId());
                Map<String, String> properties = element.getIndividualSettings();
                Map<String, CmsXmlContentProperty> propertiesConf = OpenCms.getADEManager().getElementSettings(cms, uriRes);
                CmsXmlContentPropertyHelper.saveProperties(cms, elemElement, properties, uriRes, propertiesConf);
            }
        }
    }

    protected void setFile(CmsFile file) {
        super.setFile(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlNode {
        Attribute,
        Containers,
        CreateNew,
        Elements,
        Formatter,
        Key,
        Name,
        Type,
        Uri,
        Value;

    }
}

