/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.I_CmsConfigurationObject;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.I_CmsXmlContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsADEConfigData {
    private static final Log LOG = CmsLog.getLog(CmsADEConfigData.class);
    protected boolean m_createContentsLocally;
    protected boolean m_discardInheritedModelPages;
    protected boolean m_discardInheritedProperties;
    protected boolean m_discardInheritedTypes;
    private String m_basePath;
    private CmsObject m_cms;
    private List<CmsFunctionReference> m_functionReferences = new ArrayList<CmsFunctionReference>();
    private boolean m_initialized;
    private boolean m_isModuleConfig;
    private List<CmsDetailPageInfo> m_ownDetailPages = new ArrayList<CmsDetailPageInfo>();
    private List<CmsModelPageConfig> m_ownModelPageConfig = new ArrayList<CmsModelPageConfig>();
    private List<CmsPropertyConfig> m_ownPropertyConfigurations = new ArrayList<CmsPropertyConfig>();
    private List<CmsResourceTypeConfig> m_ownResourceTypes = new ArrayList<CmsResourceTypeConfig>();
    private CmsResource m_resource;

    public CmsADEConfigData() {
    }

    public CmsADEConfigData(String basePath) {
        this.m_basePath = basePath;
    }

    public CmsADEConfigData(String basePath, List<CmsResourceTypeConfig> resourceTypeConfig, boolean discardInheritedTypes, List<CmsPropertyConfig> propertyConfig, boolean discardInheritedProperties, List<CmsDetailPageInfo> detailPageInfos, List<CmsModelPageConfig> modelPages, List<CmsFunctionReference> functionReferences, boolean discardInheritedModelPages, boolean createContentsLocally) {
        this.m_basePath = basePath;
        this.m_ownResourceTypes = resourceTypeConfig;
        this.m_ownPropertyConfigurations = propertyConfig;
        this.m_ownModelPageConfig = modelPages;
        this.m_ownDetailPages = detailPageInfos;
        this.m_functionReferences = functionReferences;
        this.m_discardInheritedTypes = discardInheritedTypes;
        this.m_discardInheritedProperties = discardInheritedProperties;
        this.m_discardInheritedModelPages = discardInheritedModelPages;
        this.m_createContentsLocally = createContentsLocally;
    }

    public static CmsADEConfigData emptyConfiguration(String basePath) {
        return new CmsADEConfigData(basePath);
    }

    protected static <C extends I_CmsConfigurationObject<C>> List<C> combineConfigurationElements(List<C> parentConfigs, List<C> childConfigs) {
        ArrayList<Object> result = new ArrayList();
        LinkedHashMap<String, I_CmsConfigurationObject> map = new LinkedHashMap<String, I_CmsConfigurationObject>();
        if (parentConfigs != null) {
            for (I_CmsConfigurationObject parent : Lists.reverse(parentConfigs)) {
                map.put(parent.getKey(), parent);
            }
        }
        if (childConfigs == null) {
            childConfigs = Collections.emptyList();
        }
        for (I_CmsConfigurationObject child : Lists.reverse(childConfigs)) {
            String childKey = child.getKey();
            if (child.isDisabled()) {
                map.remove(childKey);
                continue;
            }
            I_CmsConfigurationObject parent = (I_CmsConfigurationObject)map.get(childKey);
            map.remove(childKey);
            I_CmsConfigurationObject newValue = parent != null ? parent.merge(child) : child;
            map.put(childKey, newValue);
        }
        result = new ArrayList(map.values());
        Collections.reverse(result);
        return result;
    }

    public List<CmsDetailPageInfo> getAllDetailPages() {
        return this.getAllDetailPages(true);
    }

    public List<CmsDetailPageInfo> getAllDetailPages(boolean update) {
        this.checkInitialized();
        CmsADEConfigData parentData = this.parent();
        List<CmsDetailPageInfo> parentDetailPages = parentData != null ? parentData.getAllDetailPages(false) : Collections.emptyList();
        List<CmsDetailPageInfo> result = this.mergeDetailPages(parentDetailPages, this.m_ownDetailPages);
        if (update) {
            result = this.updateUris(result);
        }
        return result;
    }

    public String getBasePath() {
        this.checkInitialized();
        return this.m_basePath;
    }

    public String getContentFolderPath() {
        return CmsStringUtil.joinPaths(this.m_basePath, ".content");
    }

    public List<CmsResourceTypeConfig> getCreatableTypes(CmsObject cms) throws CmsException {
        this.checkInitialized();
        ArrayList<CmsResourceTypeConfig> result = new ArrayList<CmsResourceTypeConfig>();
        for (CmsResourceTypeConfig typeConfig : this.getResourceTypes()) {
            if (!typeConfig.checkCreatable(cms)) continue;
            result.add(typeConfig);
        }
        return result;
    }

    public CmsModelPageConfig getDefaultModelPage() {
        this.checkInitialized();
        List<CmsModelPageConfig> modelPages = this.getModelPages();
        for (CmsModelPageConfig modelPageConfig : this.getModelPages()) {
            if (!modelPageConfig.isDefault()) continue;
            return modelPageConfig;
        }
        if (modelPages.isEmpty()) {
            return null;
        }
        return modelPages.get(0);
    }

    public List<CmsDetailPageInfo> getDetailPagesForType(String type) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsDetailPageInfo detailpage : this.getAllDetailPages(true)) {
            if (!detailpage.getType().equals(type)) continue;
            result.add(detailpage);
        }
        return result;
    }

    public CmsFormatterConfiguration getFormatters(CmsObject cms, CmsResource res) {
        int resTypeId = res.getTypeId();
        try {
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resTypeId);
            String typeName = resType.getTypeName();
            CmsResourceTypeConfig typeConfig = this.getResourceType(typeName);
            if (typeConfig != null && typeConfig.getFormatterConfiguration() != null && !typeConfig.getFormatterConfiguration().getAllFormatters().isEmpty()) {
                return typeConfig.getFormatterConfiguration();
            }
            return this.getFormattersFromSchema(cms, res);
        }
        catch (CmsLoaderException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public CmsFunctionReference getFunctionReference(String name) {
        List<CmsFunctionReference> functionReferences = this.getFunctionReferences();
        for (CmsFunctionReference functionRef : functionReferences) {
            if (!functionRef.getName().equals(name)) continue;
            return functionRef;
        }
        return null;
    }

    public List<CmsFunctionReference> getFunctionReferences() {
        return this.internalGetFunctionReferences();
    }

    public CmsDetailPageInfo getMainDetailPage(String type) {
        List<CmsDetailPageInfo> detailPages = this.getDetailPagesForType(type);
        if (detailPages == null || detailPages.isEmpty()) {
            return null;
        }
        return detailPages.get(0);
    }

    public List<CmsModelPageConfig> getModelPages() {
        CmsADEConfigData parentData = this.parent();
        List<Object> parentModelPages = parentData != null && !this.m_discardInheritedModelPages ? parentData.getModelPages() : Collections.emptyList();
        List<CmsModelPageConfig> result = CmsADEConfigData.combineConfigurationElements(parentModelPages, this.m_ownModelPageConfig);
        return result;
    }

    public List<CmsPropertyConfig> getPropertyConfiguration() {
        CmsADEConfigData parentData = this.parent();
        List<Object> parentProperties = parentData != null && !this.m_discardInheritedProperties ? parentData.getPropertyConfiguration() : Collections.emptyList();
        List<CmsPropertyConfig> result = CmsADEConfigData.combineConfigurationElements(parentProperties, this.m_ownPropertyConfigurations);
        return result;
    }

    public Map<String, CmsXmlContentProperty> getPropertyConfigurationAsMap() {
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        for (CmsPropertyConfig propConf : this.getPropertyConfiguration()) {
            result.put(propConf.getName(), propConf.getPropertyData());
        }
        return result;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public CmsResourceTypeConfig getResourceType(String typeName) {
        this.checkInitialized();
        for (CmsResourceTypeConfig type : this.getResourceTypes()) {
            if (!typeName.equals(type.getTypeName())) continue;
            return type;
        }
        return null;
    }

    public List<CmsResourceTypeConfig> getResourceTypes() {
        List<CmsResourceTypeConfig> result = this.internalGetResourceTypes();
        for (CmsResourceTypeConfig config : result) {
            config.initialize(this.m_cms);
        }
        return result;
    }

    public Collection<CmsResourceTypeConfig> getSearchableTypes(CmsObject cms) {
        return this.getResourceTypes();
    }

    public void initialize(CmsObject cms) {
        this.m_cms = cms;
        this.m_initialized = true;
    }

    public boolean isCreateContentsLocally() {
        return this.m_createContentsLocally;
    }

    public boolean isDiscardInheritedModelPages() {
        return this.m_discardInheritedModelPages;
    }

    public boolean isDiscardInheritedProperties() {
        return this.m_discardInheritedProperties;
    }

    public boolean isDiscardInheritedTypes() {
        return this.m_discardInheritedTypes;
    }

    public boolean isModuleConfiguration() {
        return this.m_isModuleConfig;
    }

    public CmsADEConfigData parent() {
        if (this.m_basePath == null) {
            return null;
        }
        String parentPath = CmsResource.getParentFolder(this.m_basePath);
        if (OpenCms.getADEManager() == null) {
            return null;
        }
        CmsADEConfigData result = OpenCms.getADEManager().internalLookupConfiguration(this.m_cms, parentPath);
        return result;
    }

    public void setIsModuleConfig(boolean isModuleConfig) {
        this.checkNotInitialized();
        this.m_isModuleConfig = isModuleConfig;
    }

    public void setResource(CmsResource resource) {
        this.checkNotInitialized();
        this.m_resource = resource;
    }

    protected void checkInitialized() {
        if (!this.m_initialized) {
            throw new IllegalStateException();
        }
    }

    protected void checkNotInitialized() {
        if (this.m_initialized) {
            throw new IllegalStateException();
        }
    }

    protected void createContentDirectory() throws CmsException {
        String contentFolder;
        if (!this.isModuleConfiguration() && !this.m_cms.existsResource(contentFolder = this.getContentFolderPath())) {
            this.m_cms.createResource(contentFolder, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()).getTypeId());
        }
    }

    protected CmsObject getCmsObject() {
        return this.m_cms;
    }

    protected Map<String, List<CmsDetailPageInfo>> getDetailPagesMap(List<CmsDetailPageInfo> detailPages) {
        HashMap result = Maps.newHashMap();
        for (CmsDetailPageInfo detailpage : detailPages) {
            String type = detailpage.getType();
            if (!result.containsKey(type)) {
                result.put(type, new ArrayList());
            }
            ((List)result.get(type)).add(detailpage);
        }
        return result;
    }

    protected Map<String, String> getFolderTypes() throws CmsException {
        HashMap<String, String> result = new HashMap<String, String>();
        CmsObject cms = OpenCms.initCmsObject(this.m_cms);
        if (this.m_isModuleConfig) {
            Set<String> siteRoots = OpenCms.getSiteManager().getSiteRoots();
            for (String siteRoot : siteRoots) {
                cms.getRequestContext().setSiteRoot(siteRoot);
                for (CmsResourceTypeConfig config : this.getResourceTypes()) {
                    String typeName = config.getTypeName();
                    String folderPath = config.getFolderPath(cms);
                    result.put(CmsStringUtil.joinPaths(folderPath, "/"), typeName);
                }
            }
        } else {
            for (CmsResourceTypeConfig config : this.getResourceTypes()) {
                String typeName = config.getTypeName();
                String folderPath = config.getFolderPath(this.m_cms);
                result.put(CmsStringUtil.joinPaths(folderPath, "/"), typeName);
            }
        }
        return result;
    }

    protected CmsFormatterConfiguration getFormatters(String type) {
        CmsResourceTypeConfig typeConfig = this.getResourceType(type);
        if (typeConfig == null || typeConfig.getFormatterConfiguration() == null || typeConfig.getFormatterConfiguration().getAllFormatters().isEmpty()) {
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.getContentDefinitionForType(this.m_cms, type);
                if (contentDefinition == null) {
                    return null;
                }
                return contentDefinition.getContentHandler().getFormatterConfiguration(this.m_cms, null);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        return typeConfig.getFormatterConfiguration();
    }

    protected CmsFormatterConfiguration getFormattersFromSchema(CmsObject cms, CmsResource res) {
        try {
            I_CmsXmlContentHandler contentHandler = CmsXmlContentDefinition.getContentHandlerForResource(this.m_cms, res);
            return contentHandler.getFormatterConfiguration(cms, res);
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
    }

    protected List<CmsFunctionReference> internalGetFunctionReferences() {
        this.checkInitialized();
        CmsADEConfigData parentData = this.parent();
        if (parentData == null) {
            if (this.m_isModuleConfig) {
                return Collections.unmodifiableList(this.m_functionReferences);
            }
            return Lists.newArrayList();
        }
        return parentData.internalGetFunctionReferences();
    }

    protected List<CmsResourceTypeConfig> internalGetResourceTypes() {
        this.checkInitialized();
        CmsADEConfigData parentData = this.parent();
        ArrayList parentResourceTypes = null;
        if (parentData == null || this.m_discardInheritedTypes) {
            parentResourceTypes = Lists.newArrayList();
        } else {
            parentResourceTypes = Lists.newArrayList();
            for (CmsResourceTypeConfig typeConfig : parentData.internalGetResourceTypes()) {
                parentResourceTypes.add(typeConfig.copy());
            }
        }
        List<CmsResourceTypeConfig> result = CmsADEConfigData.combineConfigurationElements(parentResourceTypes, this.m_ownResourceTypes);
        if (this.m_createContentsLocally) {
            for (CmsResourceTypeConfig typeConfig : result) {
                typeConfig.updateBasePath(CmsStringUtil.joinPaths(this.m_basePath, ".content"));
            }
        }
        return result;
    }

    protected List<CmsDetailPageInfo> mergeDetailPages(List<CmsDetailPageInfo> parentDetailPages, List<CmsDetailPageInfo> ownDetailPages) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        HashMap resultDetailPageMap = Maps.newHashMap();
        resultDetailPageMap.putAll(this.getDetailPagesMap(parentDetailPages));
        resultDetailPageMap.putAll(this.getDetailPagesMap(ownDetailPages));
        result = new ArrayList();
        for (List pages : resultDetailPageMap.values()) {
            result.addAll(pages);
        }
        return result;
    }

    protected void mergeParent(CmsADEConfigData parent) {
        List<Object> parentTypes = null;
        parentTypes = parent != null ? parent.m_ownResourceTypes : Collections.emptyList();
        List<Object> parentProperties = null;
        parentProperties = parent != null ? parent.m_ownPropertyConfigurations : Collections.emptyList();
        List<Object> parentModelPages = null;
        parentModelPages = parent != null ? parent.m_ownModelPageConfig : Collections.emptyList();
        List<Object> parentFunctionRefs = null;
        parentFunctionRefs = parent != null ? parent.m_functionReferences : Collections.emptyList();
        this.m_ownResourceTypes = CmsADEConfigData.combineConfigurationElements(parentTypes, this.m_ownResourceTypes);
        this.m_ownPropertyConfigurations = CmsADEConfigData.combineConfigurationElements(parentProperties, this.m_ownPropertyConfigurations);
        this.m_ownModelPageConfig = CmsADEConfigData.combineConfigurationElements(parentModelPages, this.m_ownModelPageConfig);
        this.m_functionReferences = CmsADEConfigData.combineConfigurationElements(parentFunctionRefs, this.m_functionReferences);
    }

    protected void processModuleOrdering() {
        Collections.sort(this.m_ownResourceTypes, new Comparator<CmsResourceTypeConfig>(){

            @Override
            public int compare(CmsResourceTypeConfig a, CmsResourceTypeConfig b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getTypeName()), (Comparable)((Object)b.getTypeName())).result();
            }
        });
        Collections.sort(this.m_ownPropertyConfigurations, new Comparator<CmsPropertyConfig>(){

            @Override
            public int compare(CmsPropertyConfig a, CmsPropertyConfig b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getName()), (Comparable)((Object)b.getName())).result();
            }
        });
        Collections.sort(this.m_functionReferences, new Comparator<CmsFunctionReference>(){

            @Override
            public int compare(CmsFunctionReference a, CmsFunctionReference b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getName()), (Comparable)((Object)b.getName())).result();
            }
        });
    }

    protected List<CmsDetailPageInfo> updateUris(List<CmsDetailPageInfo> detailPages) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsDetailPageInfo page : detailPages) {
            CmsUUID structureId = page.getId();
            try {
                String rootPath = OpenCms.getADEManager().getRootPath(structureId, this.m_cms.getRequestContext().getCurrentProject().isOnlineProject());
                CmsDetailPageInfo correctedPage = new CmsDetailPageInfo(structureId, rootPath, page.getType());
                result.add(correctedPage);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

