/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmsConfigurationCache
implements I_CmsGlobalConfigurationCache {
    private static final Log LOG = CmsLog.getLog(CmsConfigurationCache.class);
    private static final String MODULE_CONFIG_KEY = "__MODULE_CONFIG_KEY__";
    protected I_CmsResourceType m_configType;
    protected I_CmsResourceType m_moduleConfigType;
    private CmsObject m_cms;
    private Map<String, CmsUUID> m_configurationsToRead = new HashMap<String, CmsUUID>();
    private Map<String, String> m_folderTypes = new HashMap<String, String>();
    private CmsADEConfigData m_moduleConfiguration;
    private Map<CmsUUID, String> m_pathCache = Collections.synchronizedMap(new HashMap());
    private Map<String, CmsADEConfigData> m_siteConfigurations = new HashMap<String, CmsADEConfigData>();

    public CmsConfigurationCache(CmsObject cms, I_CmsResourceType configType, I_CmsResourceType moduleConfigType) {
        this.m_cms = cms;
        this.m_configType = configType;
        this.m_moduleConfigType = moduleConfigType;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    public String getPathForStructureId(CmsUUID structureId) throws CmsException {
        String rootPath = this.m_pathCache.get(structureId);
        if (rootPath != null) {
            return rootPath;
        }
        CmsResource res = this.m_cms.readResource(structureId);
        this.m_pathCache.put(structureId, res.getRootPath());
        return res.getRootPath();
    }

    public synchronized void initialize() {
        this.m_siteConfigurations.clear();
        try {
            List<CmsResource> configFileCandidates = this.m_cms.readResources("/", CmsResourceFilter.DEFAULT.addRequireType(this.m_configType.getTypeId()));
            for (CmsResource candidate : configFileCandidates) {
                if (!this.isSitemapConfiguration(candidate.getRootPath(), candidate.getTypeId())) continue;
                this.update(candidate);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.refreshModuleConfiguration();
        try {
            this.initializeFolderTypes();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void remove(CmsPublishedResource res) {
        this.remove(res.getStructureId(), res.getRootPath(), res.getType());
    }

    @Override
    public void remove(CmsResource res) {
        this.remove(res.getStructureId(), res.getRootPath(), res.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource res) {
        try {
            this.update(res.getStructureId(), res.getRootPath(), res.getType(), res.getState());
        }
        catch (CmsRuntimeException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(CmsResource res) {
        try {
            this.update(res.getStructureId(), res.getRootPath(), res.getTypeId(), res.getState());
        }
        catch (CmsRuntimeException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected synchronized List<CmsDetailPageInfo> getAllDetailPages() {
        this.readRemainingConfigurations();
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsADEConfigData configData : this.m_siteConfigurations.values()) {
            result.addAll(configData.getAllDetailPages(true));
        }
        return result;
    }

    protected String getBasePath(String siteConfigFile) {
        if (siteConfigFile.endsWith("/.content/.config")) {
            return CmsResource.getParentFolder(CmsResource.getParentFolder(siteConfigFile));
        }
        return siteConfigFile;
    }

    protected synchronized List<String> getDetailPages(String type) {
        this.readRemainingConfigurations();
        ArrayList<String> result = new ArrayList<String>();
        for (CmsADEConfigData configData : this.m_siteConfigurations.values()) {
            for (CmsDetailPageInfo pageInfo : configData.getDetailPagesForType(type)) {
                result.add(pageInfo.getUri());
            }
        }
        return result;
    }

    protected synchronized CmsADEConfigData getModuleConfiguration() {
        return this.m_moduleConfiguration;
    }

    protected synchronized String getParentFolderType(String rootPath) {
        this.readRemainingConfigurations();
        String parent = CmsResource.getParentFolder(rootPath);
        if (parent == null) {
            return null;
        }
        String type = this.m_folderTypes.get(parent);
        if (type == null) {
            return null;
        }
        return type;
    }

    protected synchronized CmsADEConfigData getSiteConfigData(String path) {
        if (path == null) {
            return null;
        }
        this.readRemainingConfigurations();
        String normalizedPath = CmsStringUtil.joinPaths("/", path, "/");
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String key : this.m_siteConfigurations.keySet()) {
            if (!normalizedPath.startsWith(CmsStringUtil.joinPaths("/", key, "/"))) continue;
            prefixes.add(key);
        }
        if (prefixes.size() == 0) {
            return null;
        }
        Collections.sort(prefixes);
        return this.m_siteConfigurations.get(prefixes.get(prefixes.size() - 1));
    }

    protected synchronized void initializeFolderTypes() throws CmsException {
        LOG.info((Object)"Computing folder types for detail pages...");
        this.m_folderTypes.clear();
        ArrayList<CmsADEConfigData> configDataObjects = new ArrayList<CmsADEConfigData>(this.m_siteConfigurations.values());
        for (CmsADEConfigData configData : configDataObjects) {
            Map<String, String> folderTypes = configData.getFolderTypes();
            this.m_folderTypes.putAll(folderTypes);
        }
        if (this.m_moduleConfiguration != null) {
            Map<String, String> folderTypes = this.m_moduleConfiguration.getFolderTypes();
            this.m_folderTypes.putAll(folderTypes);
        }
    }

    protected synchronized boolean isDetailPage(CmsObject cms, CmsResource resource) {
        CmsResource folder;
        this.readRemainingConfigurations();
        if (resource.isFile()) {
            if (!CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                return false;
            }
            try {
                folder = this.m_cms.readResource(CmsResource.getParentFolder(resource.getRootPath()));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        } else {
            folder = resource;
        }
        ArrayList<CmsDetailPageInfo> allDetailPages = new ArrayList<CmsDetailPageInfo>();
        for (CmsADEConfigData configData : this.m_siteConfigurations.values()) {
            List<CmsDetailPageInfo> detailPageInfos = configData.getAllDetailPages();
            allDetailPages.addAll(detailPageInfos);
        }
        for (CmsDetailPageInfo info : allDetailPages) {
            if (!folder.getStructureId().equals(info.getId()) && !folder.getRootPath().equals(info.getUri()) && !resource.getStructureId().equals(info.getId()) && !resource.getRootPath().equals(info.getUri())) continue;
            return true;
        }
        String normalizedFolderRootPath = CmsStringUtil.joinPaths(folder.getRootPath(), "/");
        for (CmsDetailPageInfo info : allDetailPages) {
            String parentPath = CmsResource.getParentFolder(info.getUri());
            String normalizedParentPath = CmsStringUtil.joinPaths(parentPath, "/");
            if (!normalizedParentPath.equals(normalizedFolderRootPath)) continue;
            try {
                CmsResource infoResource = this.m_cms.readResource(info.getId());
                if (!infoResource.isFile()) continue;
                return true;
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    protected boolean isModuleConfiguration(String rootPath, int type) {
        return type == this.m_moduleConfigType.getTypeId();
    }

    protected boolean isOnline() {
        return this.m_cms.getRequestContext().getCurrentProject().isOnlineProject();
    }

    protected boolean isSitemapConfiguration(String rootPath, int type) {
        return rootPath.endsWith("/.content/.config") && type == this.m_configType.getTypeId();
    }

    protected synchronized void refreshModuleConfiguration() {
        LOG.info((Object)"Refreshing module configuration.");
        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
        this.m_moduleConfiguration = reader.readModuleConfigurations();
        this.m_moduleConfiguration.initialize(this.m_cms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(CmsUUID structureId, String rootPath, int type) {
        if (CmsResource.isTemporaryFileName(rootPath)) {
            return;
        }
        try {
            this.updateFolderTypes(rootPath);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_pathCache.remove(structureId);
        if (this.isSitemapConfiguration(rootPath, type)) {
            CmsConfigurationCache cmsConfigurationCache = this;
            synchronized (cmsConfigurationCache) {
                String basePath = this.getBasePath(rootPath);
                this.removePath(basePath);
                LOG.info((Object)("Removing config file from cache: " + rootPath));
            }
        }
        if (this.isModuleConfiguration(rootPath, type)) {
            LOG.info((Object)("Removing module configuration " + rootPath));
            CmsConfigurationCache cmsConfigurationCache = this;
            synchronized (cmsConfigurationCache) {
                this.m_configurationsToRead.put(MODULE_CONFIG_KEY, CmsUUID.getNullUUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(CmsUUID structureId, String rootPath, int type, CmsResourceState state) {
        if (CmsResource.isTemporaryFileName(rootPath)) {
            return;
        }
        try {
            this.updateFolderTypes(rootPath);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        Object object = this.m_pathCache;
        synchronized (object) {
            this.m_pathCache.remove(structureId);
            this.m_pathCache.put(structureId, rootPath);
        }
        if (this.isSitemapConfiguration(rootPath, type)) {
            object = this;
            synchronized (object) {
                LOG.info((Object)("Changed configuration file " + rootPath + "(" + structureId + "), will be read later"));
                this.m_configurationsToRead.put(rootPath, structureId);
            }
        }
        if (this.isModuleConfiguration(rootPath, type)) {
            LOG.info((Object)("Changed module configuration file " + rootPath + "(" + structureId + ")"));
            object = this;
            synchronized (object) {
                this.m_configurationsToRead.put(MODULE_CONFIG_KEY, CmsUUID.getNullUUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateFolderTypes(String rootPath) throws CmsException {
        if (this.m_folderTypes.containsKey(rootPath)) {
            LOG.info((Object)("Updating folder types because of a change at " + rootPath));
            CmsConfigurationCache cmsConfigurationCache = this;
            synchronized (cmsConfigurationCache) {
                this.initializeFolderTypes();
            }
        }
    }

    private synchronized void readRemainingConfigurations() {
        if (this.m_configurationsToRead.isEmpty()) {
            return;
        }
        for (Map.Entry<String, CmsUUID> entry : this.m_configurationsToRead.entrySet()) {
            String rootPath = entry.getKey();
            CmsUUID structureId = entry.getValue();
            if (rootPath.equals(MODULE_CONFIG_KEY)) {
                this.refreshModuleConfiguration();
                continue;
            }
            try {
                this.m_siteConfigurations.remove(rootPath);
                CmsResource configRes = this.m_cms.readResource(structureId);
                CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
                LOG.info((Object)("Reading configuration file " + rootPath + "(" + structureId + ")"));
                String basePath = this.getBasePath(rootPath);
                CmsADEConfigData configData = reader.parseSitemapConfiguration(basePath, configRes);
                configData.initialize(this.m_cms);
                this.m_siteConfigurations.put(basePath, configData);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsRuntimeException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.m_configurationsToRead.clear();
        try {
            this.initializeFolderTypes();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CmsRuntimeException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void removePath(String rootPath) {
        this.m_configurationsToRead.remove(rootPath);
        this.m_siteConfigurations.remove(rootPath);
    }
}

