/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFolderOrName;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsConfigurationReader {
    public static final Locale DEFAULT_LOCALE = CmsLocaleManager.getLocale("en");
    public static final String N_CREATE_CONTENTS_LOCALLY = "CreateContentsLocally";
    public static final String N_DEFAULT = "Default";
    public static final String N_DESCRIPTION = "Description";
    public static final String N_DETAIL_PAGE = "DetailPage";
    public static final String N_DETAIL_PAGES_DISABLED = "DetailPagesDisabled";
    public static final String N_DISABLED = "Disabled";
    public static final String N_DISCARD_MODEL_PAGES = "DiscardModelPages";
    public static final String N_DISCARD_PROPERTIES = "DiscardProperties";
    public static final String N_DISCARD_TYPES = "DiscardTypes";
    public static final String N_DISPLAY_NAME = "DisplayName";
    public static final String N_ERROR = "Error";
    public static final String N_FOLDER = "Folder";
    public static final String N_FORMATTER = "Formatter";
    public static final String N_FUNCTION = "Function";
    public static final String N_FUNCTION_REF = "FunctionRef";
    public static final String N_IS_DEFAULT = "IsDefault";
    public static final String N_IS_PREVIEW = "IsPreview";
    public static final String N_JSP = "Jsp";
    public static final String N_MAX_WIDTH = "MaxWidth";
    public static final String N_MIN_WIDTH = "MinWidth";
    public static final String N_MODEL_PAGE = "ModelPage";
    public static final String N_NAME = "Name";
    public static final String N_NAME_PATTERN = "NamePattern";
    public static final String N_ORDER = "Order";
    public static final String N_PAGE = "Page";
    public static final String N_PATH = "Path";
    public static final String N_PREFER_FOLDER = "PreferFolder";
    public static final String N_PROPERTY = "Property";
    public static final String N_PROPERTY_NAME = "PropertyName";
    public static final String N_RESOURCE_TYPE = "ResourceType";
    public static final String N_RULE_REGEX = "RuleRegex";
    public static final String N_RULE_TYPE = "RuleType";
    public static final String N_TYPE = "Type";
    public static final String N_TYPE_NAME = "TypeName";
    public static final String N_WIDGET = "Widget";
    public static final String N_WIDGET_CONFIG = "WidgetConfig";
    private static final Log LOG = CmsLog.getLog(CmsConfigurationReader.class);
    private CmsObject m_cms;
    private List<CmsDetailPageInfo> m_detailPageConfigs = new ArrayList<CmsDetailPageInfo>();
    private List<CmsFunctionReference> m_functionReferences = new ArrayList<CmsFunctionReference>();
    private List<CmsModelPageConfig> m_modelPageConfigs = new ArrayList<CmsModelPageConfig>();
    private List<CmsPropertyConfig> m_propertyConfigs = new ArrayList<CmsPropertyConfig>();
    private List<CmsResourceTypeConfig> m_resourceTypeConfigs = new ArrayList<CmsResourceTypeConfig>();

    public CmsConfigurationReader(CmsObject cms) {
        this.m_cms = cms;
    }

    public List<CmsFunctionReference> getFunctionReferences() {
        return new ArrayList<CmsFunctionReference>(this.m_functionReferences);
    }

    public CmsADEConfigData parseConfiguration(String basePath, CmsXmlContent content) throws CmsException {
        this.m_detailPageConfigs = Lists.newArrayList();
        this.m_functionReferences = Lists.newArrayList();
        this.m_modelPageConfigs = Lists.newArrayList();
        this.m_propertyConfigs = Lists.newArrayList();
        this.m_resourceTypeConfigs = Lists.newArrayList();
        if (!content.hasLocale(DEFAULT_LOCALE)) {
            return CmsADEConfigData.emptyConfiguration(basePath);
        }
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, DEFAULT_LOCALE);
        for (I_CmsXmlContentValueLocation node : root.getSubValues(N_RESOURCE_TYPE)) {
            try {
                this.parseResourceTypeConfig(basePath, node);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (I_CmsXmlContentValueLocation node : root.getSubValues(N_MODEL_PAGE)) {
            try {
                this.parseModelPage(node);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (I_CmsXmlContentValueLocation node : root.getSubValues(N_PROPERTY)) {
            this.parseProperty(node);
        }
        for (I_CmsXmlContentValueLocation node : root.getSubValues(N_DETAIL_PAGE)) {
            try {
                this.parseDetailPage(node);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (I_CmsXmlContentValueLocation node : root.getSubValues(N_FUNCTION_REF)) {
            this.parseFunctionReference(node);
        }
        boolean discardInheritedTypes = this.getBoolean(root, N_DISCARD_TYPES);
        boolean discardInheritedProperties = this.getBoolean(root, N_DISCARD_PROPERTIES);
        boolean discardInheritedModelPages = this.getBoolean(root, N_DISCARD_MODEL_PAGES);
        boolean createContentsLocally = this.getBoolean(root, N_CREATE_CONTENTS_LOCALLY);
        CmsADEConfigData result = new CmsADEConfigData(basePath, this.m_resourceTypeConfigs, discardInheritedTypes, this.m_propertyConfigs, discardInheritedProperties, this.m_detailPageConfigs, this.m_modelPageConfigs, this.m_functionReferences, discardInheritedModelPages, createContentsLocally);
        result.setResource(content.getFile());
        if (OpenCms.getResourceManager().getResourceType(content.getFile().getTypeId()).getTypeName().equals("module_config")) {
            result.setIsModuleConfig(true);
        }
        return result;
    }

    public CmsFolderOrName parseFolderOrName(String basePath, I_CmsXmlContentLocation location) throws CmsException {
        if (location == null) {
            return null;
        }
        I_CmsXmlContentValueLocation nameLoc = location.getSubValue(N_NAME);
        I_CmsXmlContentValueLocation pathLoc = location.getSubValue(N_PATH);
        if (nameLoc != null) {
            String name = nameLoc.asString(this.m_cms);
            return new CmsFolderOrName(basePath == null ? null : CmsStringUtil.joinPaths(basePath, ".content"), name);
        }
        if (pathLoc != null) {
            String path = pathLoc.asString(this.m_cms);
            CmsResource folder = this.m_cms.readResource(path);
            return new CmsFolderOrName(folder);
        }
        return null;
    }

    public CmsFormatterBean parseFormatter(String typeName, I_CmsXmlContentLocation node) {
        String type = this.getString(node.getSubValue(N_TYPE));
        String minWidth = this.getString(node.getSubValue(N_MIN_WIDTH));
        String maxWidth = this.getString(node.getSubValue(N_MAX_WIDTH));
        boolean preview = false;
        I_CmsXmlContentValueLocation previewLoc = node.getSubValue(N_IS_PREVIEW);
        preview = previewLoc != null && Boolean.parseBoolean(previewLoc.asString(this.m_cms));
        String jsp = this.m_cms.getRequestContext().addSiteRoot(this.getString(node.getSubValue(N_JSP)));
        boolean searchContent = true;
        CmsFormatterBean formatterBean = new CmsFormatterBean(type, jsp, minWidth, maxWidth, "" + preview, "" + searchContent, null);
        return formatterBean;
    }

    public void parseModelPage(I_CmsXmlContentLocation node) throws CmsException {
        String page = this.getString(node.getSubValue(N_PAGE));
        I_CmsXmlContentValueLocation disabledLoc = node.getSubValue(N_DISABLED);
        boolean disabled = disabledLoc != null && Boolean.parseBoolean(disabledLoc.asString(this.m_cms));
        I_CmsXmlContentValueLocation defaultLoc = node.getSubValue(N_IS_DEFAULT);
        boolean isDefault = defaultLoc != null && Boolean.parseBoolean(defaultLoc.asString(this.m_cms));
        CmsModelPageConfig modelPage = new CmsModelPageConfig(this.m_cms.readResource(page), isDefault, disabled);
        this.m_modelPageConfigs.add(modelPage);
    }

    public void parseResourceTypeConfig(String basePath, I_CmsXmlContentLocation node) throws CmsException {
        I_CmsXmlContentValueLocation typeNameLoc = node.getSubValue(N_TYPE_NAME);
        String typeName = typeNameLoc.asString(this.m_cms);
        I_CmsXmlContentValueLocation disabledLoc = node.getSubValue(N_DISABLED);
        CmsFolderOrName folderOrName = this.parseFolderOrName(basePath, node.getSubValue(N_FOLDER));
        boolean disabled = disabledLoc != null && Boolean.parseBoolean(disabledLoc.asString(this.m_cms));
        I_CmsXmlContentValueLocation namePatternLoc = node.getSubValue(N_NAME_PATTERN);
        String namePattern = null;
        if (namePatternLoc != null) {
            namePattern = namePatternLoc.asString(this.m_cms);
        }
        boolean detailPagesDisabled = false;
        I_CmsXmlContentValueLocation detailDisabledLoc = node.getSubValue(N_DETAIL_PAGES_DISABLED);
        if (detailDisabledLoc != null) {
            String detailPagesDisabledStr = detailDisabledLoc.asString(this.m_cms);
            detailPagesDisabled = Boolean.parseBoolean(detailPagesDisabledStr);
        }
        int order = 10000;
        I_CmsXmlContentValueLocation orderLoc = node.getSubValue(N_ORDER);
        if (orderLoc != null) {
            try {
                String orderStr = orderLoc.asString(this.m_cms);
                order = Integer.parseInt(orderStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ArrayList<CmsFormatterBean> formatters = new ArrayList<CmsFormatterBean>();
        for (I_CmsXmlContentValueLocation formatterLoc : node.getSubValues(N_FORMATTER)) {
            CmsFormatterBean formatter = this.parseFormatter(typeName, formatterLoc);
            formatters.add(formatter);
        }
        CmsFormatterConfiguration formatterConfig = CmsFormatterConfiguration.create(this.m_cms, formatters);
        CmsResourceTypeConfig typeConfig = new CmsResourceTypeConfig(typeName, disabled, folderOrName, namePattern, formatterConfig, detailPagesDisabled, order);
        this.m_resourceTypeConfigs.add(typeConfig);
    }

    public CmsADEConfigData parseSitemapConfiguration(String basePath, CmsResource configRes) throws CmsException {
        LOG.info((Object)("Parsing configuration " + configRes.getRootPath()));
        CmsFile configFile = this.m_cms.readFile(configRes);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, configFile);
        return this.parseConfiguration(basePath, content);
    }

    public CmsADEConfigData readModuleConfigurations() {
        ArrayList<CmsADEConfigData> configurations = new ArrayList<CmsADEConfigData>();
        List<CmsModule> modules = OpenCms.getModuleManager().getAllInstalledModules();
        for (CmsModule module : modules) {
            String configPath = module.getConfigurationPath();
            try {
                CmsResource configFile = this.m_cms.readResource(configPath);
                LOG.info((Object)("Found module configuration " + configPath + " for module " + module.getName()));
                CmsADEConfigData config = this.parseSitemapConfiguration(null, configFile);
                configurations.add(config);
            }
            catch (CmsVfsResourceNotFoundException e) {
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsRuntimeException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
        return this.mergeConfigurations(configurations);
    }

    protected boolean getBoolean(I_CmsXmlContentLocation parent, String name) {
        I_CmsXmlContentValueLocation location = parent.getSubValue(name);
        if (location == null) {
            return false;
        }
        String value = location.getValue().getStringValue(this.m_cms);
        return Boolean.parseBoolean(value);
    }

    protected String getString(I_CmsXmlContentValueLocation location) {
        if (location == null) {
            return null;
        }
        return location.asString(this.m_cms);
    }

    protected CmsADEConfigData mergeConfigurations(List<CmsADEConfigData> configurations) {
        if (configurations.isEmpty()) {
            return new CmsADEConfigData();
        }
        for (int i = 0; i < configurations.size() - 1; ++i) {
            configurations.get(i + 1).mergeParent(configurations.get(i));
        }
        CmsADEConfigData result = configurations.get(configurations.size() - 1);
        result.processModuleOrdering();
        return result;
    }

    protected void parseDetailPage(I_CmsXmlContentLocation node) throws CmsException {
        I_CmsXmlContentValueLocation pageLoc = node.getSubValue(N_PAGE);
        String page = pageLoc.asString(this.m_cms);
        CmsResource detailPageRes = this.m_cms.readResource(page);
        CmsUUID id = detailPageRes.getStructureId();
        String typeName = this.getString(node.getSubValue(N_TYPE));
        CmsDetailPageInfo detailPage = new CmsDetailPageInfo(id, page, typeName);
        this.m_detailPageConfigs.add(detailPage);
    }

    protected void parseFunctionReference(I_CmsXmlContentLocation node) {
        String name = node.getSubValue(N_NAME).asString(this.m_cms);
        CmsUUID functionId = node.getSubValue(N_FUNCTION).asId(this.m_cms);
        I_CmsXmlContentValueLocation orderNode = node.getSubValue(N_ORDER);
        int order = 10000;
        if (orderNode != null) {
            String orderStr = orderNode.asString(this.m_cms);
            try {
                order = Integer.parseInt(orderStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.m_functionReferences.add(new CmsFunctionReference(name, functionId, order));
    }

    private void parseProperty(I_CmsXmlContentLocation field) {
        String name = this.getString(field.getSubValue(N_PROPERTY_NAME));
        String widget = this.getString(field.getSubValue(N_WIDGET));
        String widgetConfig = this.getString(field.getSubValue(N_WIDGET_CONFIG));
        String ruleRegex = this.getString(field.getSubValue(N_RULE_REGEX));
        String ruleType = this.getString(field.getSubValue(N_RULE_TYPE));
        String default1 = this.getString(field.getSubValue(N_DEFAULT));
        String error = this.getString(field.getSubValue(N_ERROR));
        String niceName = this.getString(field.getSubValue(N_DISPLAY_NAME));
        String description = this.getString(field.getSubValue(N_DESCRIPTION));
        String preferFolder = this.getString(field.getSubValue(N_PREFER_FOLDER));
        String disabledStr = this.getString(field.getSubValue(N_DISABLED));
        boolean disabled = disabledStr != null && Boolean.parseBoolean(disabledStr);
        String orderStr = this.getString(field.getSubValue(N_ORDER));
        int order = 10000;
        try {
            order = Integer.parseInt(orderStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        CmsXmlContentProperty prop = new CmsXmlContentProperty(name, "string", widget, widgetConfig, ruleRegex, ruleType, default1, niceName, description, error, preferFolder);
        CmsPropertyConfig propConfig = new CmsPropertyConfig(prop, disabled, order);
        this.m_propertyConfigs.add(propConfig);
    }
}

