/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;

public class CmsGlobalConfigurationCacheEventHandler
implements I_CmsEventListener {
    private static final Log LOG = CmsLog.getLog(CmsGlobalConfigurationCacheEventHandler.class);
    private List<CachePair> m_caches = new ArrayList<CachePair>();
    private CmsObject m_onlineCms;

    public CmsGlobalConfigurationCacheEventHandler(CmsObject onlineCms) {
        this.m_onlineCms = onlineCms;
    }

    public void addCache(I_CmsGlobalConfigurationCache offlineCache, I_CmsGlobalConfigurationCache onlineCache, String debugName) {
        CachePair cachePair = new CachePair(offlineCache, onlineCache, debugName);
        this.m_caches.add(cachePair);
    }

    public void cmsEvent(CmsEvent event) {
        CmsResource resource = null;
        List<CmsResource> resources = null;
        switch (event.getType()) {
            case 11: 
            case 15: 
            case 23: {
                Object change = event.getData().get("change");
                if (change != null && change.equals(new Integer(0))) {
                    return;
                }
                resource = (CmsResource)event.getData().get("resource");
                this.offlineCacheUpdate(resource);
                break;
            }
            case 27: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                for (CmsResource res : resources) {
                    this.offlineCacheUpdate(res);
                }
                break;
            }
            case 22: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                this.offlineCacheRemove(resources.get(0));
                this.offlineCacheUpdate(resources.get(resources.size() - 2));
                break;
            }
            case 25: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                for (CmsResource res : resources) {
                    this.offlineCacheRemove(res);
                }
                break;
            }
            case 12: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                for (CmsResource res : resources) {
                    this.offlineCacheUpdate(res);
                }
                break;
            }
            case 17: {
                this.onlineCacheClear();
                break;
            }
            case 2: {
                String publishIdStr = (String)event.getData().get("publishHistoryId");
                if (publishIdStr == null) break;
                CmsUUID publishId = new CmsUUID(publishIdStr);
                try {
                    List<CmsPublishedResource> publishedResources = this.m_onlineCms.readPublishedResources(publishId);
                    if (publishedResources.isEmpty()) {
                        this.onlineCacheClear();
                        break;
                    }
                    for (CmsPublishedResource res : publishedResources) {
                        if (res.getState().isDeleted()) {
                            this.onlineCacheRemove(res);
                            continue;
                        }
                        this.onlineCacheUpdate(res);
                    }
                    break;
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    break;
                }
            }
            case 5: {
                this.offlineCacheClear();
                this.onlineCacheClear();
                break;
            }
            case 16: {
                this.offlineCacheClear();
                break;
            }
        }
    }

    protected void offlineCacheClear() {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOfflineCache().clear();
            }
            catch (Throwable t) {
                LOG.error((Object)t.getLocalizedMessage(), t);
            }
        }
    }

    protected void offlineCacheRemove(CmsPublishedResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOfflineCache().remove(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    protected void offlineCacheRemove(CmsResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOfflineCache().remove(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    protected void offlineCacheUpdate(CmsPublishedResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOfflineCache().update(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    protected void offlineCacheUpdate(CmsResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOfflineCache().update(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    protected void onlineCacheClear() {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOnlineCache().clear();
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    protected void onlineCacheRemove(CmsPublishedResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOnlineCache().remove(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    protected void onlineCacheRemove(CmsResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOnlineCache().remove(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    protected void onlineCacheUpdate(CmsPublishedResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOnlineCache().update(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    protected void onlineCacheUpdate(CmsResource resource) {
        for (CachePair cachePair : this.m_caches) {
            try {
                cachePair.getOnlineCache().update(resource);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
    }

    private class CachePair {
        private String m_debugName;
        private I_CmsGlobalConfigurationCache m_offlineCache;
        private I_CmsGlobalConfigurationCache m_onlineCache;

        public CachePair(I_CmsGlobalConfigurationCache offlineCache, I_CmsGlobalConfigurationCache onlineCache, String debugName) {
            this.m_offlineCache = offlineCache;
            this.m_onlineCache = onlineCache;
            this.m_debugName = debugName;
        }

        public I_CmsGlobalConfigurationCache getOfflineCache() {
            return this.m_offlineCache;
        }

        public I_CmsGlobalConfigurationCache getOnlineCache() {
            return this.m_onlineCache;
        }
    }
}

