/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.Messages;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReferenceParser;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsContainerElementData;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.jsp.CmsJspTagHeadIncludes;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.editors.directedit.CmsAdvancedDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsElementUtil {
    private static final Log LOG = CmsLog.getLog(CmsElementUtil.class);
    private CmsObject m_cms;
    private String m_currentPageUri;
    private Locale m_locale;
    private Map<String, Object> m_parameterMap;
    private HttpServletRequest m_req;
    private HttpServletResponse m_res;
    private CmsJspStandardContextBean m_standardContext;

    public CmsElementUtil(CmsObject cms, String currentPageUri, HttpServletRequest req, HttpServletResponse res, Locale locale) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_req = req;
        this.m_res = res;
        this.m_currentPageUri = currentPageUri;
        this.m_locale = locale;
        req.setAttribute("__cmsObject", (Object)this.m_cms);
        this.m_standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, this.m_cms.readResource(currentPageUri), (ServletRequest)req);
        CmsContainerPageBean containerPage = xmlContainerPage.getContainerPage(cms, this.m_locale);
        this.m_standardContext.setPage(containerPage);
    }

    public CmsElementUtil(CmsObject cms, String currentPageUri, String requestParameters, HttpServletRequest req, HttpServletResponse res, Locale locale) throws CmsException {
        this(cms, currentPageUri, req, res, locale);
        this.m_parameterMap = this.parseRequestParameters(requestParameters);
    }

    public Map<String, String> getContentsByContainerName(CmsContainerElementBean element, Collection<CmsContainer> containers) {
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_cms.addSiteRoot(this.m_currentPageUri));
        CmsFormatterConfiguration configs = adeConfig.getFormatters(this.m_cms, element.getResource());
        HashMap<String, String> result = new HashMap<String, String>();
        for (CmsContainer container : containers) {
            String name = container.getName();
            CmsFormatterBean formatter = configs.getFormatter(container.getType(), container.getWidth());
            if (formatter == null) continue;
            String content = null;
            try {
                content = this.getElementContent(element, this.m_cms.readResource(formatter.getJspStructureId()), container);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (content == null) continue;
            content = this.removeScriptTags(content);
            result.put(name, content);
        }
        return result;
    }

    public CmsContainerElement setElementInfo(CmsContainerElementBean elementBean, CmsContainerElement result) throws CmsException {
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        String noEditReason = "";
        elementBean.initResource(this.m_cms);
        if (!elementBean.isInMemoryOnly()) {
            if (CmsResourceTypeXmlContent.isXmlContent(elementBean.getResource())) {
                noEditReason = new CmsResourceUtil(this.m_cms, elementBean.getResource()).getNoEditReason(wpLocale, true);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(noEditReason) && elementBean.isInheritedContainer(this.m_cms)) {
                    String requestUri = this.m_cms.getRequestContext().getUri();
                    String folderPath = CmsResource.getFolderPath(requestUri);
                    String configPath = CmsStringUtil.joinPaths(folderPath, ".inherited");
                    if (this.m_cms.existsResource(configPath)) {
                        noEditReason = new CmsResourceUtil(this.m_cms, this.m_cms.readResource(configPath)).getNoEditReason(wpLocale, true);
                    } else if (!this.m_cms.getLock(folderPath).isLockableBy(this.m_cms.getRequestContext().getCurrentUser())) {
                        noEditReason = org.opencms.workplace.explorer.Messages.get().getBundle(wpLocale).key("GUI_NO_EDIT_REASON_LOCK_1", new CmsResourceUtil(this.m_cms, this.m_cms.readResource(folderPath)).getLockedByName());
                    }
                } else {
                    noEditReason = new CmsResourceUtil(this.m_cms, elementBean.getResource()).getNoEditReason(wpLocale, true);
                }
            } else {
                noEditReason = Messages.get().getBundle().key("GUI_ELEMENT_RESOURCE_CAN_NOT_BE_EDITED_0");
            }
        }
        result.setClientId(elementBean.editorHash());
        result.setSitePath(elementBean.getSitePath());
        String typeName = OpenCms.getResourceManager().getResourceType(elementBean.getResource().getTypeId()).getTypeName();
        result.setResourceType(typeName);
        result.setNew(elementBean.isCreateNew());
        if (elementBean.isCreateNew()) {
            CmsResourceTypeConfig typeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_cms.addSiteRoot(this.m_currentPageUri)).getResourceType(typeName);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(noEditReason) && (typeConfig == null || !typeConfig.checkCreatable(this.m_cms))) {
                String niceName = CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName);
                noEditReason = Messages.get().getBundle().key("GUI_CONTAINERPAGE_TYPE_NOT_CREATABLE_1", niceName);
            }
        }
        result.setHasSettings(this.hasSettings(this.m_cms, elementBean.getResource()));
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
        result.setViewPermission(elementBean.isInMemoryOnly() || this.m_cms.hasPermissions(elementBean.getResource(), CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.IGNORE_EXPIRATION) && settings.getAccess().getPermissions(this.m_cms, elementBean.getResource()).requiresViewPermission());
        result.setReleasedAndNotExpired(elementBean.isReleasedAndNotExpired());
        result.setNoEditReason(noEditReason);
        return result;
    }

    private boolean hasSettings(CmsObject cms, CmsResource resource) throws CmsException {
        if (!CmsResourceTypeXmlContent.isXmlContent(resource)) {
            return false;
        }
        Map<String, CmsXmlContentProperty> propConfig = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource).getSettings(cms, resource);
        return !propConfig.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmsContainerElementData getElementData(CmsContainerElementBean element, Collection<CmsContainer> containers) throws CmsException {
        Locale requestLocale = this.m_cms.getRequestContext().getLocale();
        this.m_cms.getRequestContext().setLocale(this.m_locale);
        element.initResource(this.m_cms);
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, element.getResource());
        CmsUUID structureId = resUtil.getResource().getStructureId();
        CmsContainerElementData elementBean = new CmsContainerElementData();
        this.setElementInfo(element, elementBean);
        elementBean.setLastModifiedDate(element.getResource().getDateLastModified());
        elementBean.setLastModifiedByUser(this.m_cms.readUser(element.getResource().getUserLastModified()).getName());
        elementBean.setNavText(resUtil.getNavText());
        String title = resUtil.getTitle();
        if (!structureId.isNullUUID()) {
            CmsGallerySearchResult searchResult = CmsGallerySearch.searchById(this.m_cms, structureId, requestLocale);
            title = searchResult.getTitle();
        }
        elementBean.setTitle(title);
        LinkedHashSet<String> cssResources = new LinkedHashSet<String>();
        for (String cssSitePath : CmsJspTagHeadIncludes.getCSSHeadIncludes(this.m_cms, element.getResource())) {
            cssResources.add(OpenCms.getLinkManager().getOnlineLink(this.m_cms, cssSitePath));
        }
        elementBean.setCssResources(cssResources);
        Map<String, CmsXmlContentProperty> settingConfig = CmsXmlContentPropertyHelper.getPropertyInfo(this.m_cms, element.getResource());
        elementBean.setSettings(CmsXmlContentPropertyHelper.convertPropertiesToClientFormat(this.m_cms, element.getIndividualSettings(), settingConfig));
        elementBean.setSettingConfig(new LinkedHashMap<String, CmsXmlContentProperty>(settingConfig));
        HashMap<String, String> contents = new HashMap();
        if (element.isGroupContainer(this.m_cms)) {
            HashSet<String> types = new HashSet<String>();
            HashMap<String, CmsContainer> containersByName = new HashMap<String, CmsContainer>();
            for (CmsContainer container : containers) {
                types.add(container.getType());
                containersByName.put(container.getName(), container);
            }
            CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(this.m_cms, element.getResource(), (ServletRequest)this.m_req);
            CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(this.m_cms, this.m_locale);
            elementBean.setTitle(groupContainer.getTitle());
            elementBean.setTypes(groupContainer.getTypes());
            elementBean.setDescription(groupContainer.getDescription());
            if (groupContainer.getTypes().isEmpty()) {
                if (!groupContainer.getElements().isEmpty()) return null;
                String emptySub = "<div>NEW AND EMPTY</div>";
                for (String name : containersByName.keySet()) {
                    contents.put(name, emptySub);
                }
            } else {
                for (CmsContainer cnt : containersByName.values()) {
                    String type = cnt.getType();
                    if (!groupContainer.getTypes().contains(type)) continue;
                    contents.put(cnt.getName(), "<div>should not be used</div>");
                }
            }
            ArrayList<String> subItems = new ArrayList<String>();
            for (CmsContainerElementBean subElement : groupContainer.getElements()) {
                subItems.add(subElement.editorHash());
            }
            elementBean.setSubItems(subItems);
        } else if (element.isInheritedContainer(this.m_cms)) {
            CmsInheritanceReferenceParser parser = new CmsInheritanceReferenceParser(this.m_cms);
            parser.parse(element.getResource());
            CmsInheritanceReference ref = parser.getReferences().get(this.m_locale);
            String name = null;
            if (ref != null) {
                name = ref.getName();
                elementBean.setDescription(ref.getDescription());
                elementBean.setTitle(ref.getTitle());
            }
            for (CmsContainer container : containers) {
                contents.put(container.getName(), "<div>should not be used</div>");
            }
            ArrayList<CmsInheritanceInfo> inheritanceInfos = new ArrayList<CmsInheritanceInfo>();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) {
                CmsInheritedContainerState result = OpenCms.getADEManager().getInheritedContainerState(this.m_cms, this.m_cms.addSiteRoot(this.m_currentPageUri), name);
                for (CmsContainerElementBean subElement : result.getElements(true)) {
                    CmsInheritanceInfo inheritanceInfo = subElement.getInheritanceInfo();
                    inheritanceInfo.setClientId(subElement.editorHash());
                    inheritanceInfos.add(inheritanceInfo);
                }
            } else {
                name = new CmsUUID().toString();
            }
            elementBean.setInheritanceInfos(inheritanceInfos);
            elementBean.setInheritanceName(name);
        } else {
            Map<String, String> contentsByName = this.getContentsByContainerName(element, containers);
            contents = contentsByName;
        }
        elementBean.setContents(contents);
        this.m_cms.getRequestContext().setLocale(requestLocale);
        return elementBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getElementContent(CmsContainerElementBean element, CmsResource formatter, CmsContainer container) throws CmsException, ServletException, IOException {
        element.initResource(this.m_cms);
        CmsTemplateLoaderFacade loaderFacade = new CmsTemplateLoaderFacade(OpenCms.getResourceManager().getLoader(formatter), element.getResource(), formatter);
        CmsResource loaderRes = loaderFacade.getLoaderStartResource();
        String oldUri = this.m_cms.getRequestContext().getUri();
        try {
            this.m_cms.getRequestContext().setUri(this.m_currentPageUri);
            CmsContainerBean containerBean = null;
            containerBean = this.m_standardContext.getPage() != null && this.m_standardContext.getPage().getContainers().containsKey(container.getName()) ? this.m_standardContext.getPage().getContainers().get(container.getName()) : new CmsContainerBean(container.getName(), container.getType(), container.getMaxElements(), Collections.<CmsContainerElementBean>emptyList());
            if (containerBean.getWidth() == null) {
                containerBean.setWidth(String.valueOf(container.getWidth()));
            }
            this.m_standardContext.setContainer(containerBean);
            this.m_standardContext.setElement(element);
            this.m_standardContext.setEdited(true);
            CmsAdvancedDirectEditProvider eb = new CmsAdvancedDirectEditProvider();
            eb.init(this.m_cms, CmsDirectEditMode.TRUE, element.getSitePath());
            this.m_req.setAttribute("org.opencms.workplace.editors.directedit.__directEditProvider", (Object)eb);
            String encoding = this.m_res.getCharacterEncoding();
            String string = new String(loaderFacade.getLoader().dump(this.m_cms, loaderRes, null, this.m_locale, this.m_req, this.m_res), encoding).trim();
            return string;
        }
        finally {
            this.m_cms.getRequestContext().setUri(oldUri);
        }
    }

    private Map<String, Object> parseRequestParameters(String requestParameters) {
        Map<String, Object> parameterMap;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(requestParameters)) {
            parameterMap = new HashMap();
            String[] params = requestParameters.split("&");
            for (int i = 0; i < params.length; ++i) {
                int position = params[i].indexOf("=");
                if (position < 0) continue;
                String key = params[i].substring(0, position);
                String value = params[i].substring(position + 1);
                if (value.contains(",")) {
                    parameterMap.put(key, value.split(","));
                    continue;
                }
                parameterMap.put(key, value);
            }
        } else {
            parameterMap = Collections.emptyMap();
        }
        return parameterMap;
    }

    private String removeScriptTags(String input) {
        Pattern removePattern = Pattern.compile("<script[^>]*?>[\\s\\S]*?<\\/script>");
        Matcher match = removePattern.matcher(input);
        return match.replaceAll("");
    }
}

