/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opencms.xml.containerpage.CmsContainerElementBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsContainerConfiguration {
    public static final String N_CONFIGURATION = "Configuration";
    public static final String N_ELEMENT = "Element";
    public static final String N_HIDDEN = "Hidden";
    public static final String N_KEY = "Key";
    public static final String N_NAME = "Name";
    public static final String N_NEWELEMENT = "NewElement";
    public static final String N_ORDERKEY = "OrderKey";
    public static final String N_URI = "Uri";
    public static final String N_VISIBLE = "Visible";
    private Map<String, CmsContainerElementBean> m_newElements;
    private List<String> m_ordering;
    private String m_path;
    private Map<String, Boolean> m_visibility;

    public CmsContainerConfiguration(List<String> ordering, Map<String, Boolean> visibility, Map<String, CmsContainerElementBean> newElements) {
        this.m_ordering = ordering != null ? Collections.unmodifiableList(ordering) : null;
        this.m_visibility = Collections.unmodifiableMap(visibility);
        this.m_newElements = Collections.unmodifiableMap(newElements);
    }

    public static CmsContainerConfiguration emptyConfiguration() {
        return new CmsContainerConfiguration(null, new HashMap<String, Boolean>(), new HashMap<String, CmsContainerElementBean>());
    }

    public Map<String, CmsContainerElementBean> getNewElements() {
        return this.m_newElements;
    }

    public LinkedHashMap<String, CmsContainerElementBean> getNewElementsInOrder() {
        LinkedHashMap<String, CmsContainerElementBean> result = new LinkedHashMap<String, CmsContainerElementBean>();
        if (this.m_ordering != null) {
            for (String orderKey : this.m_ordering) {
                CmsContainerElementBean element = this.m_newElements.get(orderKey);
                if (element == null) continue;
                result.put(orderKey, element);
            }
            return result;
        }
        return new LinkedHashMap<String, CmsContainerElementBean>();
    }

    public List<String> getOrdering() {
        return this.m_ordering;
    }

    public String getPath() {
        return this.m_path;
    }

    public Map<String, Boolean> getVisibility() {
        return this.m_visibility;
    }

    public void setPath(String path) {
        this.m_path = path;
    }
}

