/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.containerpage.inherited.CmsContainerConfiguration;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationParser;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.gwt.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.xml.containerpage.CmsContainerElementBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsInheritanceGroupUtils {
    private CmsInheritanceGroupUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsResource getInheritanceGroupContentByName(CmsObject cms, String name) throws CmsException {
        String oldSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("");
            List<CmsResource> resources = cms.readResourcesWithProperty("/", "Keywords", name);
            Iterator<CmsResource> resourceIter = resources.iterator();
            while (resourceIter.hasNext()) {
                CmsResource currentRes = resourceIter.next();
                if (OpenCms.getResourceManager().getResourceType(currentRes).getTypeName().equals("inheritance_group")) continue;
                resourceIter.remove();
            }
            if (resources.isEmpty()) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_INHERITANCE_GROUP_NOT_FOUND_1", name));
            }
            CmsResource cmsResource = resources.get(0);
            return cmsResource;
        }
        finally {
            cms.getRequestContext().setSiteRoot(oldSiteRoot);
        }
    }

    public static Set<String> getNamesOfGroupsContainingResource(CmsObject cms, CmsResource inheritanceConfig, CmsResource target) throws CmsException {
        HashSet<String> names = new HashSet<String>();
        CmsContainerConfigurationParser parser = new CmsContainerConfigurationParser(cms);
        parser.parse(inheritanceConfig);
        Map<Locale, Map<String, CmsContainerConfiguration>> contents = parser.getParsedResults();
        for (Map<String, CmsContainerConfiguration> mapForLocale : contents.values()) {
            for (Map.Entry<String, CmsContainerConfiguration> entry : mapForLocale.entrySet()) {
                String key = entry.getKey();
                CmsContainerConfiguration config = entry.getValue();
                for (CmsContainerElementBean element : config.getNewElements().values()) {
                    if (!element.getId().equals(target.getStructureId())) continue;
                    names.add(key);
                }
            }
        }
        return names;
    }
}

