/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsInheritanceReferenceParser {
    private CmsObject m_cms;
    private Map<Locale, CmsInheritanceReference> m_references = new HashMap<Locale, CmsInheritanceReference>();
    private CmsResource m_resource;

    public CmsInheritanceReferenceParser(CmsObject cms) {
        this.m_cms = cms;
    }

    public Map<Locale, CmsInheritanceReference> getReferences() {
        return Collections.unmodifiableMap(this.m_references);
    }

    public void parse(CmsResource resource) throws CmsException {
        CmsFile file = this.m_cms.readFile(resource);
        this.m_resource = resource;
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, file);
        this.parse(content);
    }

    protected void parse(CmsXmlContent content) {
        List<Locale> availableLocales = content.getLocales();
        for (Locale locale : availableLocales) {
            CmsXmlContentRootLocation location = new CmsXmlContentRootLocation(content, locale);
            CmsInheritanceReference ref = this.parseReference(location, locale);
            if (ref == null) continue;
            this.m_references.put(locale, ref);
        }
    }

    protected CmsInheritanceReference parseReference(I_CmsXmlContentLocation location, Locale locale) {
        I_CmsXmlContentValueLocation nameLocation = location.getSubValue("ConfigName");
        if (nameLocation == null) {
            return null;
        }
        String configName = nameLocation.asString(this.m_cms);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(configName)) {
            return null;
        }
        configName = configName.trim();
        I_CmsXmlContentValueLocation titleLocation = location.getSubValue("Title");
        String title = null;
        if (titleLocation != null) {
            title = titleLocation.asString(this.m_cms);
        }
        I_CmsXmlContentValueLocation descriptionLocation = location.getSubValue("Description");
        String description = null;
        if (descriptionLocation != null) {
            description = descriptionLocation.asString(this.m_cms);
        }
        return new CmsInheritanceReference(configName, title, description, this.m_resource, locale);
    }
}

