/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.contenteditor.ClientMessages;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.ade.contenteditor.shared.CmsContentDefinition;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.ade.contenteditor.shared.rpc.I_CmsContentService;
import org.opencms.ade.galleries.CmsGalleryActionElement;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.util.CmsStringUtil;

public class CmsContentEditorActionElement
extends CmsGwtActionElement {
    public static final String MODULE_NAME = "contenteditor";

    public CmsContentEditorActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public String export() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(ClientMessages.get().export(this.getRequest()));
        this.wrapScript(sb);
        return sb.toString();
    }

    public String exportAll() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPrefetch());
        sb.append(super.export());
        sb.append(new CmsGalleryActionElement(null, this.getRequest(), null).exportWidget());
        sb.append(this.export());
        sb.append(this.createNoCacheScript(MODULE_NAME));
        return sb.toString();
    }

    private String getPrefetch() throws Exception {
        CmsContentDefinition definition = CmsContentService.newInstance(this.getRequest()).prefetch();
        StringBuffer sb = new StringBuffer();
        String prefetchedData = CmsContentEditorActionElement.serializeForJavascript(I_CmsContentService.class.getMethod("prefetch", new Class[0]), (Object)definition);
        sb.append("com_alkacon_acacia_shared_ContentDefinition").append("='").append(prefetchedData).append("';\n");
        String backlink = this.getRequest().getParameter("backlink");
        backlink = CmsStringUtil.isEmptyOrWhitespaceOnly(backlink) ? this.link("/system/workplace/views/workplace.jsp") : this.link(backlink);
        sb.append("backlink").append("='").append(backlink).append("';\n");
        this.wrapScript(sb);
        this.addExternalResourceTags(sb, definition);
        return sb.toString();
    }

    private void addExternalResourceTags(StringBuffer sb, CmsContentDefinition definition) {
        HashSet<String> includedScripts = new HashSet<String>();
        HashSet<String> includedStyles = new HashSet<String>();
        for (CmsExternalWidgetConfiguration configuration : definition.getExternalWidgetConfigurations()) {
            for (String css : configuration.getCssResourceLinks()) {
                if (includedStyles.contains(css)) continue;
                sb.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(css).append("\"></link>");
                includedStyles.add(css);
            }
            for (String script : configuration.getJavaScriptResourceLinks()) {
                if (includedScripts.contains(script)) continue;
                sb.append("<script type=\"text/javascript\" src=\"").append(script).append("\"></script>");
                includedScripts.add(script);
            }
        }
    }
}

