/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import com.alkacon.acacia.shared.AttributeConfiguration;
import com.alkacon.acacia.shared.ContentDefinition;
import com.alkacon.acacia.shared.Entity;
import com.alkacon.acacia.shared.TabInfo;
import com.alkacon.acacia.shared.Type;
import com.alkacon.acacia.shared.ValidationResult;
import com.alkacon.vie.shared.I_Entity;
import com.alkacon.vie.shared.I_EntityAttribute;
import com.alkacon.vie.shared.I_Type;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.contenteditor.shared.CmsContentDefinition;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.ade.contenteditor.shared.rpc.I_CmsContentService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.explorer.CmsNewResourceXmlContent;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentTab;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsContentService
extends CmsGwtService
implements I_CmsContentService {
    protected static final Log LOG = CmsLog.getLog(CmsContentService.class);
    private static final long serialVersionUID = 7873052619331296648L;
    private static final String TYPE_NAME_PREFIX = "http://opencms.org/types/";
    private Locale m_workplaceLocale;

    public static String getAttributeName(I_CmsXmlContentValue contentValue) {
        return CmsContentService.getTypeUri(contentValue.getContentDefinition()) + "/" + contentValue.getName();
    }

    public static String getEntityId(I_CmsXmlContentValue contentValue) {
        String result = CmsContentDefinition.uuidToEntityId(contentValue.getDocument().getFile().getStructureId(), contentValue.getLocale().toString());
        String valuePath = contentValue.getPath();
        if (valuePath.contains("/")) {
            result = result + "/" + valuePath.substring(0, valuePath.lastIndexOf("/"));
        }
        return result;
    }

    public static String getTypeUri(CmsXmlContentDefinition xmlContentDefinition) {
        return xmlContentDefinition.getSchemaLocation() + "/" + xmlContentDefinition.getTypeName();
    }

    public static CmsContentService newInstance(HttpServletRequest request) {
        CmsContentService srv = new CmsContentService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        return srv;
    }

    public ContentDefinition loadContentDefinition(String entityId) throws CmsRpcException {
        return this.loadDefinition(entityId);
    }

    @Override
    public CmsContentDefinition loadDefinition(String entityId) throws CmsRpcException {
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            definition = this.readContentDefinition(resource, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), contentLocale, false);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition loadDefinition(String entityId, String newLink, CmsUUID modelFileId) throws CmsRpcException {
        CmsContentDefinition result = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(newLink)) {
            try {
                CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
                CmsResource resource = this.getCmsObject().readResource(structureId);
                Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                result = this.readContentDefnitionForNew(newLink, resource, modelFileId, contentLocale);
            }
            catch (Throwable t) {
                this.error(t);
            }
        } else {
            result = this.loadDefinition(entityId);
        }
        return result;
    }

    @Override
    public CmsContentDefinition loadNewDefinition(String entityId) throws CmsRpcException {
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            definition = this.readContentDefinition(resource, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), contentLocale, true);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition prefetch() throws CmsRpcException {
        String paramResource = this.getRequest().getParameter("resource");
        String paramNewLink = this.getRequest().getParameter("newlink");
        String paramLocale = this.getRequest().getParameter("elementlanguage");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramResource)) {
            try {
                CmsResource resource = this.getCmsObject().readResource(paramResource);
                if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
                    Locale locale = CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramLocale) ? CmsLocaleManager.getLocale(paramLocale) : OpenCms.getLocaleManager().getDefaultLocale(this.getCmsObject(), paramResource);
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramNewLink)) {
                        return this.readContentDefnitionForNew(paramNewLink, resource, null, locale);
                    }
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramResource)) {
                        return this.readContentDefinition(resource, null, locale, false);
                    }
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public ValidationResult saveAndDeleteEntities(List<Entity> changedEntities, List<String> deletedEntities, boolean clearOnSuccess) throws CmsRpcException {
        CmsUUID structureId = null;
        if (!changedEntities.isEmpty()) {
            structureId = CmsContentDefinition.entityIdToUuid(changedEntities.get(0).getId());
        }
        if (structureId == null && !deletedEntities.isEmpty()) {
            structureId = CmsContentDefinition.entityIdToUuid(deletedEntities.get(0));
        }
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = null;
            try {
                resource = cms.readResource(structureId);
                this.ensureLock(resource);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                this.checkAutoCorrection(cms, content);
                for (Entity entity : changedEntities) {
                    String entityId = entity.getId();
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                    if (content.hasLocale(contentLocale)) {
                        content.removeLocale(contentLocale);
                    }
                    content.addLocale(cms, contentLocale);
                    this.addEntityAttributes(cms, content, "", (I_Entity)entity, contentLocale);
                }
                for (String deleteId : deletedEntities) {
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(deleteId));
                    if (!content.hasLocale(contentLocale)) continue;
                    content.removeLocale(contentLocale);
                }
                ValidationResult validationResult = this.validateContent(cms, structureId, content);
                if (validationResult.hasErrors()) {
                    return validationResult;
                }
                this.writeContent(cms, file, content, this.getFileEncoding(cms, file));
                if (clearOnSuccess) {
                    this.tryUnlock(resource);
                }
            }
            catch (Exception e) {
                if (resource != null) {
                    this.tryUnlock(resource);
                }
                this.error(e);
            }
        }
        return null;
    }

    public ValidationResult saveEntities(List<Entity> entities) throws CmsRpcException {
        return this.saveAndDeleteEntities(entities, Collections.<String>emptyList(), true);
    }

    public ValidationResult saveEntity(Entity entity) throws CmsRpcException {
        return this.saveEntities(Collections.singletonList(entity));
    }

    public ValidationResult validateEntities(List<Entity> changedEntities) throws CmsRpcException {
        CmsUUID structureId = null;
        if (changedEntities.isEmpty()) {
            return new ValidationResult(null, null);
        }
        structureId = CmsContentDefinition.entityIdToUuid(changedEntities.get(0).getId());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            try {
                CmsResource resource = cms.readResource(structureId);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                for (Entity entity : changedEntities) {
                    String entityId = entity.getId();
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                    if (content.hasLocale(contentLocale)) {
                        content.removeLocale(contentLocale);
                    }
                    content.addLocale(cms, contentLocale);
                    this.addEntityAttributes(cms, content, "", (I_Entity)entity, contentLocale);
                }
                return this.validateContent(cms, structureId, content);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return new ValidationResult(null, null);
    }

    protected String getAttributeName(String elementName, String parentType) {
        return parentType + "/" + elementName;
    }

    protected String getElementName(String attributeName) {
        if (attributeName.contains("/")) {
            return attributeName.substring(attributeName.lastIndexOf("/") + 1);
        }
        return attributeName;
    }

    protected String getFileEncoding(CmsObject cms, CmsResource file) {
        String result;
        try {
            result = cms.readPropertyObject(file, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (CmsException e) {
            result = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        return CmsEncoder.lookupEncoding(result, OpenCms.getSystemInfo().getDefaultEncoding());
    }

    protected Entity readEntity(CmsXmlContent content, Element element, Locale locale, String entityId, String parentPath, String typeName, Map<String, I_Type> registeredTypes) {
        Entity newEntity;
        String newEntityId = entityId + (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath) ? "/" + parentPath : "");
        Entity result = newEntity = new Entity(newEntityId, typeName);
        List elements = element.elements();
        I_Type type = registeredTypes.get(typeName);
        boolean isChoice = type.isChoice();
        String choiceTypeName = null;
        HashMap<String, Integer> attributeCounter = null;
        if (isChoice) {
            choiceTypeName = type.getAttributeTypeName("ATTRIBUTE_CHOICE");
            type = registeredTypes.get(type.getAttributeTypeName("ATTRIBUTE_CHOICE"));
            attributeCounter = new HashMap<String, Integer>();
        }
        int counter = 0;
        CmsObject cms = this.getCmsObject();
        String previousName = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath)) {
            parentPath = parentPath + "/";
        }
        for (Element child : elements) {
            String attributeName = this.getAttributeName(child.getName(), typeName);
            String subTypeName = type.getAttributeTypeName(attributeName);
            if (registeredTypes.get(subTypeName) == null) continue;
            if (isChoice && attributeCounter != null) {
                if (!attributeName.equals(previousName)) {
                    counter = attributeCounter.get(attributeName) != null ? (Integer)attributeCounter.get(attributeName) : 0;
                    previousName = attributeName;
                }
                attributeCounter.put(attributeName, counter + 1);
            } else if (!attributeName.equals(previousName)) {
                counter = 0;
                previousName = attributeName;
            }
            if (isChoice) {
                result = new Entity(newEntityId + "/" + "ATTRIBUTE_CHOICE" + "_" + child.getName() + "[" + counter + "]", choiceTypeName);
                newEntity.addAttributeValue("ATTRIBUTE_CHOICE", (I_Entity)result);
            }
            String path = parentPath + child.getName();
            if (registeredTypes.get(subTypeName).isSimpleType()) {
                I_CmsXmlContentValue value = content.getValue(path, locale, counter);
                result.addAttributeValue(attributeName, value.getStringValue(cms));
            } else {
                Entity subEntity = this.readEntity(content, child, locale, entityId, path + "[" + (counter + 1) + "]", subTypeName, registeredTypes);
                result.addAttributeValue(attributeName, (I_Entity)subEntity);
            }
            ++counter;
        }
        return newEntity;
    }

    protected Map<String, I_Type> readTypes(CmsXmlContentDefinition xmlContentDefinition, Locale locale) {
        TypeVisitor visitor = new TypeVisitor(null, locale);
        visitor.visitTypes(xmlContentDefinition, locale);
        return visitor.getTypes();
    }

    private void addEntityAttributes(CmsObject cms, CmsXmlContent content, String parentPath, I_Entity entity, Locale contentLocale) {
        for (I_EntityAttribute attribute : entity.getAttributes()) {
            I_CmsXmlContentValue field;
            int i;
            if ("ATTRIBUTE_CHOICE".equals(attribute.getAttributeName())) {
                List choiceEntities = attribute.getComplexValues();
                for (int i2 = 0; i2 < choiceEntities.size(); ++i2) {
                    I_CmsXmlContentValue field2;
                    List choiceAttributes = ((I_Entity)choiceEntities.get(i2)).getAttributes();
                    assert (choiceAttributes.size() == 1 && ((I_EntityAttribute)choiceAttributes.get(0)).isSingleValue()) : "each choice entity may only have a single attribute with a single value";
                    I_EntityAttribute choiceAttribute = (I_EntityAttribute)choiceAttributes.get(0);
                    String elementPath = parentPath + this.getElementName(choiceAttribute.getAttributeName());
                    if (choiceAttribute.isSimpleValue()) {
                        String value = choiceAttribute.getSimpleValue();
                        field2 = content.getValue(elementPath, contentLocale, i2);
                        if (field2 == null) {
                            field2 = content.addValue(cms, elementPath, contentLocale, i2);
                        }
                        field2.setStringValue(cms, value);
                        continue;
                    }
                    I_Entity child = choiceAttribute.getComplexValue();
                    field2 = content.getValue(elementPath, contentLocale, i2);
                    if (field2 == null) {
                        field2 = content.addValue(cms, elementPath, contentLocale, i2);
                    }
                    this.addEntityAttributes(cms, content, field2.getPath() + "/", child, contentLocale);
                }
                continue;
            }
            String elementPath = parentPath + this.getElementName(attribute.getAttributeName());
            if (attribute.isSimpleValue()) {
                List values = attribute.getSimpleValues();
                for (i = 0; i < values.size(); ++i) {
                    String value = (String)values.get(i);
                    field = content.getValue(elementPath, contentLocale, i);
                    if (field == null) {
                        field = content.addValue(cms, elementPath, contentLocale, i);
                    }
                    field.setStringValue(cms, value);
                }
                continue;
            }
            List entities = attribute.getComplexValues();
            for (i = 0; i < entities.size(); ++i) {
                I_Entity child = (I_Entity)entities.get(i);
                field = content.getValue(elementPath, contentLocale, i);
                if (field == null) {
                    field = content.addValue(cms, elementPath, contentLocale, i);
                }
                this.addEntityAttributes(cms, content, field.getPath() + "/", child, contentLocale);
            }
        }
    }

    private boolean checkAutoCorrection(CmsObject cms, CmsXmlContent content) throws CmsXmlException {
        boolean performedAutoCorrection = false;
        try {
            content.validateXmlStructure(new CmsXmlEntityResolver(cms));
        }
        catch (CmsXmlException eXml) {
            content.setAutoCorrectionEnabled(true);
            content.correctXmlStructure(cms);
            performedAutoCorrection = true;
        }
        return performedAutoCorrection;
    }

    private Locale getWorkplaceLocale(CmsObject cms) {
        if (this.m_workplaceLocale == null) {
            this.m_workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        }
        return this.m_workplaceLocale;
    }

    private CmsContentDefinition readContentDefinition(CmsResource resource, String entityId, Locale locale, boolean newLocale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(entityId)) {
            entityId = CmsContentDefinition.uuidToEntityId(resource.getStructureId(), locale.toString());
        }
        CmsFile file = cms.readFile(resource);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
        boolean performedAutoCorrection = this.checkAutoCorrection(cms, content);
        TypeVisitor visitor = new TypeVisitor(file, this.getWorkplaceLocale(cms));
        visitor.visitTypes(content.getContentDefinition(), this.getWorkplaceLocale(cms));
        Entity entity = null;
        if (content.hasLocale(locale) && newLocale) {
            content.removeLocale(locale);
        }
        if (!content.hasLocale(locale)) {
            content.addLocale(cms, locale);
        }
        Element element = content.getLocaleNode(locale);
        entity = this.readEntity(content, element, locale, entityId, "", CmsContentService.getTypeUri(content.getContentDefinition()), visitor.getTypes());
        ArrayList<String> contentLocales = new ArrayList<String>();
        for (Locale contentLocale : content.getLocales()) {
            contentLocales.add(contentLocale.toString());
        }
        Locale workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        TreeMap<String, String> availableLocales = new TreeMap<String, String>();
        for (Locale availableLocale : OpenCms.getLocaleManager().getAvailableLocales(cms, resource)) {
            availableLocales.put(availableLocale.toString(), availableLocale.getDisplayName(workplaceLocale));
        }
        String title = cms.readPropertyObject(resource, "Title", false).getValue();
        String typeName = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        return new CmsContentDefinition(entity, visitor.getAttributeConfigurations(), visitor.getWidgetConfigurations(), visitor.getTypes(), visitor.getTabInfos(), locale.toString(), contentLocales, availableLocales, title, cms.getSitePath(resource), typeName, performedAutoCorrection);
    }

    private CmsContentDefinition readContentDefnitionForNew(String newLink, CmsResource referenceResource, CmsUUID modelFileId, Locale locale) throws CmsException {
        String sitePath = this.getCmsObject().getSitePath(referenceResource);
        String resourceType = OpenCms.getResourceManager().getResourceType(referenceResource.getTypeId()).getTypeName();
        String modelFile = null;
        if (modelFileId == null) {
            List<CmsResource> modelResources = CmsNewResourceXmlContent.getModelFiles(this.getCmsObject(), CmsResource.getFolderPath(sitePath), resourceType);
            if (!modelResources.isEmpty()) {
                List<CmsModelResourceInfo> modelInfos = CmsContainerpageService.generateModelResourceList(this.getCmsObject(), resourceType, modelResources, locale);
                return new CmsContentDefinition(modelInfos, newLink, referenceResource.getStructureId(), locale.toString());
            }
        } else if (!modelFileId.isNullUUID()) {
            modelFile = this.getCmsObject().getSitePath(this.getCmsObject().readResource(modelFileId));
        }
        String newFileName = A_CmsResourceCollector.createResourceForCollector(this.getCmsObject(), newLink, locale, sitePath, modelFile);
        CmsResource resource = this.getCmsObject().readResource(newFileName);
        CmsContentDefinition contentDefinition = this.readContentDefinition(resource, null, locale, false);
        contentDefinition.setDeleteOnCancel(true);
        return contentDefinition;
    }

    private ValidationResult validateContent(CmsObject cms, CmsUUID structureId, CmsXmlContent content) {
        CmsXmlContentErrorHandler errorHandler = content.validate(cms);
        HashMap errorsByEntity = new HashMap();
        if (errorHandler.hasErrors()) {
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getErrors().entrySet()) {
                HashMap<String, String> errors = new HashMap<String, String>();
                for (Map.Entry<String, String> error : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(error.getKey(), localeEntry.getKey());
                    String typeUri = CmsContentService.getTypeUri(value.getContentDefinition());
                    String attributeName = this.getAttributeName(value.getName(), typeUri);
                    errors.put(attributeName + "[" + value.getXmlIndex() + "]", error.getValue());
                }
                errorsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), errors);
            }
        }
        HashMap warningsByEntity = new HashMap();
        if (errorHandler.hasWarnings()) {
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getWarnings().entrySet()) {
                HashMap<String, String> warnings = new HashMap<String, String>();
                for (Map.Entry<String, String> warning : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(warning.getKey(), localeEntry.getKey());
                    String typeUri = CmsContentService.getTypeUri(value.getContentDefinition());
                    String attributeName = this.getAttributeName(value.getName(), typeUri);
                    warnings.put(attributeName + "[" + value.getXmlIndex() + "]", warning.getValue());
                }
                warningsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), warnings);
            }
        }
        return new ValidationResult(errorsByEntity, warningsByEntity);
    }

    private CmsXmlContent writeContent(CmsObject cms, CmsFile file, CmsXmlContent content, String encoding) throws CmsException {
        String decodedContent = content.toString();
        try {
            file.setContents(decodedContent.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new CmsException(Messages.get().container("ERR_INVALID_CONTENT_ENC_1", file.getRootPath()), (Throwable)e);
        }
        file = cms.writeFile(file);
        return CmsXmlContentFactory.unmarshal(cms, file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TypeVisitor {
        private Map<String, AttributeConfiguration> m_attributeConfigurations;
        private I_CmsXmlContentHandler m_contentHandler;
        private CmsFile m_file;
        private Locale m_locale;
        private CmsMultiMessages m_messages;
        private Map<String, I_Type> m_registeredTypes;
        private List<TabInfo> m_tabInfos;
        private Map<String, CmsExternalWidgetConfiguration> m_widgetConfigurations;

        protected TypeVisitor(CmsFile file, Locale locale) {
            this.m_file = file;
            this.m_locale = locale;
        }

        public List<TabInfo> getTabInfos() {
            return this.m_tabInfos;
        }

        protected Map<String, AttributeConfiguration> getAttributeConfigurations() {
            return this.m_attributeConfigurations;
        }

        protected Map<String, I_Type> getTypes() {
            return this.m_registeredTypes;
        }

        protected Collection<CmsExternalWidgetConfiguration> getWidgetConfigurations() {
            return this.m_widgetConfigurations.values();
        }

        protected void visitTypes(CmsXmlContentDefinition xmlContentDefinition, Locale locale) {
            this.m_contentHandler = xmlContentDefinition.getContentHandler();
            CmsWorkplaceMessages messages = null;
            this.m_messages = new CmsMultiMessages(locale);
            try {
                messages = OpenCms.getWorkplaceManager().getMessages(locale);
                this.m_messages.addMessages(messages);
                this.m_messages.addMessages(this.m_contentHandler.getMessages(locale));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_attributeConfigurations = new HashMap<String, AttributeConfiguration>();
            this.m_widgetConfigurations = new HashMap<String, CmsExternalWidgetConfiguration>();
            this.m_registeredTypes = new HashMap<String, I_Type>();
            this.readTypes(xmlContentDefinition, "");
            this.m_tabInfos = this.collectTabInfos(xmlContentDefinition);
        }

        private List<TabInfo> collectTabInfos(CmsXmlContentDefinition definition) {
            ArrayList<TabInfo> result = new ArrayList<TabInfo>();
            if (definition.getContentHandler().getTabs() != null) {
                for (CmsXmlContentTab xmlTab : definition.getContentHandler().getTabs()) {
                    String tabName = this.m_messages.keyDefault("label." + definition.getInnerName() + "." + xmlTab.getTabName(), xmlTab.getTabName());
                    result.add(new TabInfo(tabName, xmlTab.getIdName(), xmlTab.getStartName(), xmlTab.isCollapsed()));
                }
            }
            return result;
        }

        private String getHelp(I_CmsXmlSchemaType value) {
            StringBuffer result = new StringBuffer(64);
            result.append("label.");
            result.append(this.getTypeKey(value));
            result.append(".help");
            return this.m_messages.keyDefault(result.toString(), value.getName());
        }

        private String getLabel(I_CmsXmlSchemaType value) {
            StringBuffer result = new StringBuffer(64);
            result.append("label.");
            result.append(this.getTypeKey(value));
            return this.m_messages.keyDefault(result.toString(), value.getName());
        }

        private String getTypeKey(I_CmsXmlSchemaType value) {
            StringBuffer result = new StringBuffer(64);
            result.append(value.getContentDefinition().getInnerName());
            result.append('.');
            result.append(value.getName());
            return result.toString();
        }

        private AttributeConfiguration readConfiguration(A_CmsXmlContentValue schemaType, String path) {
            AttributeConfiguration result = null;
            String widgetName = null;
            String widgetConfig = null;
            CmsObject cms = CmsContentService.this.getCmsObject();
            try {
                I_CmsWidget widget = schemaType.getContentDefinition().getContentHandler().getWidget(schemaType);
                widgetName = widget.getClass().getName();
                widgetConfig = widget.getConfiguration();
                if (widget instanceof I_CmsADEWidget) {
                    I_CmsADEWidget adeWidget = (I_CmsADEWidget)widget;
                    widgetName = adeWidget.getWidgetName();
                    widgetConfig = adeWidget.getConfiguration(cms, schemaType, this.m_messages, this.m_file);
                    if (!adeWidget.isInternal() && !this.m_widgetConfigurations.containsKey(widgetName)) {
                        CmsExternalWidgetConfiguration externalConfiguration = new CmsExternalWidgetConfiguration(widgetName, adeWidget.getInitCall(), adeWidget.getJavaScriptResourceLinks(cms), adeWidget.getCssResourceLinks(cms));
                        this.m_widgetConfigurations.put(widgetName, externalConfiguration);
                    }
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            result = new AttributeConfiguration(this.getLabel(schemaType), this.getHelp(schemaType), widgetName, widgetConfig, this.readDefaultValue(schemaType, path));
            return result;
        }

        private String readDefaultValue(I_CmsXmlSchemaType schemaType, String path) {
            return this.m_contentHandler.getDefault(CmsContentService.this.getCmsObject(), this.m_file, schemaType, path, this.m_locale);
        }

        private void readTypes(CmsXmlContentDefinition xmlContentDefinition, String path) {
            String typeName = CmsContentService.getTypeUri(xmlContentDefinition);
            if (this.m_registeredTypes.containsKey(typeName)) {
                return;
            }
            Type type = new Type(typeName);
            type.setChoiceMaxOccurrence(xmlContentDefinition.getChoiceMaxOccurs());
            this.m_registeredTypes.put(typeName, (I_Type)type);
            if (type.isChoice()) {
                Type choiceType = new Type(typeName + "/" + "ATTRIBUTE_CHOICE");
                this.m_registeredTypes.put(choiceType.getId(), (I_Type)choiceType);
                type.addAttribute("ATTRIBUTE_CHOICE", choiceType.getId(), 1, xmlContentDefinition.getChoiceMaxOccurs());
                type = choiceType;
            }
            for (I_CmsXmlSchemaType subType : xmlContentDefinition.getTypeSequence()) {
                String subTypeName = null;
                String childPath = path + "/" + subType.getName();
                String subAttributeName = CmsContentService.this.getAttributeName(subType.getName(), typeName);
                AttributeConfiguration config = this.readConfiguration((A_CmsXmlContentValue)subType, childPath);
                if (config != null) {
                    this.m_attributeConfigurations.put(subAttributeName, config);
                }
                if (subType.isSimpleType()) {
                    subTypeName = CmsContentService.TYPE_NAME_PREFIX + subType.getTypeName();
                    if (!this.m_registeredTypes.containsKey(subTypeName)) {
                        this.m_registeredTypes.put(subTypeName, (I_Type)new Type(subTypeName));
                    }
                } else {
                    CmsXmlContentDefinition subTypeDefinition = ((CmsXmlNestedContentDefinition)subType).getNestedContentDefinition();
                    subTypeName = CmsContentService.getTypeUri(subTypeDefinition);
                    this.readTypes(subTypeDefinition, childPath);
                }
                type.addAttribute(subAttributeName, subTypeName, subType.getMinOccurs(), subType.getMaxOccurs());
            }
        }
    }
}

